/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv.crl.manager;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.Name;
import com.initech.cpv.crl.CRLDPEntry;
import com.initech.cpv.crl.manager.CRLManagerException;
import com.initech.cpv.crl.manager.CRLStoreManager;
import com.initech.cpv.util.Debug;
import com.initech.x509.CRLs;
import com.initech.x509.extensions.AuthorityKeyIdentifier;
import com.initech.x509.extensions.CRLDistPoints;
import com.initech.x509.extensions.CRLNumber;
import com.initech.x509.extensions.DeltaCRLIndicator;
import com.initech.x509.extensions.DistPoint;
import com.initech.x509.extensions.FreshestCRL;
import com.initech.x509.extensions.IssuingDistPoint;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;

public class CRLManager {
    public static String a;
    public static CRLStoreManager b;

    public static void loadCRLStoreManager() {
        b = CRLStoreManager.getInstance(a);
    }

    public static void setStoreManagerConfigPath(String string) {
        a = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CRLs getCompleteCRLs(X509Certificate x509Certificate) throws CRLManagerException {
        CRLs cRLs;
        Object object = x509Certificate.getExtensionValue("2.5.29.31");
        CRLs cRLs2 = cRLs;
        cRLs = new CRLs();
        try {
            new Name(((Object)x509Certificate.getIssuerDN()).toString());
            object = new CRLDistPoints((byte[])object).elements();
            while (object.hasMoreElements()) {
                DistPoint distPoint = (DistPoint)object.nextElement();
                try {
                    CRLDPEntry cRLDPEntry = new CRLDPEntry();
                    cRLDPEntry.setDp(distPoint);
                    cRLDPEntry.setIssuerName(new Name(x509Certificate.getIssuerDN().getName()));
                    cRLDPEntry.setForDeltaCRL(false);
                    cRLs2.add(CRLManager.getCRL(cRLDPEntry));
                }
                catch (CRLManagerException cRLManagerException) {
                    Debug.handleException(cRLManagerException);
                    throw new CRLManagerException(cRLManagerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Debug.handleException(illegalArgumentException);
                    throw new CRLManagerException(illegalArgumentException);
                }
            }
            return cRLs2;
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.handleException((Exception)((Object)aSN1Exception));
            throw new CRLManagerException((Exception)((Object)aSN1Exception));
        }
    }

    public static X509CRL getCRL(CRLDPEntry cRLDPEntry) throws CRLManagerException {
        if (b == null) {
            CRLManager.loadCRLStoreManager();
        }
        return b.loadCRL(cRLDPEntry);
    }

    public static X509CRL getCRLfromCache(X509CRL x509CRL) throws CRLManagerException {
        Name name;
        if (b == null) {
            CRLManager.loadCRLStoreManager();
        }
        Object object = name;
        name = new Name(((Object)x509CRL.getIssuerDN()).toString());
        object = b.loadCachedCRLs((Name)object).elements();
        while (object.hasMoreElements()) {
            X509CRL x509CRL2 = (X509CRL)object.nextElement();
            if (!CRLManager.checkCRLMatch(x509CRL2, x509CRL)) continue;
            return x509CRL2;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCRLMatch(X509CRL object, X509CRL object2) throws CRLManagerException {
        DeltaCRLIndicator deltaCRLIndicator;
        CRLNumber cRLNumber;
        CRLNumber cRLNumber2;
        block21: {
            block20: {
                AuthorityKeyIdentifier authorityKeyIdentifier;
                AuthorityKeyIdentifier authorityKeyIdentifier2;
                byte[] byArray2;
                byte[] byArray;
                if (object == null) {
                    return false;
                }
                if (object.getExtensionValue("2.5.29.27") != null) throw new CRLManagerException("Complete CRL cannot have DeltaCRLIndicator extension.");
                if (object2 == null) {
                    return false;
                }
                if (!((Object)((X509CRL)object).getIssuerDN()).equals(((X509CRL)object2).getIssuerDN())) {
                    return false;
                }
                try {
                    byArray = object.getExtensionValue("2.5.29.35");
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    throw new CRLManagerException((Exception)((Object)aSN1Exception));
                }
                {
                    byArray2 = object2.getExtensionValue("2.5.29.35");
                    if (byArray == null) return false;
                    if (byArray2 == null) {
                        return false;
                    }
                    authorityKeyIdentifier2 = new AuthorityKeyIdentifier(byArray);
                }
                AuthorityKeyIdentifier authorityKeyIdentifier3 = authorityKeyIdentifier;
                {
                    authorityKeyIdentifier = new AuthorityKeyIdentifier(byArray2);
                    if (Arrays.equals(authorityKeyIdentifier2.getExtValue(), authorityKeyIdentifier3.getExtValue())) break block20;
                    return false;
                }
            }
            byte[] byArray = object.getExtensionValue("2.5.29.28");
            byte[] byArray3 = object2.getExtensionValue("2.5.29.28");
            if (byArray != null && byArray3 != null) {
                IssuingDistPoint issuingDistPoint;
                IssuingDistPoint issuingDistPoint2;
                try {
                    issuingDistPoint2 = new IssuingDistPoint(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    throw new CRLManagerException((Exception)((Object)aSN1Exception));
                }
                IssuingDistPoint issuingDistPoint3 = issuingDistPoint;
                {
                    issuingDistPoint = new IssuingDistPoint(byArray3);
                    if (!Arrays.equals(issuingDistPoint2.getExtValue(), issuingDistPoint3.getExtValue())) {
                        return false;
                    }
                    break block21;
                }
            }
            if (byArray != null) return false;
            if (byArray3 != null) {
                return false;
            }
        }
        byte[] byArray = object.getExtensionValue("2.5.29.20");
        object = byArray;
        Object object3 = object2;
        object2 = object3.getExtensionValue("2.5.29.20");
        byte[] byArray4 = object3.getExtensionValue("2.5.29.27");
        if (byArray == null) throw new CRLManagerException("Complete CRL's CRLNumber extension cannot be found.");
        if (object2 == null) throw new CRLManagerException("Delta CRL's CRLNumber extension cannot be found.");
        if (byArray4 == null) throw new CRLManagerException("Delta CRL's DeltaCRLIndicator extension cannot be found.");
        CRLNumber cRLNumber3 = cRLNumber2;
        try {
            cRLNumber2 = new CRLNumber((byte[])object);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.handleException((Exception)((Object)aSN1Exception));
            throw new CRLManagerException((Exception)((Object)aSN1Exception));
        }
        object = cRLNumber;
        {
            cRLNumber = new CRLNumber((byte[])object2);
        }
        object2 = deltaCRLIndicator;
        {
            deltaCRLIndicator = new DeltaCRLIndicator(byArray4);
            if (cRLNumber2.getCRLNumber().compareTo(object2.getDeltaCRLIndicator()) < 0) {
                return false;
            }
            if (cRLNumber3.getCRLNumber().compareTo(object.getCRLNumber()) < 0) return true;
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRLs getDeltaCRLs(X509Certificate x509Certificate) throws CRLManagerException {
        CRLs cRLs;
        Object object = x509Certificate.getExtensionValue("2.5.29.46");
        if (object != null) {
            CRLs cRLs2;
            CRLs cRLs32 = cRLs2;
            cRLs2 = new CRLs();
            new Name(((Object)x509Certificate.getIssuerDN()).toString());
            object = new FreshestCRL(object).elements();
            while (true) {
                if (!object.hasMoreElements()) return cRLs32;
                CRLs cRLs4 = cRLs32;
                DistPoint distPoint = (DistPoint)object.nextElement();
                CRLDPEntry cRLDPEntry = new CRLDPEntry();
                cRLDPEntry.setDp(distPoint);
                cRLDPEntry.setIssuerName(new Name(x509Certificate.getIssuerDN().getName()));
                cRLDPEntry.setForDeltaCRL(true);
                cRLs4.add(CRLManager.getCRL(cRLDPEntry));
                continue;
                break;
            }
            catch (CRLManagerException cRLManagerException) {
                Debug.handleException(cRLManagerException);
                throw new CRLManagerException(cRLManagerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Debug.handleException(illegalArgumentException);
                throw new CRLManagerException(illegalArgumentException);
                {
                    catch (ASN1Exception aSN1Exception) {
                        Debug.handleException((Exception)((Object)aSN1Exception));
                        throw new CRLManagerException((Exception)((Object)aSN1Exception));
                    }
                }
            }
        }
        object = cRLs;
        cRLs = new CRLs();
        Enumeration enumeration = CRLManager.getCompleteCRLs(x509Certificate).elements();
        block20: while (enumeration.hasMoreElements()) {
            Object object2 = ((X509CRL)enumeration.nextElement()).getExtensionValue("2.5.29.46");
            object2 = new FreshestCRL((byte[])object2).elements();
            while (true) {
                if (!object2.hasMoreElements()) continue block20;
                {
                    catch (Exception exception2) {
                        Debug.handleException(exception2);
                        throw new CRLManagerException(exception2);
                    }
                }
                byte[] byArray = object;
                DistPoint distPoint = (DistPoint)object2.nextElement();
                try {
                    CRLDPEntry cRLDPEntry = new CRLDPEntry();
                    cRLDPEntry.setDp(distPoint);
                    cRLDPEntry.setIssuerName(new Name(x509Certificate.getIssuerDN().getName()));
                    cRLDPEntry.setForDeltaCRL(true);
                    byArray.add(CRLManager.getCRL(cRLDPEntry));
                    continue block20;
                }
                catch (Exception exception) {
                    Debug.handleException(exception);
                    continue;
                }
                break;
            }
        }
        return object;
    }
}

