/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger;

import com.initech.inibase.logger.Hierarchy;
import com.initech.inibase.logger.Level;
import com.initech.inibase.logger.Logger;
import com.initech.inibase.logger.helpers.Loader;
import com.initech.inibase.logger.helpers.LogLog;
import com.initech.inibase.logger.helpers.OptionConverter;
import com.initech.inibase.logger.spi.DefaultRepositorySelector;
import com.initech.inibase.logger.spi.LoggerFactory;
import com.initech.inibase.logger.spi.LoggerRepository;
import com.initech.inibase.logger.spi.RepositorySelector;
import com.initech.inibase.logger.spi.RootLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public class LogManager {
    public static final String DEFAULT_CONFIGURATION_FILE = "inilog4j.properties";
    public static final String DEFAULT_CONFIGURATION_KEY = "inilog4j.configuration";
    public static final String CONFIGURATOR_CLASS_KEY = "inilog4j.configuratorClass";
    public static final String DEFAULT_INIT_OVERRIDE_KEY = "inilog4j.defaultInitOverride";
    public static Object a;
    public static RepositorySelector b;

    public static void setRepositorySelector(RepositorySelector repositorySelector, Object object) throws IllegalArgumentException {
        Object object2 = a;
        if (object2 != null && object2 != object) {
            throw new IllegalArgumentException("Attempted to reset the LoggerFactory without possessing the guard.");
        }
        if (repositorySelector != null) {
            a = object;
            b = repositorySelector;
            return;
        }
        throw new IllegalArgumentException("RepositorySelector must be non-null.");
    }

    public static LoggerRepository getLoggerRepository() {
        return b.getLoggerRepository();
    }

    public static Logger getRootLogger() {
        return b.getLoggerRepository().getRootLogger();
    }

    public static Logger getLogger(String string) {
        return b.getLoggerRepository().getLogger(string);
    }

    public static Logger getLogger(Class clazz) {
        return b.getLoggerRepository().getLogger(clazz.getName());
    }

    public static Logger getLogger(String string, LoggerFactory loggerFactory) {
        return b.getLoggerRepository().getLogger(string, loggerFactory);
    }

    public static Logger exists(String string) {
        return b.getLoggerRepository().exists(string);
    }

    public static Enumeration getCurrentLoggers() {
        return b.getLoggerRepository().getCurrentLoggers();
    }

    public static void shutdown() {
        b.getLoggerRepository().shutdown();
    }

    public static void resetConfiguration() {
        b.getLoggerRepository().resetConfiguration();
    }

    static {
        Hierarchy hierarchy;
        Object object = hierarchy;
        hierarchy = new Hierarchy(new RootLogger(Level.DEBUG));
        b = new DefaultRepositorySelector((LoggerRepository)object);
        object = OptionConverter.getSystemProperty(DEFAULT_INIT_OVERRIDE_KEY, null);
        if (object == null || "false".equalsIgnoreCase((String)object)) {
            URL uRL;
            object = OptionConverter.getSystemProperty(DEFAULT_CONFIGURATION_KEY, null);
            String string = OptionConverter.getSystemProperty(CONFIGURATOR_CLASS_KEY, null);
            if (object == null) {
                uRL = Loader.getResource("inilog4j.xml");
                if (uRL == null) {
                    uRL = Loader.getResource(DEFAULT_CONFIGURATION_FILE);
                }
            } else {
                URL uRL2;
                uRL = uRL2;
                try {
                    uRL2 = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = Loader.getResource((String)object);
                }
            }
            if (uRL != null) {
                LogLog.debug("Using URL [" + uRL + "] for automatic inilog4j configuration.");
                OptionConverter.selectAndConfigure(uRL, string, LogManager.getLoggerRepository());
            } else {
                LogLog.debug("Could not find resource: [" + (String)object + "].");
            }
        }
    }
}

