/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger.config;

import com.initech.beans.IntrospectionException;
import com.initech.beans.Introspector;
import com.initech.beans.PropertyDescriptor;
import com.initech.inibase.logger.Appender;
import com.initech.inibase.logger.Level;
import com.initech.inibase.logger.Priority;
import com.initech.inibase.logger.config.PropertySetterException;
import com.initech.inibase.logger.helpers.LogLog;
import com.initech.inibase.logger.helpers.OptionConverter;
import com.initech.inibase.logger.spi.OptionHandler;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;

public class PropertySetter {
    public Object obj;
    public PropertyDescriptor[] props;

    public PropertySetter(Object object) {
        this.obj = object;
    }

    public static void setProperties(Object object, Properties properties, String string) {
        new PropertySetter(object).setProperties(properties, string);
    }

    public void introspect() {
        try {
            this.props = Introspector.getBeanInfo(this.obj.getClass()).getPropertyDescriptors();
            return;
        }
        catch (IntrospectionException introspectionException) {
            LogLog.error("Failed to introspect " + this.obj + ": " + introspectionException.getMessage());
            this.props = new PropertyDescriptor[0];
            return;
        }
    }

    public void setProperties(Properties properties, String string) {
        int n2 = string.length();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string) || string2.indexOf(46, n2 + 1) > 0) continue;
            String string3 = string2;
            string2 = OptionConverter.findAndSubst(string2, properties);
            String string4 = string3.substring(n2);
            if ("layout".equals(string4) && this.obj instanceof Appender) continue;
            this.setProperty(string4, string2);
        }
        this.activate();
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string = Introspector.decapitalize(string));
        if (propertyDescriptor == null) {
            LogLog.warn("No such property [" + string + "] in " + this.obj.getClass().getName() + ".");
            return;
        }
        try {
            this.setProperty(propertyDescriptor, string, string2);
            return;
        }
        catch (PropertySetterException propertySetterException) {
            LogLog.warn("Failed to set property [" + string + "] to value \"" + string2 + "\". ", propertySetterException.rootCause);
            return;
        }
    }

    public void setProperty(PropertyDescriptor object, String string, String object2) throws PropertySetterException {
        if ((object = ((PropertyDescriptor)object).getWriteMethod()) != null) {
            Class<?>[] classArray = ((Method)object).getParameterTypes();
            if (classArray.length == 1) {
                block6: {
                    try {
                        object2 = this.convertArg((String)object2, classArray[0]);
                        if (object2 == null) break block6;
                    }
                    catch (Throwable throwable) {
                        throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed. Reason: " + throwable);
                    }
                    LogLog.debug("Setting property [" + string + "] to [" + object2 + "].");
                    try {
                        ((Method)object).invoke(this.obj, object2);
                    }
                    catch (Exception exception) {
                        throw new PropertySetterException(exception);
                    }
                    return;
                }
                throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed.");
            }
            throw new PropertySetterException("#params for setter != 1");
        }
        throw new PropertySetterException("No setter for property [" + string + "].");
    }

    public Object convertArg(String string, Class clazz) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (String.class.isAssignableFrom(clazz)) {
            return string;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return new Integer(string2);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return new Long(string2);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("true".equalsIgnoreCase(string2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return Boolean.FALSE;
            }
        } else if (Priority.class.isAssignableFrom(clazz)) {
            return OptionConverter.toLevel(string2, Level.DEBUG);
        }
        return null;
    }

    public PropertyDescriptor getPropertyDescriptor(String string) {
        if (this.props == null) {
            this.introspect();
        }
        int n2 = 0;
        while (true) {
            PropertyDescriptor[] propertyDescriptorArray = this.props;
            if (n2 >= this.props.length) break;
            if (string.equals(propertyDescriptorArray[n2].getName())) {
                return this.props[n2];
            }
            ++n2;
        }
        return null;
    }

    public void activate() {
        Object object = ((PropertySetter)object).obj;
        if (object instanceof OptionHandler) {
            ((OptionHandler)object).activateOptions();
        }
    }
}

