/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger.helpers;

import com.initech.inibase.logger.Level;
import com.initech.inibase.logger.PropertyConfigurator;
import com.initech.inibase.logger.helpers.Loader;
import com.initech.inibase.logger.helpers.LogLog;
import com.initech.inibase.logger.spi.Configurator;
import com.initech.inibase.logger.spi.LoggerRepository;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;

public class OptionConverter {
    public static String a = "${";
    public static char b = '}';
    public static int c = 2;
    public static int d = 1;

    public static String[] concatanateArrays(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = stringArray.length;
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        n2 = stringArray.length;
        int n3 = stringArray2.length;
        System.arraycopy(stringArray2, 0, stringArray3, n2, n3);
        return stringArray3;
    }

    public static String convertSpecialChars(String string) {
        StringBuffer stringBuffer;
        int n2 = string.length();
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 + 1;
            char c2 = string.charAt(n3);
            n3 = c2;
            if (c2 == '\\') {
                n3 = n4 + 1;
                if ((n4 = string.charAt(n4)) == 110) {
                    n4 = 10;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 102) {
                    n4 = 12;
                } else if (n4 == 8) {
                    n4 = 8;
                } else if (n4 == 34) {
                    n4 = 34;
                } else if (n4 == 39) {
                    n4 = 39;
                } else if (n4 == 92) {
                    n4 = 92;
                }
            } else {
                int n5 = n3;
                n3 = n4;
                n4 = n5;
            }
            stringBuffer2.append((char)n4);
        }
        return stringBuffer2.toString();
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (Throwable throwable) {
            LogLog.debug("Was not allowed to read system property \"" + string + "\".");
            return string2;
        }
    }

    public static Object instantiateByKey(Properties object, String string, Class clazz, Object object2) {
        if ((object = OptionConverter.findAndSubst(string, (Properties)object)) == null) {
            LogLog.error("Could not find value for key " + string);
            return object2;
        }
        return OptionConverter.instantiateByClassName(((String)object).trim(), clazz, object2);
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if ("true".equalsIgnoreCase(string = string.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        return bl;
    }

    public static int toInt(String string, int n2) {
        if (string != null) {
            string = string.trim();
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("[" + string + "] is not in proper int form.");
                numberFormatException.printStackTrace();
            }
        }
        return n2;
    }

    public static Level toLevel(String string, Level level) {
        if (string == null) {
            return level;
        }
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            if ("NULL".equalsIgnoreCase(string)) {
                return null;
            }
            return Level.toLevel(string, level);
        }
        String string2 = string;
        string = string2.substring(n2 + 1);
        String string3 = string2.substring(0, n2);
        if ("NULL".equalsIgnoreCase(string3)) {
            return null;
        }
        LogLog.debug("toLevel:class=[" + string + "]:pri=[" + string3 + "]");
        Class clazz = Loader.loadClass(string);
        Class[] classArray = new Class[2];
        Object[] objectArray = classArray;
        classArray[0] = String.class;
        classArray[1] = Level.class;
        Method method = clazz.getMethod("toLevel", (Class<?>[])objectArray);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        try {
            objectArray2[0] = string3;
            objectArray2[1] = level;
            level = (Level)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            LogLog.warn("class [" + string + "], level [" + string3 + "] conversion failed.", exception);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("class [" + string + "] cannot be instantiated due to access restrictions", illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            LogLog.warn("class [" + string + "] is not a subclass of com.initech.common.logger.Level", classCastException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogLog.warn("custom level class [" + string + "] could not be instantiated", invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("custom level class [" + string + "] does not have a constructor which takes one string parameter", noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.warn("custom level class [" + string + "] not found.");
        }
        return level;
    }

    public static long toFileSize(String string, long l2) {
        if (string == null) {
            return l2;
        }
        String string2 = string.trim().toUpperCase();
        long l3 = 1L;
        int n2 = string2.indexOf("KB");
        if (n2 != -1) {
            l3 = 1024L;
            string2 = string2.substring(0, n2);
        } else {
            n2 = string2.indexOf("MB");
            if (n2 != -1) {
                l3 = 0x100000L;
                string2 = string2.substring(0, n2);
            } else {
                n2 = string2.indexOf("GB");
                if (n2 != -1) {
                    l3 = 0x40000000L;
                    string2 = string2.substring(0, n2);
                }
            }
        }
        if (string2 != null) {
            try {
                return Long.valueOf(string2) * l3;
            }
            catch (NumberFormatException numberFormatException) {
                LogLog.error("[" + string2 + "] is not in proper int form.");
                LogLog.error("[" + string + "] not in expected format.", numberFormatException);
            }
        }
        return l2;
    }

    public static String findAndSubst(String string, Properties properties) {
        if ((string = properties.getProperty(string)) == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(string, properties);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.error("Bad option value [" + string + "].", illegalArgumentException);
            return string;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object instantiateByClassName(String string, Class clazz, Object object) {
        if (string == null) return object;
        Class clazz2 = clazz;
        Class clazz3 = Loader.loadClass(string);
        if (clazz2.isAssignableFrom(clazz3)) return clazz3.newInstance();
        Object object2 = object;
        LogLog.error("A \"" + string + "\" object is not assignable to a \"" + clazz.getName() + "\" variable.");
        LogLog.error("The class \"" + clazz.getName() + "\" was loaded by ");
        LogLog.error("[" + clazz.getClassLoader() + "] whereas object of type ");
        try {
            LogLog.error("\"" + clazz3.getName() + "\" was loaded by [" + clazz3.getClassLoader() + "].");
            return object2;
        }
        catch (Exception exception) {
            LogLog.error("Could not instantiate class [" + string + "].", exception);
        }
        return object;
    }

    public static String substVars(String string, Properties properties) throws IllegalArgumentException {
        int n2;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        int n3 = 0;
        while (true) {
            if ((n2 = string.indexOf(a, n3)) == -1) {
                if (n3 == 0) {
                    return string;
                }
                StringBuffer stringBuffer3 = stringBuffer2;
                stringBuffer3.append(string.substring(n3, string.length()));
                return stringBuffer3.toString();
            }
            stringBuffer2.append(string.substring(n3, n2));
            n3 = string.indexOf(b, n2);
            if (n3 == -1) break;
            String string2 = string.substring(n2 + c, n3);
            String string3 = OptionConverter.getSystemProperty(string2, null);
            if (string3 == null && properties != null) {
                string3 = properties.getProperty(string2);
            }
            if (string3 != null) {
                stringBuffer2.append(OptionConverter.substVars(string3, properties));
            }
            n3 += d;
        }
        throw new IllegalArgumentException("\"" + string + "\" has no closing brace. Opening brace at position " + n2 + '.');
    }

    public static void selectAndConfigure(URL uRL, String string, LoggerRepository loggerRepository) {
        Object object = uRL.getFile();
        if (string == null && object != null && ((String)object).endsWith(".xml")) {
            string = "com.initech.inibase.logger.xml.DOMConfigurator";
        }
        if (string != null) {
            LogLog.debug("Preferred configurator class: " + string);
            object = (Configurator)OptionConverter.instantiateByClassName(string, Configurator.class, null);
            if (object == null) {
                LogLog.error("Could not instantiate configurator [" + string + "].");
                return;
            }
        } else {
            PropertyConfigurator propertyConfigurator;
            object = propertyConfigurator;
            propertyConfigurator = new PropertyConfigurator();
        }
        object.doConfigure(uRL, loggerRepository);
    }
}

