/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.misc;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateUtil {
    public static void main(String[] object) {
        System.out.println("getLocalDateTime(format) => " + DateUtil.getLocalDateTime("yyyyMMddHHmmss"));
        object = DateUtil.getLocalDateTime("yyyyMMdd");
        System.out.println("getDatewithSpan(10(long),format) => " + DateUtil.getDatewithSpan(10L, (String)object));
        System.out.println("getDatewithSpan(getLocalDateTime(yyyyMMdd), 10(long), format) => " + DateUtil.getDatewithSpan(DateUtil.getLocalDateTime("yyyyMMdd"), 10, "yyyy/MM/dd"));
        System.out.println("getDatewithSpan(10(long)) => " + DateUtil.getDatewithSpan(10L));
        System.out.println("getDatewithSpan(getLocalDateTime(yyyyMMdd),10(int)) => " + DateUtil.getDatewithSpan(DateUtil.getLocalDateTime("yyyyMMdd"), 10));
        System.out.println("getKSTDate()  => " + DateUtil.getKSTDate());
        System.out.println("getKSTDate(format)  => " + DateUtil.getKSTDate("yyyyMMdd"));
        System.out.println("getKSTDateTime() => " + DateUtil.getKSTDateTime());
        System.out.println("getKSTDateTime(format) => " + DateUtil.getKSTDateTime("yyyy-MM-dd"));
        System.out.println("convertDateType(getLocalDateTime(yyyyMMdd)) => " + DateUtil.makeDateType(DateUtil.getLocalDateTime("yyyyMMdd")));
        System.out.println("convertDateTimeType(getLocalDateTime(yyyyMMddHHmmss)) => " + DateUtil.convertDateTimeType(DateUtil.getLocalDateTime("yyyyMMddHHmmss")));
        System.out.println("convertDateType(getLocalDateTime(yyyy-MM-dd)) => " + DateUtil.convertDateType(DateUtil.getLocalDateTime("yyyy-MM-dd")));
        System.out.println("convertDateFormat(getLocalDateTime(yyyyMMdd),format)) => " + DateUtil.convertDateFormat(DateUtil.getLocalDateTime("yyyyMMdd"), "yyyy-MM-dd"));
        System.out.println("convertDateFormat(getLocalDateTime(yyyyMMddHHmmss),format)) => " + DateUtil.convertDateFormat("20020430", "yyyy-MM-dd hh:mm:ss"));
        System.out.println("getWeekend(yyyyMMdd,format(Short),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEE)", Locale.KOREAN));
        object = Locale.ENGLISH;
        System.out.println("getWeekend(yyyyMMdd,format(Short),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEE)", (Locale)object));
        System.out.println("getWeekend(yyyyMMdd,format(Short),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEE)", Locale.CHINESE));
        System.out.println("getWeekend(yyyyMMdd,format(Short),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEE)", Locale.JAPANESE));
        System.out.println("getWeekend(yyyyMMdd,format(Short),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEE)", Locale.FRENCH));
        System.out.println("getWeekend(yyyyMMdd,format(Full),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEEE)", Locale.KOREAN));
        System.out.println("getWeekend(yyyyMMdd,format(Full),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEEE)", (Locale)object));
        System.out.println("getWeekend(yyyyMMdd,format(Full),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEEE)", Locale.CHINESE));
        System.out.println("getWeekend(yyyyMMdd,format(Full),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEEE)", Locale.JAPANESE));
        System.out.println("getWeekend(yyyyMMdd,format(Full),langage) => " + DateUtil.getWeekend(DateUtil.getLocalDateTime("yyyyMMdd"), "MM/dd (EEEE)", Locale.FRENCH));
    }

    public static String getLocalDateTime(String string) {
        long l2 = System.currentTimeMillis();
        return new SimpleDateFormat(string).format(new Date(l2));
    }

    public static String getLocalDateTime(String string, long l2) {
        return new SimpleDateFormat(string).format(new Date(l2));
    }

    public static String getDatewithSpan(long l2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(32400000, "KST"));
        l2 = System.currentTimeMillis() + l2 * 86400000L;
        return simpleDateFormat.format(new Date(l2));
    }

    public static String getDatewithSpan(long l2, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(32400000, "KST"));
        l2 = System.currentTimeMillis() + l2 * 86400000L;
        return simpleDateFormat.format(new Date(l2));
    }

    public static String getHourwithSpan(long l2, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(32400000, "KST"));
        l2 = System.currentTimeMillis() + l2 * 3600000L;
        return simpleDateFormat.format(new Date(l2));
    }

    public static String getDatewithSpan(String string, int n2) {
        Date date;
        SimpleDateFormat simpleDateFormat;
        try {
            simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            date = simpleDateFormat.parse(string, new ParsePosition(0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
        Calendar calendar = Calendar.getInstance(Locale.KOREA);
        calendar.clear();
        calendar.setTime(date);
        calendar.add(5, n2);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getDatewithSpan(String string, int n2, String object) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        SimpleDateFormat simpleDateFormat3 = simpleDateFormat2;
        try {
            simpleDateFormat2 = new SimpleDateFormat("yyyyMMdd");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
        SimpleDateFormat simpleDateFormat4 = simpleDateFormat;
        simpleDateFormat4((String)object);
        object = simpleDateFormat3.parse(string, new ParsePosition(0));
        Calendar calendar = Calendar.getInstance(Locale.KOREA);
        calendar.clear();
        calendar.setTime((Date)object);
        calendar.add(5, n2);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getKSTDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public static String getKSTDate(String string) {
        return new SimpleDateFormat(string).format(new Date());
    }

    public static String getKSTDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date());
    }

    public static String getKSTDateTime(String string) {
        return new SimpleDateFormat(string).format(new Date());
    }

    public static String makeDateType(String string) {
        if (string.length() != 0 && string != null) {
            if (string.length() != 8) {
                return "invalid length";
            }
            String string2 = string;
            string = string2.substring(0, 4);
            String string3 = string2.substring(4, 6);
            return string + "-" + string3 + "-" + string2.substring(6, 8);
        }
        return "";
    }

    public static String convertDateTimeType(String string) {
        if (string.length() == 0) {
            return "";
        }
        if (string.length() != 14) {
            return "invalid length";
        }
        String string2 = string;
        string = string2.substring(0, 4);
        String string3 = string2.substring(4, 6);
        String string4 = string2.substring(6, 8);
        String string5 = string2.substring(8, 10);
        String string6 = string2.substring(10, 12);
        return string + "-" + string3 + "-" + string4 + " " + string5 + ":" + string6 + ":" + string2.substring(12, 14);
    }

    public static String convertDateType(String string) {
        if (string.length() != 0 && string != null) {
            if (string.length() != 10) {
                return "invalid length";
            }
            String string2 = string;
            string = string2.substring(0, 4);
            String string3 = string2.substring(5, 7);
            return string3 + "/" + string2.substring(8, 10) + "/" + string;
        }
        return "";
    }

    public static String convertDateFormat(String string, String string2) {
        Object object = "yyyyMMdd";
        try {
            object = new SimpleDateFormat((String)object).parse(string, new ParsePosition(0));
        }
        catch (Exception exception) {
            System.err.println("Error of transFormatDate = " + exception.getMessage());
            return string;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)object);
        return new SimpleDateFormat(string2).format(calendar.getTime());
    }

    public static String getWeekend(String object, String string, Locale locale) {
        ParsePosition parsePosition;
        if (string == null) {
            string = "yyyyMMdd";
        }
        object = parsePosition;
        parsePosition = new ParsePosition(0);
        object = new SimpleDateFormat(string).parse((String)object, (ParsePosition)object);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)object);
        return new SimpleDateFormat(string, locale).format(calendar.getTime());
    }

    public static String getNowForamtDate(String string, Locale locale) {
        Calendar calendar = Calendar.getInstance();
        return new SimpleDateFormat(string, locale).format(calendar.getTime());
    }

    public static String getGMTDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy 'GMT'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }

    public static String getGMTDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " 'GMT'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }

    public static String getGMTDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }

    public static String getGMTDateTime(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " 'GMT'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }

    public static String getLastDay(String string, String string2) {
        Calendar calendar = Calendar.getInstance();
        int n2 = Integer.parseInt(string);
        calendar.set(n2, Integer.parseInt(string2), 1);
        calendar.add(5, -1);
        return String.valueOf(calendar.get(5));
    }
}

