/*
 * Decompiled with CFR 0.152.
 */
package com.initech.license.crypto.asn1;

import com.initech.license.crypto.CryptoException;
import com.initech.license.crypto.asn1.ASN1;
import com.initech.license.crypto.asn1.ASN1Exception;
import com.initech.license.crypto.asn1.ASN1Structure;
import com.initech.license.crypto.asn1.ASN1Type;
import com.initech.license.crypto.asn1.DERCoder;
import com.initech.license.crypto.asn1.DERInputStream;
import com.initech.license.crypto.asn1.NULL;
import com.initech.license.crypto.asn1.ObjectID;
import com.initech.license.crypto.asn1.SEQUENCE;
import java.io.IOException;
import java.util.Hashtable;

public class AlgorithmID
implements ASN1Structure {
    public static Hashtable c = new Hashtable();
    public static AlgorithmID dhKeyAgreement = new AlgorithmID("1.2.840.113549.1.3.1", "DH KeyAgreement", "DH");
    public static AlgorithmID rsaEncryption = new AlgorithmID("1.2.840.113549.1.1.1", "RSA Encryption", "RSA");
    public static AlgorithmID md2WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.2", "MD2withRSA Encryption", "MD2withRSA");
    public static AlgorithmID md5WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.4", "MD5WithRSA Encryption", "MD5withRSA");
    public static AlgorithmID sha1WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.5", "SHA1withRSA Encryption", "SHA1withRSA");
    public static AlgorithmID shaWithRSAEncryption = new AlgorithmID("1.3.14.3.2.29", "SHA1withRSA Encryption", "SHA1withRSA");
    public static AlgorithmID dsa = new AlgorithmID("1.3.14.3.2.12", "DSA", "DSA");
    public static AlgorithmID dsaWithSHA = new AlgorithmID("1.3.14.3.2.13", "DSAwithSHA", "DSA");
    public static AlgorithmID dsaWithSHA1 = new AlgorithmID("1.3.14.3.2.27", "DSAwithSHA1", "DSA");
    public static AlgorithmID kcdsa = new AlgorithmID("1.2.410.200004.1.1", "KCDSA", "KCDSA");
    public static AlgorithmID kcdsaWithHAS160 = new AlgorithmID("1.2.410.200004.1.8", "KCDSAwithHAS160", "KCDSAwithHAS160");
    public static AlgorithmID kcdsaWithSHA1 = new AlgorithmID("1.2.410.200004.1.9", "KCDSAwithSHA1", "KCDSAwithSHA1");
    public static AlgorithmID pbeWithMD2AndDES_CBC = new AlgorithmID("1.2.840.113549.1.5.1", "PBEwithMD2andDES-CBC", "PBEWithMD2AndDES");
    public static AlgorithmID pbeWithMD5AndDES_CBC = new AlgorithmID("1.2.840.113549.1.5.3", "PBEwithMD5andDES-CBC", "PBEWithMD5AndDES");
    public static AlgorithmID pbeWithHAS160AndSEED_CBC = new AlgorithmID("1.2.410.200004.13.1.5", "PBEwithHAS160andSEED-CBC", "PBEWithHAS160AndSEED");
    public static AlgorithmID pbeWithSHA1AndSEED_CBC = new AlgorithmID("1.2.410.200004.1.15", "PBEwithSHA1andSEED-CBC", "PBEWithSHA1AndSEED");
    public static AlgorithmID pbeWithSHAAndSEED_CBC = new AlgorithmID("1.2.410.200004.1.15", "PBEwithSHAandSEED-CBC", "PBEWithSHAAndSEED");
    public static AlgorithmID pbeWithSHA1AndSEED_CBC_SG = new AlgorithmID("1.2.410.200004.1.15.1", "PBEwithSHA1andSEED-CBC-SG", "PBEWithSHA1AndSEEDX");
    public static AlgorithmID pbeWithSHAAnd3_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.3", "PBEwithSHAand3KeyTripleDES-CBC", "PBEWithSHAAnd3DES");
    public static AlgorithmID pbeWithSHAAnd40BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.6", "PBEwithSHAand40BitRC2-CBC", "PBEWithSHAAnd40BitRC2");
    public static AlgorithmID rsa = new AlgorithmID("2.5.8.1.1", "RSA", "RSA");
    public static AlgorithmID elgamal = new AlgorithmID("1.3.14.7.2.1.1", "ElGamal", "ElGamal");
    public static AlgorithmID elgamalWithSHA1 = new AlgorithmID("1.3.14.7.2.1.3", "ElGamalWithSHA1", "SHA1withElGamal");
    public static AlgorithmID rc2_CBC = new AlgorithmID("1.2.840.113549.3.2", "RC2-CBC", "RC2/CBC/PKCS5Padding");
    public static AlgorithmID rc4 = new AlgorithmID("1.2.840.113549.3.4", "RC4", "RC4/ECB/PKCS5Padding");
    public static AlgorithmID des_EDE3_CBC = new AlgorithmID("1.2.840.113549.3.7", "DES-EDE3-CBC", "DESede/CBC/PKCS5Padding");
    public static AlgorithmID des_CBC = new AlgorithmID("1.3.14.3.2.7", "DES-CBC", "DES/CBC/PKCS5Padding");
    public static AlgorithmID cast5_CBC = new AlgorithmID("1.2.840.113533.7.66.10", "CAST5-CBC", "CAST5/CBC/PKCS5Padding");
    public static AlgorithmID seed_CBC = new AlgorithmID("1.2.410.200004.1.4", "SEED-CBC", "SEED/CBC/PKCS5Padding");
    public static AlgorithmID has160 = new AlgorithmID("1.2.410.200004.1.2", "HAS160", "HAS160");
    public static AlgorithmID md2 = new AlgorithmID("1.2.840.113549.2.2", "MD2", "MD2");
    public static AlgorithmID md4 = new AlgorithmID("1.2.840.113549.2.4", "MD4", null);
    public static AlgorithmID md5 = new AlgorithmID("1.2.840.113549.2.5", "MD5", "MD5");
    public static AlgorithmID sha;
    public static AlgorithmID sha1;
    public ObjectID a;
    public ASN1 b;

    public AlgorithmID() {
        this.b = null;
        this.a = null;
    }

    public AlgorithmID(String string, String string2, String string3) {
        ObjectID objectID;
        ObjectID objectID2 = objectID;
        objectID = new ObjectID(string, string2);
        this.a = objectID2;
        if (string3 != null) {
            c.put(objectID2, string3);
        }
        this.b = null;
    }

    public AlgorithmID(ObjectID objectID, ASN1 aSN1) {
        this.a = objectID;
        this.b = aSN1;
    }

    public AlgorithmID(ASN1 aSN1) throws ASN1Exception {
        AlgorithmID algorithmID = this;
        algorithmID.decode(aSN1);
    }

    public AlgorithmID(DERInputStream dERInputStream) throws IOException {
        AlgorithmID algorithmID = dERInputStream2;
        DERInputStream dERInputStream2 = dERInputStream.readSequence();
        algorithmID.a = dERInputStream2.readOid();
        try {
            algorithmID.b = new DERCoder().decode(dERInputStream2);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new IOException("\uc54c\uace0\ub9ac\uc998 \ub9e4\uac1c\ubcc0\uc218 \ubcf5\ud638\ud654 \uc624\ub958!");
        }
    }

    static {
        sha1 = sha = new AlgorithmID("1.3.14.3.2.26", "SHA", "SHA");
    }

    @Override
    public void decode(ASN1 aSN1) throws ASN1Exception {
        try {
            this.a = (ObjectID)aSN1.getComponentAt(0);
            this.b = aSN1.getComponentAt(1);
            return;
        }
        catch (Exception exception) {
            throw new ASN1Exception("ASN.1 AlgorithmID \ud0c0\uc785\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
    }

    @Override
    public ASN1 toASN1() {
        SEQUENCE sEQUENCE;
        SEQUENCE sEQUENCE2 = sEQUENCE;
        sEQUENCE2();
        sEQUENCE.addComponent(this.a);
        if (this.b == null) {
            NULL nULL;
            NULL nULL2 = nULL;
            nULL = new NULL();
            this.b = nULL2;
        }
        SEQUENCE sEQUENCE3 = sEQUENCE2;
        sEQUENCE3.addComponent(this.b);
        return sEQUENCE3;
    }

    public String getImplementationName() throws CryptoException {
        String string = (String)c.get(this.a);
        if (string != null) {
            return string;
        }
        throw new CryptoException(this.getName() + "\uc774 \uad6c\ud604\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
    }

    public Object clone() {
        AlgorithmID algorithmID;
        AlgorithmID algorithmID2 = algorithmID;
        algorithmID2();
        algorithmID2.b = this.b;
        algorithmID.a = this.a;
        return algorithmID;
    }

    public ObjectID getAlgorithm() {
        return this.a;
    }

    public String getOID() {
        return this.a.getID();
    }

    public ASN1 getParameter() {
        return this.b;
    }

    public void setParameter(ASN1 aSN1) {
        this.b = aSN1;
    }

    public String getName() {
        return this.a.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlgorithmID)) {
            return false;
        }
        return this.a.equals(((AlgorithmID)object).a);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer2();
        stringBuffer.append(((AlgorithmID)((Object)aSN1)).a.getName());
        ASN1 aSN1 = ((AlgorithmID)((Object)aSN1)).b;
        if (aSN1 != null && !aSN1.instanceOf(ASN1Type.Null)) {
            stringBuffer2.append("(\ub9e4\uac1c\ubcc0\uc218 \ud3ec\ud568)");
        }
        return stringBuffer2.toString();
    }
}

