/*
 * Decompiled with CFR 0.152.
 */
package com.initech.license.crypto.asn1;

import com.initech.license.crypto.asn1.ASN1;
import com.initech.license.crypto.asn1.ASN1Type;
import com.initech.license.crypto.asn1.ASN1Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitString
extends ASN1 {
    public int f;
    public byte[] g;

    public BitString() {
        this.TYPE = ASN1Type.BitString;
        this.g = null;
    }

    public BitString(byte[] byArray) {
        this();
        this.g = byArray;
        this.f = 0;
    }

    public BitString(byte[] byArray, int n2) {
        this();
        this.g = byArray;
        this.f = n2;
    }

    public BitString(boolean[] blArray) {
        this();
        int n2;
        int n3 = blArray.length;
        this.f = 8 - n3 % 8;
        this.g = new byte[(n3 + 7) / 8];
        for (n2 = 0; n2 < n3; ++n2) {
            byte[] byArray = this.g;
            int n4 = n2 / 8;
            this.g[n4] = (byte)(byArray[n4] << 1);
            if (!blArray[n2]) continue;
            byArray[n4] = (byte)(byArray[n4] + 1);
        }
        int n5 = this.f;
        if (n5 > 0) {
            int n6 = n2 / 8;
            this.g[n6] = (byte)(this.g[n6] << n5);
        }
    }

    public BitString(String string) {
        this();
        int n2;
        int n3 = string.length();
        this.f = (8 - n3 % 8) % 8;
        this.g = new byte[(n3 + 7) / 8];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2 / 8;
            this.g[n4] = (byte)(this.g[n4] << 1);
            if (string.charAt(n2) != '1') continue;
            this.g[n4] = (byte)(this.g[n4] + 1);
        }
        int n5 = this.f;
        if (n5 > 0) {
            int n6 = n2 / 8;
            this.g[n6] = (byte)(this.g[n6] << n5);
        }
    }

    @Override
    public void decode(InputStream inputStream, int n2) throws IOException {
        this.f = inputStream.read();
        byte[] byArray = new byte[n2 - 1];
        this.g = byArray;
        ASN1Util.fillArray(byArray, inputStream);
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.g);
        outputStream.write(this.f);
    }

    public String getBinaryString() {
        int n2;
        int n3;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < this.g.length - 1; ++n3) {
            for (n2 = 7; n2 >= 0; --n2) {
                if ((this.g[n3] & 1 << n2) != 0) {
                    stringBuffer2.append('1');
                    continue;
                }
                stringBuffer2.append('0');
            }
        }
        for (n2 = 7; n2 >= this.f; --n2) {
            if ((this.g[n3] & 1 << n2) != 0) {
                stringBuffer2.append('1');
                continue;
            }
            stringBuffer2.append('0');
        }
        return stringBuffer2.toString();
    }

    public int getPaddingBitSize() {
        return this.f;
    }

    @Override
    public Object getValue() {
        return this.g;
    }

    @Override
    public void setValue(Object object) {
        this.g = (byte[])object;
    }

    @Override
    public String toString() {
        return super.toString() + this.g.length + " \ubc14\uc774\ud2b8(" + this.f + " \ube44\ud2b8 \ud328\ub529 \ud3ec\ud568)";
    }
}

