/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs11.objects;

import com.initech.pkcs.pkcs11.PKCS11;
import com.initech.pkcs.pkcs11.PKCS11Constants;
import com.initech.pkcs.pkcs11.PKCS11Exception;
import com.initech.pkcs.pkcs11.data.CK_ATTRIBUTE;
import com.initech.pkcs.pkcs11.objects.Certificate;
import com.initech.pkcs.pkcs11.objects.Data;
import com.initech.pkcs.pkcs11.objects.LongAttribute;
import com.initech.pkcs.pkcs11.objects.PKCS11Attribute;
import com.initech.pkcs.pkcs11.objects.PrivateKey;
import com.initech.pkcs.pkcs11.objects.PublicKey;
import com.initech.pkcs.pkcs11.objects.SecretKey;
import com.initech.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import com.initech.x509.X509CertImpl;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class PKCS11Object
implements PKCS11Constants {
    public long objHandle;
    public LongAttribute objClass;
    public Vector a;

    public PKCS11Object() {
        Vector vector;
        LongAttribute longAttribute;
        ((PKCS11Object)object).objHandle = 0L;
        Object object = longAttribute;
        longAttribute = new LongAttribute(0L);
        v1.objClass = object;
        object = vector;
        vector = new Vector(10);
        v1.a = object;
    }

    public PKCS11Object(long l2) {
        PKCS11Object pKCS11Object = this;
        pKCS11Object();
        pKCS11Object.setObjectClass(l2);
    }

    public PKCS11Object(PKCS11 pKCS11, long l2, long l3) throws PKCS11Exception {
        PKCS11Object pKCS11Object = longAttribute;
        pKCS11Object();
        pKCS11Object.objHandle = l3;
        LongAttribute longAttribute = pKCS11Object.objClass;
        PKCS11Object.getAttributeValue(pKCS11, l2, l3, longAttribute);
    }

    public static CK_ATTRIBUTE[] getCkAttributes(PKCS11Object vector) {
        if ((vector = vector != null ? ((PKCS11Object)((Object)vector)).getCkAttributes() : null) == null) {
            return null;
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Object object = vector.elementAt(i2);
            object = object instanceof CK_ATTRIBUTE ? (CK_ATTRIBUTE)object : null;
            cK_ATTRIBUTEArray[i2] = object;
        }
        return cK_ATTRIBUTEArray;
    }

    public static PKCS11Object getInstance(PKCS11 pKCS11, long l2, long l3) throws PKCS11Exception {
        long[] lArray = new long[1];
        long[] lArray2 = lArray;
        lArray[0] = 0L;
        long l4 = pKCS11.C_GetAttributeValue(l2, l3, lArray2)[0].getLong();
        PKCS11Object pKCS11Object = null;
        if (l4 == 1L) {
            pKCS11Object = Certificate.getInstance(pKCS11, l2, l3);
        } else if (l4 == 3L) {
            pKCS11Object = PrivateKey.getInstance(pKCS11, l2, l3);
        } else if (l4 == 2L) {
            pKCS11Object = PublicKey.getInstance(pKCS11, l2, l3);
        } else if (l4 == 0L) {
            pKCS11Object = Data.getInstance(pKCS11, l2, l3);
        } else if (l4 == 4L) {
            pKCS11Object = SecretKey.getInstance(pKCS11, l2, l3);
        } else {
            long l5 = l4 - Integer.MIN_VALUE;
            int cfr_ignored_1 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
        }
        if (pKCS11Object != null) {
            pKCS11Object.setObjectHandle(l3);
        }
        return pKCS11Object;
    }

    public static PKCS11Object getInstance(Key key) throws PKCS11Exception {
        PKCS11Object pKCS11Object = null;
        if (key instanceof java.security.PublicKey) {
            pKCS11Object = PublicKey.getInstance((java.security.PublicKey)key);
        } else if (key instanceof java.security.PrivateKey) {
            pKCS11Object = PrivateKey.getInstance((java.security.PrivateKey)key);
        } else if (key instanceof javax.crypto.SecretKey) {
            pKCS11Object = SecretKey.getInstance((javax.crypto.SecretKey)key);
        }
        return pKCS11Object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PKCS11Object getInstance(java.security.cert.Certificate object) throws PKCS11Exception {
        X509CertImpl x509CertImpl;
        Object object2 = null;
        if (!(object instanceof X509Certificate)) return object2;
        if (object instanceof X509CertImpl) {
            object2 = object = (X509CertImpl)object;
            return X509PublicKeyCertificate.getInstance((X509Certificate)object2);
        }
        try {
            object = ((java.security.cert.Certificate)object).getEncoded();
        }
        catch (Exception exception) {
            throw new PKCS11Exception("X509 decoding fail!!");
        }
        object2 = x509CertImpl;
        {
            x509CertImpl = new X509CertImpl((byte[])object);
        }
        return X509PublicKeyCertificate.getInstance((X509Certificate)object2);
    }

    public static final void getAttributeValue(PKCS11 pKCS11, long l2, long l3, PKCS11Attribute pKCS11Attribute) throws PKCS11Exception {
        if (pKCS11 != null) {
            if (pKCS11Attribute != null) {
                PKCS11Exception pKCS11Exception2;
                block5: {
                    PKCS11Attribute pKCS11Attribute2 = pKCS11Attribute;
                    long l4 = pKCS11Attribute.getType();
                    try {
                        pKCS11Attribute2.setCkAttribute(pKCS11.C_GetAttributeValue(l2, l3, new long[]{l4})[0]);
                        pKCS11Attribute2.setPresent(true);
                        pKCS11Attribute2.setSensitive(false);
                    }
                    catch (PKCS11Exception pKCS11Exception2) {
                        if (pKCS11Exception2.getErrorCode() == 18L) {
                            PKCS11Attribute pKCS11Attribute3 = pKCS11Attribute;
                            pKCS11Attribute3.setPresent(false);
                            pKCS11Attribute3.setSensitive(false);
                        }
                        if (pKCS11Exception2.getErrorCode() != 17L) break block5;
                        PKCS11Attribute pKCS11Attribute4 = pKCS11Attribute;
                        pKCS11Attribute4.setPresent(true);
                        pKCS11Attribute4.setSensitive(true);
                    }
                    return;
                }
                throw pKCS11Exception2;
            }
            throw new PKCS11Exception("PKCS11Attribute must not be null");
        }
        throw new PKCS11Exception("PKCS11 module must not be null");
    }

    public LongAttribute getObjectClass() {
        return this.objClass;
    }

    public void setObjectClass(long l2) {
        this.objClass.setLongValue(l2);
    }

    public long getObjectHandle() {
        return this.objHandle;
    }

    public void setObjectHandle(long l2) {
        this.objHandle = l2;
    }

    public Vector getCkAttributes() {
        Vector<CK_ATTRIBUTE> vector;
        if (this.a.size() > 0) {
            return this.a;
        }
        Vector<CK_ATTRIBUTE> vector2 = vector;
        vector = new Vector<CK_ATTRIBUTE>(20);
        if (this.objClass.isPresent()) {
            vector2.addElement(this.objClass.getCkAttribute());
        }
        return vector2;
    }

    public void put(long l2, boolean bl) {
        CK_ATTRIBUTE cK_ATTRIBUTE;
        PKCS11Object pKCS11Object = cK_ATTRIBUTE2;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = cK_ATTRIBUTE;
        cK_ATTRIBUTE2();
        cK_ATTRIBUTE.type = l2;
        cK_ATTRIBUTE.value = new Boolean(bl);
        pKCS11Object.a.addElement(cK_ATTRIBUTE2);
    }

    public void put(long l2, long l3) {
        CK_ATTRIBUTE cK_ATTRIBUTE;
        PKCS11Object pKCS11Object = cK_ATTRIBUTE2;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = cK_ATTRIBUTE;
        cK_ATTRIBUTE2();
        cK_ATTRIBUTE.type = l2;
        cK_ATTRIBUTE.value = new Long(l3);
        pKCS11Object.a.addElement(cK_ATTRIBUTE2);
    }

    public void put(long l2, byte[] byArray) {
        CK_ATTRIBUTE cK_ATTRIBUTE;
        PKCS11Object pKCS11Object = cK_ATTRIBUTE2;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = cK_ATTRIBUTE;
        cK_ATTRIBUTE2();
        cK_ATTRIBUTE2.type = l2;
        cK_ATTRIBUTE.value = byArray;
        pKCS11Object.a.addElement(cK_ATTRIBUTE2);
    }

    public void put(long l2, String string) {
        CK_ATTRIBUTE cK_ATTRIBUTE;
        PKCS11Object pKCS11Object = cK_ATTRIBUTE2;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = cK_ATTRIBUTE;
        cK_ATTRIBUTE2();
        cK_ATTRIBUTE2.type = l2;
        cK_ATTRIBUTE.value = string;
        pKCS11Object.a.addElement(cK_ATTRIBUTE2);
    }

    public void clear() {
        this.a.clear();
    }
}

