/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs11.objects;

import com.initech.asn1.ASN1Exception;
import com.initech.pkcs.pkcs11.PKCS11;
import com.initech.pkcs.pkcs11.PKCS11Exception;
import com.initech.pkcs.pkcs11.objects.BooleanAttribute;
import com.initech.pkcs.pkcs11.objects.ByteArrayAttribute;
import com.initech.pkcs.pkcs11.objects.DHPublicKey;
import com.initech.pkcs.pkcs11.objects.DSAPublicKey;
import com.initech.pkcs.pkcs11.objects.Key;
import com.initech.pkcs.pkcs11.objects.PKCS11Attribute;
import com.initech.pkcs.pkcs11.objects.PKCS11Object;
import com.initech.pkcs.pkcs11.objects.RSAPublicKey;
import com.initech.x509.extensions.SubjectKeyIdentifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;

public class PublicKey
extends Key {
    public ByteArrayAttribute subject;
    public BooleanAttribute encrypt;
    public BooleanAttribute verify;
    public BooleanAttribute verify_recover;
    public BooleanAttribute wrap;

    public PublicKey() {
        BooleanAttribute booleanAttribute;
        BooleanAttribute booleanAttribute2;
        BooleanAttribute booleanAttribute3;
        BooleanAttribute booleanAttribute4;
        ByteArrayAttribute byteArrayAttribute;
        PublicKey publicKey = object;
        publicKey.setObjectClass(2L);
        Object object = byteArrayAttribute;
        byteArrayAttribute = new ByteArrayAttribute(257L);
        publicKey.subject = object;
        object = booleanAttribute4;
        booleanAttribute4 = new BooleanAttribute(260L);
        publicKey.encrypt = object;
        object = booleanAttribute3;
        booleanAttribute3 = new BooleanAttribute(266L);
        publicKey.verify = object;
        object = booleanAttribute2;
        booleanAttribute2 = new BooleanAttribute(267L);
        publicKey.verify_recover = object;
        object = booleanAttribute;
        booleanAttribute = new BooleanAttribute(262L);
        publicKey.wrap = object;
    }

    public PublicKey(PKCS11 pKCS11, long l2, long l3) throws PKCS11Exception {
        BooleanAttribute booleanAttribute;
        BooleanAttribute booleanAttribute2;
        BooleanAttribute booleanAttribute3;
        BooleanAttribute booleanAttribute4;
        ByteArrayAttribute byteArrayAttribute;
        PublicKey publicKey = object;
        PublicKey publicKey2 = object;
        PublicKey publicKey3 = object;
        PublicKey publicKey4 = object;
        PublicKey publicKey5 = object;
        super(pKCS11, l2, l3);
        publicKey5.setObjectClass(2L);
        Object object = byteArrayAttribute;
        byteArrayAttribute = new ByteArrayAttribute(257L);
        publicKey5.subject = object;
        object = booleanAttribute4;
        booleanAttribute4 = new BooleanAttribute(260L);
        publicKey5.encrypt = object;
        object = booleanAttribute3;
        booleanAttribute3 = new BooleanAttribute(266L);
        publicKey5.verify = object;
        object = booleanAttribute2;
        booleanAttribute2 = new BooleanAttribute(267L);
        publicKey5.verify_recover = object;
        object = booleanAttribute;
        booleanAttribute = new BooleanAttribute(262L);
        publicKey5.wrap = object;
        object = publicKey5.subject;
        PKCS11Object.getAttributeValue(pKCS11, l2, l3, (PKCS11Attribute)object);
        object = publicKey4.encrypt;
        PKCS11Object.getAttributeValue(pKCS11, l2, l3, (PKCS11Attribute)object);
        object = publicKey3.verify;
        PKCS11Object.getAttributeValue(pKCS11, l2, l3, (PKCS11Attribute)object);
        object = publicKey2.verify_recover;
        PKCS11Object.getAttributeValue(pKCS11, l2, l3, (PKCS11Attribute)object);
        object = publicKey.wrap;
        PKCS11Object.getAttributeValue(pKCS11, l2, l3, (PKCS11Attribute)object);
    }

    public static PKCS11Object getInstance(java.security.PublicKey publicKey) throws PKCS11Exception {
        block16: {
            DHPublicKey dHPublicKey;
            PublicKey publicKey2;
            if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
                RSAPublicKey rSAPublicKey;
                publicKey2 = rSAPublicKey;
                try {
                    rSAPublicKey = new RSAPublicKey(publicKey);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PKCS11Exception("Invalid RSA Public Key : " + invalidKeyException.getMessage());
                }
            }
            if (publicKey instanceof java.security.interfaces.DSAPublicKey) {
                DSAPublicKey dSAPublicKey;
                publicKey2 = dSAPublicKey;
                try {
                    dSAPublicKey = new DSAPublicKey(publicKey);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PKCS11Exception("Invalid DSA Public Key : " + invalidKeyException.getMessage());
                }
            }
            if (!(publicKey instanceof javax.crypto.interfaces.DHPublicKey)) break block16;
            publicKey2 = dHPublicKey;
            try {
                dHPublicKey = new DHPublicKey(publicKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PKCS11Exception("Invalid DH Public Key : " + invalidKeyException.getMessage());
            }
            try {
                PublicKey publicKey3 = publicKey2;
                publicKey3.setKeyID(new SubjectKeyIdentifier(publicKey).getKID());
                publicKey3.setVerify(true);
                publicKey3.setVerifyRecover(true);
                publicKey3.setWrap(true);
                publicKey3.setEncrypt(true);
                publicKey3.setCanDerive(true);
                return publicKey3;
            }
            catch (Exception exception) {
                throw new PKCS11Exception(exception.toString());
            }
        }
        throw new PKCS11Exception("Unsupported Key Type : " + publicKey.getClass());
    }

    public static PublicKey getInstance(X509Certificate object) throws InvalidKeyException {
        java.security.PublicKey publicKey;
        block16: {
            Object object2;
            PublicKey publicKey2;
            block15: {
                DSAPublicKey dSAPublicKey;
                block14: {
                    RSAPublicKey rSAPublicKey;
                    publicKey = ((Certificate)object).getPublicKey();
                    if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) break block14;
                    publicKey2 = rSAPublicKey;
                    rSAPublicKey = new RSAPublicKey(publicKey);
                    break block15;
                }
                if (!(publicKey instanceof java.security.interfaces.DSAPublicKey)) break block16;
                publicKey2 = dSAPublicKey;
                dSAPublicKey = new DSAPublicKey((java.security.interfaces.DSAPublicKey)publicKey);
            }
            Object object3 = object.getExtensionValue("2.5.29.14");
            if (object3 == null) {
                SubjectKeyIdentifier subjectKeyIdentifier;
                object3 = subjectKeyIdentifier;
                subjectKeyIdentifier = new SubjectKeyIdentifier(publicKey);
                object2 = object3;
            } else {
                SubjectKeyIdentifier subjectKeyIdentifier;
                object2 = subjectKeyIdentifier;
                try {
                    subjectKeyIdentifier = new SubjectKeyIdentifier(object3);
                }
                catch (ASN1Exception aSN1Exception) {
                    SubjectKeyIdentifier subjectKeyIdentifier2;
                    object2 = subjectKeyIdentifier2;
                    subjectKeyIdentifier2 = new SubjectKeyIdentifier(publicKey);
                }
            }
            publicKey2.setKeyID(object2.getKID());
            boolean[] blArray = ((X509Certificate)object).getKeyUsage();
            object = blArray;
            if (blArray.length >= 1 && object[0] != false) {
                PublicKey publicKey3 = publicKey2;
                publicKey3.setVerify(true);
                publicKey3.setVerifyRecover(true);
            }
            if (((Object)object).length >= 2 && object[1] != false) {
                PublicKey publicKey4 = publicKey2;
                publicKey4.setVerify(true);
                publicKey4.setVerifyRecover(true);
            }
            if (((Object)object).length >= 3 && object[2] != false) {
                publicKey2.setWrap(true);
            }
            if (((Object)object).length >= 4 && object[3] != false) {
                publicKey2.setEncrypt(true);
            }
            if (((Object)object).length >= 5 && object[4] != false) {
                publicKey2.setCanDerive(true);
            }
            if (((Object)object).length >= 6 && object[5] != false) {
                PublicKey publicKey5 = publicKey2;
                publicKey5.setVerify(true);
                publicKey5.setVerifyRecover(true);
            }
            if (((Object)object).length >= 7 && object[6] != false) {
                PublicKey publicKey6 = publicKey2;
                publicKey6.setVerify(true);
                publicKey6.setVerifyRecover(true);
            }
            return publicKey2;
        }
        throw new InvalidKeyException("Unsupported Key Type : " + publicKey.getClass());
    }

    public static PKCS11Object getInstance(PKCS11 pKCS11, long l2, long l3) throws PKCS11Exception {
        long[] lArray = new long[1];
        long[] lArray2 = lArray;
        lArray[0] = 256L;
        long l4 = pKCS11.C_GetAttributeValue(l2, l3, lArray2)[0].getLong();
        PKCS11Object pKCS11Object = null;
        if (l4 == 0L) {
            pKCS11Object = RSAPublicKey.getInstance(pKCS11, l2, l3);
        } else if (l4 == 1L) {
            pKCS11Object = DSAPublicKey.getInstance(pKCS11, l2, l3);
        } else if (l4 == 2L) {
            pKCS11Object = DHPublicKey.getInstance(pKCS11, l2, l3);
        } else {
            long l5 = l4 - 3L;
            int cfr_ignored_1 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
        }
        return pKCS11Object;
    }

    public ByteArrayAttribute getSubject() {
        return this.subject;
    }

    public BooleanAttribute usageEncrypt() {
        return this.encrypt;
    }

    public BooleanAttribute usageVerify() {
        return this.verify;
    }

    public BooleanAttribute usageVerifyRecover() {
        return this.verify_recover;
    }

    public BooleanAttribute usageWrap() {
        return this.wrap;
    }

    public void setSubject(byte[] byArray) {
        this.subject.setBytes(byArray);
    }

    public void setEncrypt(boolean bl) {
        this.encrypt.setBooleanValue(bl);
    }

    public void setVerify(boolean bl) {
        this.verify.setBooleanValue(bl);
    }

    public void setVerifyRecover(boolean bl) {
        this.verify_recover.setBooleanValue(bl);
    }

    public void setWrap(boolean bl) {
        this.wrap.setBooleanValue(bl);
    }

    @Override
    public Vector getCkAttributes() {
        PublicKey publicKey = this;
        Vector vector = super.getCkAttributes();
        if (publicKey.subject.isPresent()) {
            vector.addElement(this.subject.getCkAttribute());
        }
        if (this.encrypt.isPresent()) {
            vector.addElement(this.encrypt.getCkAttribute());
        }
        if (this.verify.isPresent()) {
            vector.addElement(this.verify.getCkAttribute());
        }
        if (this.verify_recover.isPresent()) {
            vector.addElement(this.verify_recover.getCkAttribute());
        }
        if (this.wrap.isPresent()) {
            vector.addElement(this.wrap.getCkAttribute());
        }
        return vector;
    }

    public java.security.PublicKey getAsPublicKey() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        return null;
    }
}

