/*
 * Decompiled with CFR 0.152.
 */
package com.initech.xsafe.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.initech.xsafe.util.AndroidExternalStorage;
import com.initech.xsafe.util.ContextManager;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class StorageUtil {
    public static String getExternalBasePath() {
        if (AndroidExternalStorage.isWritable()) {
            return Environment.getExternalStorageDirectory().getPath() + "/";
        }
        return "/mnt" + Environment.getExternalStorageDirectory().getPath() + "/";
    }

    public static String getInternalBasePath(Context context) {
        Context context2;
        return context != null ? context2.getFilesDir().getAbsolutePath() + "/" : null;
    }

    public static ArrayList<String> getInternalOtherBasePathList(Context context) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (context != null) {
            Context context2;
            arrayList2.add(context2.getApplicationInfo().dataDir + "/");
        }
        return arrayList2;
    }

    public static boolean isExternalPath(String path) {
        String string = StorageUtil.getExternalBasePath();
        return path.toLowerCase().contains(string.toLowerCase());
    }

    public static boolean isInternalPath(Context context, String path) {
        String string;
        string = StorageUtil.getInternalBasePath((Context)string);
        return path.toLowerCase().contains(string.toLowerCase());
    }

    public static boolean isExternalStorageAvailable() {
        return StorageUtil.isExternalStorageAvailable(ContextManager.getContext());
    }

    public static boolean isExternalStorageAvailable(Context context) {
        File file;
        File file2;
        if (!AndroidExternalStorage.isWritable()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 23 && file2.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == -1) {
            return false;
        }
        file2 = file;
        if (new File(StorageUtil.getExternalBasePath() + "NPKI").exists()) {
            return file2.canWrite();
        }
        return file2.mkdir();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canFileRead(String filePath) {
        void var1_5;
        Object object;
        block31: {
            FileInputStream fileInputStream;
            byte[] byArray;
            block29: {
                boolean bl;
                block30: {
                    Exception exception2;
                    block28: {
                        Object var3_8;
                        FileInputStream fileInputStream2;
                        block26: {
                            block27: {
                                DataInputStream dataInputStream;
                                FileInputStream fileInputStream3;
                                bl = true;
                                fileInputStream2 = null;
                                var3_8 = null;
                                byArray = null;
                                if (filePath == null) throw new NullPointerException("File path is null.");
                                if (!new File((String)object).exists()) break block26;
                                fileInputStream = fileInputStream3;
                                fileInputStream3 = new FileInputStream((String)object);
                                object = dataInputStream;
                                dataInputStream = new DataInputStream(fileInputStream);
                                int n2 = dataInputStream.available();
                                if (n2 <= 0) break block27;
                                Object object2 = object;
                                FileInputStream fileInputStream4 = fileInputStream;
                                byArray = new byte[n2];
                                ((DataInputStream)object).readFully(byArray);
                                try {
                                    Arrays.fill(byArray, (byte)0);
                                    fileInputStream4.close();
                                    ((FilterInputStream)object2).close();
                                    return bl;
                                }
                                catch (IOException iOException) {
                                    return bl;
                                }
                            }
                            try {
                                throw new Exception("Invalid file size.");
                            }
                            catch (Exception exception2) {
                                break block28;
                            }
                            catch (Throwable throwable) {
                                object = var3_8;
                                break block29;
                            }
                            catch (Exception exception2) {
                                object = var3_8;
                                break block28;
                            }
                        }
                        try {
                            throw new FileNotFoundException((String)object);
                        }
                        catch (Throwable throwable) {}
                        catch (Exception exception2) {}
                        finally {
                            object = var3_8;
                            fileInputStream = fileInputStream2;
                            break block29;
                        }
                    }
                    exception2.printStackTrace();
                    bl = false;
                    if (byArray == null) break block30;
                    Arrays.fill(byArray, (byte)0);
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (object == null) return bl;
                ((FilterInputStream)object).close();
                return bl;
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (byArray != null) {
                Arrays.fill(byArray, (byte)0);
            }
            if (fileInputStream == null) break block31;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw var1_5;
            }
        }
        if (object == null) throw var1_5;
        ((FilterInputStream)object).close();
        throw var1_5;
    }
}

