/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.ocsp.extensions;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Extension;
import java.math.BigInteger;
import java.util.Date;

public class CrlID
extends Extension {
    public static final String OID = "1.3.6.1.5.5.7.48.1.3";
    public String crlUrl;
    public BigInteger crlNum;
    public Date crlTime;

    public CrlID() {
        CrlID crlID = this;
        crlID.setExtensionID(OID);
        crlID.setCritical(false);
    }

    public CrlID(byte[] byArray) throws ASN1Exception {
        this();
        this.extVal = (byte[])byArray.clone();
        this.decodeExtValue0();
    }

    public CrlID(String string2, BigInteger bigInteger, Date date) {
        this();
        this.crlUrl = string2;
        this.crlNum = bigInteger;
        this.crlTime = date;
    }

    public String getCRLUrl() {
        return this.crlUrl;
    }

    public BigInteger getCRLNumber() {
        return this.crlNum;
    }

    public Date getCRLTime() {
        return this.crlTime;
    }

    public void setCRLUrl(String string2) {
        CrlID crlID = this;
        crlID.crlUrl = string2;
        crlID.modified = true;
    }

    public void setCRLNum(BigInteger bigInteger) {
        CrlID crlID = this;
        crlID.crlNum = bigInteger;
        crlID.modified = true;
    }

    public void setCRLTime(Date date) {
        CrlID crlID = this;
        crlID.crlTime = date;
        crlID.modified = true;
    }

    public void encodeExtValue() throws ASN1Exception {
        int n2;
        DEREncoder dEREncoder;
        DEREncoder dEREncoder2 = dEREncoder;
        int n3 = new DEREncoder().encodeSequence();
        if (this.crlUrl != null) {
            DEREncoder dEREncoder3 = dEREncoder2;
            n2 = dEREncoder2.encodeExplicit(ASN1Tag.makeContextTag((int)0));
            dEREncoder3.encodeIA5String(this.crlUrl);
            dEREncoder3.endOf(n2);
        }
        if (this.crlNum != null) {
            DEREncoder dEREncoder4 = dEREncoder2;
            n2 = dEREncoder2.encodeExplicit(ASN1Tag.makeContextTag((int)1));
            dEREncoder4.encodeInteger(this.crlNum);
            dEREncoder4.endOf(n2);
        }
        if (this.crlTime != null) {
            DEREncoder dEREncoder5 = dEREncoder2;
            n2 = dEREncoder2.encodeExplicit(ASN1Tag.makeContextTag((int)2));
            dEREncoder5.encodeGeneralizedTime(this.crlTime);
            dEREncoder5.endOf(n2);
        }
        DEREncoder dEREncoder6 = dEREncoder2;
        dEREncoder6.endOf(n3);
        this.extVal = dEREncoder6.toByteArray();
    }

    public void decodeExtValue() throws ASN1Exception {
        int n2;
        DERDecoder dERDecoder;
        DERDecoder dERDecoder2 = dERDecoder;
        int n3 = new DERDecoder(this.extVal).decodeSequence();
        if (dERDecoder2.nextIsOptional(ASN1Tag.makeExplicitTag((int)0))) {
            this.crlUrl = null;
        } else {
            DERDecoder dERDecoder3 = dERDecoder2;
            n2 = dERDecoder3.decodeExplicit(ASN1Tag.makeContextTag((int)0));
            this.crlUrl = dERDecoder3.decodeIA5String();
            dERDecoder2.endOf(n2);
        }
        if (dERDecoder2.nextIsOptional(ASN1Tag.makeExplicitTag((int)1))) {
            this.crlNum = null;
        } else {
            DERDecoder dERDecoder4 = dERDecoder2;
            n2 = dERDecoder4.decodeExplicit(ASN1Tag.makeContextTag((int)1));
            this.crlNum = dERDecoder4.decodeInteger();
            dERDecoder2.endOf(n2);
        }
        if (dERDecoder2.nextIsOptional(ASN1Tag.makeExplicitTag((int)2))) {
            this.crlTime = null;
        } else {
            DERDecoder dERDecoder5 = dERDecoder2;
            int n4 = dERDecoder5.decodeExplicit(ASN1Tag.makeContextTag((int)2));
            this.crlTime = dERDecoder5.decodeGeneralizedTime();
            dERDecoder2.endOf(n4);
        }
        dERDecoder2.endOf(n3);
    }

    public boolean shouldOmitted() {
        return this.crlUrl == null && this.crlNum == null && this.crlTime == null;
    }
}

