/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.x509;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.useful.AnotherName;
import com.initech.asn1.useful.GeneralName;
import com.initech.core.crypto.INIMessageDigest;
import com.initech.core.x509.IdentifyData;
import com.initech.core.x509.VIDUserInfo;
import com.initech.pki.util.Hex;
import com.initech.x509.extensions.AuthorityInfoAccess;
import com.initech.x509.extensions.AuthorityKeyIdentifier;
import com.initech.x509.extensions.CRLDistPoints;
import com.initech.x509.extensions.CertificatePolicies;
import com.initech.x509.extensions.SubjectKeyIdentifier;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;

public class X509CertImpl
extends com.initech.x509.X509CertImpl {
    public int a;
    public BigInteger b;
    public String c;
    public String d;
    public String e;
    public Date f;
    public Date g;
    public String h;
    public byte[] i;
    public String j;
    public String k;
    public String l;
    public String m;
    public String n;
    public String o;
    public String p;
    public String q;
    public byte[] r;
    public byte[] s;

    public X509CertImpl(byte[] byArray) throws Exception {
        X509CertImpl x509CertImpl = this;
        super(byArray);
        x509CertImpl.a(byArray);
    }

    public final void a(byte[] object) throws Exception {
        GeneralName generalName;
        Object object2;
        ASN1OID aSN1OID;
        com.initech.x509.X509CertImpl x509CertImpl;
        X509CertImpl x509CertImpl2 = this;
        com.initech.x509.X509CertImpl x509CertImpl3 = x509CertImpl;
        x509CertImpl2.setVersion(new com.initech.x509.X509CertImpl(object).getVersion());
        x509CertImpl2.setSerialNumber(x509CertImpl3.getSerialNumber());
        x509CertImpl2.setSubjectDN(((Object)x509CertImpl3.getSubjectDN()).toString());
        x509CertImpl2.setIssuerDN(x509CertImpl3.getIssuerDN().getName());
        x509CertImpl2.setSigAlgName(x509CertImpl3.getSigAlgName());
        x509CertImpl2.setNotBefore(x509CertImpl3.getNotBefore());
        x509CertImpl2.setNotAfter(x509CertImpl3.getNotAfter());
        x509CertImpl2.setPublicKeyAlgName(x509CertImpl3.getPublicKey().getAlgorithm());
        x509CertImpl2.setPublicKey(x509CertImpl3.getPublicKey().getEncoded());
        if (x509CertImpl3.getPublicKey().getAlgorithm().toUpperCase().indexOf("RSA") != -1) {
            this.setPublicKeyAlgInfo(x509CertImpl3.getPublicKey().getAlgorithm() + "(" + ((RSAPublicKey)x509CertImpl3.getPublicKey()).getModulus().bitLength() + " bits)");
        } else {
            this.setPublicKeyAlgInfo(x509CertImpl3.getPublicKey().getAlgorithm());
        }
        object = x509CertImpl3.getExtensionValue("2.5.29.14");
        if (object != null) {
            this.setSubjectKeyIndent(new SubjectKeyIdentifier(object).toString());
        }
        object = aSN1OID;
        aSN1OID = new ASN1OID("2.5.29.35");
        if ((object = x509CertImpl3.getExtensionValue((ASN1OID)object)) != null) {
            this.setAuthorityKey(new AuthorityKeyIdentifier(object).toString());
        }
        boolean[] blArray = x509CertImpl3.getKeyUsage();
        object = blArray;
        if (blArray != null) {
            object2 = "";
            GeneralName generalName2 = new String[9];
            generalName = generalName2;
            generalName2[0] = "Digital Signature";
            generalName2[1] = "Non-Repudiation";
            generalName2[2] = "KeyEncipherment";
            generalName2[3] = "DataEncipherment";
            generalName2[4] = "KeyAgreement";
            generalName2[5] = "KeyCertSign";
            generalName2[6] = "CRLSign";
            generalName2[7] = "EncipherOnly";
            generalName2[8] = "DecipherOnly";
            for (int i2 = 0; i2 < ((byte[])object).length; ++i2) {
                if (object[i2] == 0) continue;
                object2 = (String)object2 + (String)generalName[i2] + "\r\n";
            }
            this.setKeyUsage((String)object2);
        }
        if ((object = x509CertImpl3.getExtensionValue("2.5.29.17")) != null && object != null) {
            object = null;
            object2 = x509CertImpl3.getSubjectAltName().elements();
            while (object2.hasMoreElements()) {
                IdentifyData identifyData;
                generalName = (GeneralName)object2.nextElement();
                if (generalName.getType() != 0 || !(generalName = (AnotherName)generalName.getGeneralNameInterface()).getOID().equals((Object)"1.2.410.200004.10.1.1")) continue;
                object = generalName.getBytes();
                object2 = identifyData;
                ((IdentifyData)object2)();
                try {
                    identifyData.decode((byte[])object);
                }
                catch (ASN1Exception aSN1Exception) {}
                VIDUserInfo vIDUserInfo = ((IdentifyData)object2).getUserInfo();
                object = vIDUserInfo;
                if (vIDUserInfo != null) {
                    if ((object = object.getVID()) != null) {
                        object = object.getHashedData();
                        break;
                    }
                    throw new Exception("ASN1 Decode exception occured");
                }
                throw new Exception("ASN1 Decode exception occured");
            }
            this.setVid((byte[])object);
            this.setSubjectAltName(x509CertImpl3.getSubjectAltName().toString());
        }
        if ((object = x509CertImpl3.getExtensionValue("2.5.29.31")) != null) {
            this.setCrlDistPoint(new CRLDistPoints(object).toString());
        }
        if ((object = x509CertImpl3.getExtensionValue("1.3.6.1.5.5.7.1.1")) != null) {
            this.setAia(new AuthorityInfoAccess(object).toString());
        }
        if ((object = x509CertImpl3.getExtensionValue("2.5.29.32")) != null) {
            this.setPolicy(new CertificatePolicies(object).toString());
        }
        this.setThumbPrint(new INIMessageDigest().doDigest(x509CertImpl3.getEncoded(), "SHA1"));
    }

    public int getVersion() {
        return this.a;
    }

    public void setVersion(int n2) {
        this.a = n2;
    }

    public BigInteger getSerialNumber() {
        return this.b;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.b = bigInteger;
    }

    public String getSubjectDn() {
        return this.c;
    }

    public void setSubjectDN(String string2) {
        this.c = string2;
    }

    public String getIssuerDn() {
        return this.d;
    }

    public void setIssuerDN(String string2) {
        this.d = string2;
    }

    public String getSigAlgName() {
        return this.e;
    }

    public void setSigAlgName(String string2) {
        this.e = string2;
    }

    public Date getNotBefore() {
        return this.f;
    }

    public void setNotBefore(Date date) {
        this.f = date;
    }

    public Date getNotAfter() {
        return this.g;
    }

    public void setNotAfter(Date date) {
        this.g = date;
    }

    public String getPublicKeyAlgName() {
        return this.h;
    }

    public void setPublicKeyAlgName(String string2) {
        this.h = string2;
    }

    public byte[] getPublicKeyByte() {
        return this.i;
    }

    public void setPublicKey(byte[] byArray) {
        X509CertImpl x509CertImpl = object;
        byte[] byArray2 = new byte[byArray.length];
        Object object = byArray2;
        x509CertImpl.i = byArray2;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n2);
    }

    public String getPublicKeyAlgInfo() {
        return this.j;
    }

    public void setPublicKeyAlgInfo(String string2) {
        this.j = string2;
    }

    public String getSubjectKeyIndent() {
        return this.k;
    }

    public void setSubjectKeyIndent(String string2) {
        this.k = string2;
    }

    public String getAuthorityKey() {
        return this.l;
    }

    public void setAuthorityKey(String string2) {
        this.l = string2;
    }

    public String getKeyUsages() {
        return this.m;
    }

    public void setKeyUsage(String string2) {
        this.m = string2;
    }

    public String getSubjectAltNames() {
        return this.n;
    }

    public void setSubjectAltName(String string2) {
        this.n = string2;
    }

    public String getCrlDistPoint() {
        return this.o;
    }

    public void setCrlDistPoint(String string2) {
        this.o = string2;
    }

    public String getAia() {
        return this.p;
    }

    public void setAia(String string2) {
        this.p = string2;
    }

    public String getPolicy() {
        return this.q;
    }

    public void setPolicy(String string2) {
        this.q = string2;
    }

    public byte[] getThumbPrint() {
        return this.r;
    }

    public void setThumbPrint(byte[] byArray) {
        X509CertImpl x509CertImpl = object;
        byte[] byArray2 = new byte[byArray.length];
        Object object = byArray2;
        x509CertImpl.r = byArray2;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n2);
    }

    public byte[] getVid() {
        return this.s;
    }

    public void setVid(byte[] byArray) {
        if (byArray != null) {
            X509CertImpl x509CertImpl = object;
            byte[] byArray2 = new byte[byArray.length];
            Object object = byArray2;
            x509CertImpl.s = byArray2;
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, object, 0, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        String string2 = "\r\n";
        new StringBuffer().append("Version : " + this.a + string2);
        stringBuffer2.append("SerialNumber : " + this.b.toString() + string2);
        stringBuffer2.append("SubjectDN : " + this.c + string2);
        stringBuffer2.append("IssuerDN : " + this.d + string2);
        stringBuffer2.append("SignatureAlgorithmName : " + this.e + string2);
        stringBuffer2.append("Validity :" + string2);
        stringBuffer2.append("    NotBefore : " + this.f.toString() + string2);
        stringBuffer2.append("    NotAfter : " + this.g.toString() + string2);
        stringBuffer2.append("PublicKeyAlgorithmName : " + this.h + string2);
        if (this.i != null) {
            stringBuffer2.append("PublicKey : " + Hex.dumpHex(this.i) + string2);
        } else {
            stringBuffer2.append("PublicKey : <null>" + string2);
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer3.append("PublicKeyAlgorithmInfo : " + this.j + string2);
        stringBuffer3.append(this.k + string2);
        stringBuffer3.append(this.l + string2);
        stringBuffer3.append("KeyUsage : " + string2 + this.m + string2);
        stringBuffer3.append(this.n + string2);
        stringBuffer3.append(this.o + string2);
        stringBuffer3.append(this.p + string2);
        stringBuffer3.append(this.q + string2);
        if (this.r != null) {
            stringBuffer2.append("ThumbPrint : " + Hex.dumpHex(this.r) + string2);
        } else {
            stringBuffer2.append("ThumbPrint : <null>" + string2);
        }
        if (this.s != null) {
            stringBuffer2.append("VID : " + Hex.dumpHex(this.s) + string2);
        } else {
            stringBuffer2.append("VID : <null>" + string2);
        }
        return stringBuffer2.toString();
    }
}

