/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv.manager;

import com.initech.cpv.exception.UndeterminedCertStatusException;
import com.initech.cpv.manager.CertStatusManagerParameters;
import com.initech.cpv.manager.CertStatusManagerSpi;
import com.initech.cpv.manager.impl.CRLCertStatusManager;
import com.initech.cpv.manager.impl.EnhancedCRLCertStatusManager;
import com.initech.cpv.manager.impl.OCSPGDCertStatusManager;
import com.initech.cpv.manager.impl.OPPRACertStatusManager;
import com.initech.cpv.manager.impl.VFSVRCertStatusManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;

public class CertStatusManager {
    public CertStatusManagerSpi a;

    public CertStatusManager(CertStatusManagerSpi certStatusManagerSpi) {
        this.a = certStatusManagerSpi;
    }

    public static CertStatusManager getInstance(String object, CertStatusManagerParameters certStatusManagerParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CRLCertStatusManager cRLCertStatusManager;
        if (object != null && !((String)object).equals("CRL")) {
            if (((String)object).equals("EnhancedCRL")) {
                EnhancedCRLCertStatusManager enhancedCRLCertStatusManager;
                object = enhancedCRLCertStatusManager;
                enhancedCRLCertStatusManager = new EnhancedCRLCertStatusManager(certStatusManagerParameters);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            if (((String)object).equals("VFSVR")) {
                VFSVRCertStatusManager vFSVRCertStatusManager;
                object = vFSVRCertStatusManager;
                vFSVRCertStatusManager = new VFSVRCertStatusManager(certStatusManagerParameters);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            if (((String)object).equals("OPPRA")) {
                OPPRACertStatusManager oPPRACertStatusManager;
                object = oPPRACertStatusManager;
                oPPRACertStatusManager = new OPPRACertStatusManager(certStatusManagerParameters);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            if (((String)object).equals("OCSPGD")) {
                OCSPGDCertStatusManager oCSPGDCertStatusManager;
                object = oCSPGDCertStatusManager;
                oCSPGDCertStatusManager = new OCSPGDCertStatusManager(certStatusManagerParameters);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            throw new NoSuchAlgorithmException("TrustManager '" + (String)object + "' provider does not exist.");
        }
        object = cRLCertStatusManager;
        cRLCertStatusManager = new CRLCertStatusManager(certStatusManagerParameters);
        return new CertStatusManager((CertStatusManagerSpi)object);
    }

    public static CertStatusManager getInstance(String object, CertStatusManagerParameters certStatusManagerParameters, Properties properties) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CRLCertStatusManager cRLCertStatusManager;
        if (object != null && !((String)object).equals("CRL")) {
            if (((String)object).equals("EnhancedCRL")) {
                EnhancedCRLCertStatusManager enhancedCRLCertStatusManager;
                object = enhancedCRLCertStatusManager;
                enhancedCRLCertStatusManager = new EnhancedCRLCertStatusManager(certStatusManagerParameters);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            if (((String)object).equals("VFSVR")) {
                VFSVRCertStatusManager vFSVRCertStatusManager;
                object = vFSVRCertStatusManager;
                vFSVRCertStatusManager = new VFSVRCertStatusManager(certStatusManagerParameters, properties);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            if (((String)object).equals("OPPRA")) {
                OPPRACertStatusManager oPPRACertStatusManager;
                object = oPPRACertStatusManager;
                oPPRACertStatusManager = new OPPRACertStatusManager(certStatusManagerParameters, properties);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            if (((String)object).equals("OCSPGD")) {
                OCSPGDCertStatusManager oCSPGDCertStatusManager;
                object = oCSPGDCertStatusManager;
                oCSPGDCertStatusManager = new OCSPGDCertStatusManager(certStatusManagerParameters, properties);
                return new CertStatusManager((CertStatusManagerSpi)object);
            }
            throw new NoSuchAlgorithmException("TrustManager '" + (String)object + "' provider does not exist.");
        }
        object = cRLCertStatusManager;
        cRLCertStatusManager = new CRLCertStatusManager(certStatusManagerParameters);
        return new CertStatusManager((CertStatusManagerSpi)object);
    }

    public static CertStatusManager getInstance(String object, String string2, CertStatusManagerParameters certStatusManagerParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (((String)object).equals("OPPRA")) {
            OPPRACertStatusManager oPPRACertStatusManager;
            object = oPPRACertStatusManager;
            oPPRACertStatusManager = new OPPRACertStatusManager(certStatusManagerParameters, string2);
            return new CertStatusManager((CertStatusManagerSpi)object);
        }
        throw new NoSuchAlgorithmException("TrustManager '" + (String)object + "' provider does not exist.");
    }

    public static CertStatusManager getInstance(String object, String string2, CertStatusManagerParameters certStatusManagerParameters, Properties properties) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (((String)object).equals("OPPRA")) {
            OPPRACertStatusManager oPPRACertStatusManager;
            object = oPPRACertStatusManager;
            oPPRACertStatusManager = new OPPRACertStatusManager(certStatusManagerParameters, string2, properties);
            return new CertStatusManager((CertStatusManagerSpi)object);
        }
        throw new NoSuchAlgorithmException("TrustManager '" + (String)object + "' provider does not exist.");
    }

    public boolean isValid(X509Certificate x509Certificate) throws UndeterminedCertStatusException {
        return this.a.engineIsValid(x509Certificate);
    }

    public void setClientInfo(String string2, String string3) {
        CertStatusManagerSpi certStatusManagerSpi = this.a;
        certStatusManagerSpi.clientInfo = string2;
        certStatusManagerSpi.req_URI = string3;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.a.engineSetCertificate(x509Certificate);
    }

    public boolean isUsable() {
        return this.a.engineIsUsable();
    }

    public boolean isValid() throws UndeterminedCertStatusException {
        return this.a.engineIsValid();
    }

    public boolean isInefficacy() {
        return this.a.engineIsInefficacy();
    }

    public String getErrorMessage() {
        return this.a.getErrorMessage();
    }

    public HashMap getResultInfo() {
        return this.a.getResultInfo();
    }
}

