/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv.manager.impl;

import com.initech.asn1.ASN1Exception;
import com.initech.core.INISAFECore;
import com.initech.cpv.crl.CRLChecker;
import com.initech.cpv.exception.CRLException;
import com.initech.cpv.exception.UndeterminedCertStatusException;
import com.initech.cpv.manager.CertStatusManagerParameters;
import com.initech.cpv.manager.CertStatusManagerSpi;
import com.initech.cpv.manager.TrustManager;
import com.initech.cpv.manager.impl.CRLCertStatusManagerParameters;
import com.initech.cpv.util.Debug;
import com.initech.x509.extensions.BasicConstraints;
import com.initech.x509.extensions.CRLDistPoints;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.X509Certificate;

public class CRLCertStatusManager
extends CertStatusManagerSpi {
    public CRLCertStatusManagerParameters a;

    public CRLCertStatusManager(CertStatusManagerParameters certStatusManagerParameters) throws InvalidAlgorithmParameterException {
        super(certStatusManagerParameters);
        if (certStatusManagerParameters instanceof CRLCertStatusManagerParameters) {
            this.a = (CRLCertStatusManagerParameters)certStatusManagerParameters;
            return;
        }
        throw new InvalidAlgorithmParameterException("Parameters must be CRLCertStatusCheckerParameters.");
    }

    @Override
    public boolean engineIsValid(X509Certificate object) throws UndeterminedCertStatusException {
        block20: {
            CRLChecker cRLChecker;
            BasicConstraints basicConstraints;
            BasicConstraints basicConstraints2;
            byte[] byArray = object.getExtensionValue("2.5.29.19");
            BasicConstraints basicConstraints3 = null;
            if (byArray != null) {
                BasicConstraints basicConstraints4;
                basicConstraints2 = basicConstraints4;
                try {
                    basicConstraints4 = new BasicConstraints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints2 = basicConstraints3;
                }
            } else {
                basicConstraints2 = basicConstraints3;
            }
            if (basicConstraints2 == null && !this.a.isIgnoreOldVersionCert()) {
                throw new UndeterminedCertStatusException("Certificate does not have BasicConstraints extension.(Maybe old version certificate.)");
            }
            byArray = object.getExtensionValue("2.5.29.31");
            basicConstraints3 = null;
            if (byArray != null) {
                CRLDistPoints cRLDistPoints;
                basicConstraints = cRLDistPoints;
                try {
                    cRLDistPoints = new CRLDistPoints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints = basicConstraints3;
                }
            } else {
                basicConstraints = basicConstraints3;
            }
            if (basicConstraints == null && !this.a.isIgnoreOldVersionCert()) {
                throw new UndeterminedCertStatusException("Certificate does not have CRLDistributionPoint extension.(Maybe old version certificate.)");
            }
            int n2 = ((X509Certificate)object).getVersion();
            if (this.a.isIgnoreOldVersionCert() && (n2 == 1 || n2 == 2) && !this.a.isUseUserDefinedCRL()) {
                return true;
            }
            if (basicConstraints2 != null && this.a.isIgnoreCACert() && basicConstraints2.isCA()) {
                return true;
            }
            if (((Object)((X509Certificate)object).getIssuerDN()).toString().equals(((Object)((X509Certificate)object).getSubjectDN()).toString())) {
                return true;
            }
            CRLChecker cRLChecker2 = cRLChecker;
            X509Certificate x509Certificate = object;
            CRLCertStatusManager cRLCertStatusManager = this;
            object = cRLCertStatusManager.a.getCrlIssuerManager();
            boolean bl = cRLCertStatusManager.a.isVerifyCRL();
            boolean bl2 = cRLCertStatusManager.a.isUseDeltaCRL();
            cRLChecker = new CRLChecker(x509Certificate, (TrustManager)object, bl, bl2);
            if (this.a.isUseUserDefinedCRL()) {
                cRLChecker2.setUserCRLs(this.a.getUserDefinedCompleteCRLs());
                cRLChecker2.setUserDeltaCRLs(this.a.getUserDefinedDeltaCRLs());
            }
            try {
                int n3 = cRLChecker2.getCertStatus();
                if (n3 == -1) {
                    return true;
                }
                if (n3 == -1 || n3 == 255) break block20;
                return false;
            }
            catch (CRLException cRLException) {
                Debug.handleException(cRLException);
                throw new UndeterminedCertStatusException(cRLException);
            }
        }
        throw new UndeterminedCertStatusException("Certificate status cannot be checked.");
    }

    @Override
    public boolean engineIsUsable() {
        return true;
    }

    @Override
    public boolean engineIsValid() throws UndeterminedCertStatusException {
        block20: {
            CRLChecker cRLChecker;
            BasicConstraints basicConstraints;
            BasicConstraints basicConstraints2;
            byte[] byArray = this.cert.getExtensionValue("2.5.29.19");
            Object object = null;
            if (byArray != null) {
                BasicConstraints basicConstraints3;
                basicConstraints2 = basicConstraints3;
                try {
                    basicConstraints3 = new BasicConstraints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints2 = object;
                }
            } else {
                basicConstraints2 = object;
            }
            if (basicConstraints2 == null && !this.a.isIgnoreOldVersionCert()) {
                INISAFECore.CoreLogger(1, "X.509 \uc778\uc99d\uc11c \ud655\uc7a5 \ud544\ub4dc\uc5d0 BasicConstraints \uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.(\ubc84\uc804 3 \ubcf4\ub2e4 \ub0ae\uc740 \ubc84\uc804\uc758 \uc778\uc99d\uc11c\ub294 CRL \uc744 \uc9c0\uc6d0\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4");
                throw new UndeterminedCertStatusException("there is not BasicConstraints in extension field of X509 certificate (certificate under version 3 does not support CRL)");
            }
            byArray = this.cert.getExtensionValue("2.5.29.31");
            object = null;
            if (byArray != null) {
                CRLDistPoints cRLDistPoints;
                basicConstraints = cRLDistPoints;
                try {
                    cRLDistPoints = new CRLDistPoints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints = object;
                }
            } else {
                basicConstraints = object;
            }
            if (basicConstraints == null && !this.a.isIgnoreOldVersionCert()) {
                INISAFECore.CoreLogger(1, "X.509 \uc778\uc99d\uc11c \ud655\uc7a5 \ud544\ub4dc\uc5d0 CRLDistributionPoint \uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.(\ubc84\uc804 3 \ubcf4\ub2e4 \ub0ae\uc740 \ubc84\uc804\uc758 \uc778\uc99d\uc11c\ub294 CRL \uc744 \uc9c0\uc6d0\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                throw new UndeterminedCertStatusException("there is not CRLDistributionPoint in extension field of X509 certificate. (certificate under version 3 does not support CRL)");
            }
            CRLCertStatusManager cRLCertStatusManager = this;
            int n2 = cRLCertStatusManager.cert.getVersion();
            if (cRLCertStatusManager.a.isIgnoreOldVersionCert() && (n2 == 1 || n2 == 2) && !this.a.isUseUserDefinedCRL()) {
                return true;
            }
            if (basicConstraints2 != null && this.a.isIgnoreCACert() && basicConstraints2.isCA()) {
                return true;
            }
            if (((Object)this.cert.getIssuerDN()).toString().equals(((Object)this.cert.getSubjectDN()).toString())) {
                return true;
            }
            CRLChecker cRLChecker2 = cRLChecker;
            CRLCertStatusManager cRLCertStatusManager2 = this;
            object = cRLCertStatusManager2.a.getCrlIssuerManager();
            boolean bl = cRLCertStatusManager2.a.isVerifyCRL();
            boolean bl2 = cRLCertStatusManager2.a.isUseDeltaCRL();
            cRLChecker = new CRLChecker(this.cert, (TrustManager)object, bl, bl2);
            if (this.a.isUseUserDefinedCRL()) {
                cRLChecker2.setUserCRLs(this.a.getUserDefinedCompleteCRLs());
                cRLChecker2.setUserDeltaCRLs(this.a.getUserDefinedDeltaCRLs());
            }
            try {
                int n3 = cRLChecker2.getCertStatus();
                if (n3 == -1) {
                    return true;
                }
                if (n3 == -1 || n3 == 255) break block20;
                return false;
            }
            catch (CRLException cRLException) {
                Debug.handleException(cRLException);
                throw new UndeterminedCertStatusException(cRLException);
            }
        }
        INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c\uc758 \uc0c1\ud0dc\ub97c \uac80\uc99d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ub124\ud2b8\uc6cc\ud06c \uc0c1\ud0dc\ub97c \uc810\uac80\ud558\uc138\uc694.");
        throw new UndeterminedCertStatusException("cannot verify certificate status, check network state.");
    }
}

