/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv.manager.impl;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.Name;
import com.initech.cpv.manager.TrustManagerParameters;
import com.initech.cpv.manager.TrustManagerSpi;
import com.initech.cpv.manager.impl.DefaultTrustManagerParameters;
import com.initech.x509.extensions.AuthorityKeyIdentifier;
import com.initech.x509.extensions.SubjectKeyIdentifier;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DefaultTrustManager
extends TrustManagerSpi {
    public DefaultTrustManagerParameters a;

    public DefaultTrustManager(TrustManagerParameters trustManagerParameters) throws InvalidAlgorithmParameterException {
        super(trustManagerParameters);
        if (trustManagerParameters instanceof DefaultTrustManagerParameters) {
            this.a = (DefaultTrustManagerParameters)trustManagerParameters;
            return;
        }
        throw new InvalidAlgorithmParameterException("Parameters must be DefaultTrustManagerParameters.");
    }

    public static AuthorityKeyIdentifier a(X509Certificate x509Certificate) {
        AuthorityKeyIdentifier authorityKeyIdentifier;
        AuthorityKeyIdentifier authorityKeyIdentifier2;
        block4: {
            AuthorityKeyIdentifier authorityKeyIdentifier3;
            authorityKeyIdentifier2 = null;
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.35");
            if (byArray == null) break block4;
            authorityKeyIdentifier = authorityKeyIdentifier3;
            try {
                authorityKeyIdentifier3 = new AuthorityKeyIdentifier(byArray);
            }
            catch (ASN1Exception aSN1Exception) {
                System.out.println("AKI IS NULL - " + x509Certificate.getSubjectDN());
                authorityKeyIdentifier = authorityKeyIdentifier2;
            }
        }
        authorityKeyIdentifier = authorityKeyIdentifier2;
        return authorityKeyIdentifier;
    }

    public static SubjectKeyIdentifier b(X509Certificate x509Certificate) {
        SubjectKeyIdentifier subjectKeyIdentifier;
        SubjectKeyIdentifier subjectKeyIdentifier2;
        block4: {
            SubjectKeyIdentifier subjectKeyIdentifier3;
            subjectKeyIdentifier2 = null;
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.14");
            if (byArray == null) break block4;
            subjectKeyIdentifier = subjectKeyIdentifier3;
            try {
                subjectKeyIdentifier3 = new SubjectKeyIdentifier(byArray);
            }
            catch (ASN1Exception aSN1Exception) {
                System.out.println("SKI IS NULL - " + x509Certificate.getSubjectDN());
                subjectKeyIdentifier = subjectKeyIdentifier2;
            }
        }
        subjectKeyIdentifier = subjectKeyIdentifier2;
        return subjectKeyIdentifier;
    }

    @Override
    public List engineGetTurstedCertificate() {
        return this.a.getTrustCertList();
    }

    @Override
    public X509Certificate engineFindIssuerCert(X509Certificate x509Certificate) {
        Name name;
        DefaultTrustManager defaultTrustManager = defaultTrustManager2;
        DefaultTrustManager defaultTrustManager2 = DefaultTrustManager.a(x509Certificate);
        Name name2 = name;
        name = new Name(x509Certificate.getIssuerDN().getName());
        Iterator iterator = defaultTrustManager.a.elements();
        while (iterator.hasNext()) {
            Name name3;
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            SubjectKeyIdentifier subjectKeyIdentifier = DefaultTrustManager.b(x509Certificate2);
            Name name4 = name3;
            name3 = new Name(x509Certificate2.getSubjectDN().getName());
            if (!(subjectKeyIdentifier != null && defaultTrustManager2 != null ? Arrays.equals(subjectKeyIdentifier.getKID(), defaultTrustManager2.getKID()) : true) || !name2.equals(name4)) continue;
            return x509Certificate2;
        }
        return x509Certificate;
    }

    @Override
    public X509Certificate engineFindIssuerCert(X509CRL x509CRL) {
        Name name;
        DefaultTrustManager defaultTrustManager = defaultTrustManager2;
        DefaultTrustManager defaultTrustManager2 = name;
        name = new Name(x509CRL.getIssuerDN().getName());
        X509Certificate x509Certificate = null;
        Iterator iterator = defaultTrustManager.a.elements();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            Object object = x509Certificate2.getExtensionValue("2.5.29.14");
            byte[] byArray = x509CRL.getExtensionValue("2.5.29.35");
            if (byArray != null && object != null) {
                AuthorityKeyIdentifier authorityKeyIdentifier;
                SubjectKeyIdentifier subjectKeyIdentifier;
                try {
                    subjectKeyIdentifier = new SubjectKeyIdentifier(object);
                }
                catch (Exception exception) {
                    continue;
                }
                object = authorityKeyIdentifier;
                authorityKeyIdentifier = new AuthorityKeyIdentifier(byArray);
                if (!Arrays.equals(subjectKeyIdentifier.getKID(), object.getKID())) continue;
                return x509Certificate2;
            }
            if (!new Name(x509Certificate2.getSubjectDN().getName()).equals((Name)defaultTrustManager2)) {
                x509Certificate2 = x509Certificate;
            }
            x509Certificate = x509Certificate2;
        }
        if (x509Certificate != null) {
            return x509Certificate;
        }
        return null;
    }
}

