/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv.manager.impl;

import com.initech.asn1.ASN1Exception;
import com.initech.cpv.crl.CRLChecker;
import com.initech.cpv.exception.CRLException;
import com.initech.cpv.exception.UndeterminedCertStatusException;
import com.initech.cpv.manager.CertStatusManagerParameters;
import com.initech.cpv.manager.CertStatusManagerSpi;
import com.initech.cpv.manager.TrustManager;
import com.initech.cpv.manager.impl.EnhancedCRLCertStatusManagerParameters;
import com.initech.cpv.util.Debug;
import com.initech.x509.extensions.BasicConstraints;
import com.initech.x509.extensions.CRLDistPoints;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.X509Certificate;

public class EnhancedCRLCertStatusManager
extends CertStatusManagerSpi {
    public EnhancedCRLCertStatusManagerParameters a;

    public EnhancedCRLCertStatusManager(CertStatusManagerParameters certStatusManagerParameters) throws InvalidAlgorithmParameterException {
        super(certStatusManagerParameters);
        if (certStatusManagerParameters instanceof EnhancedCRLCertStatusManagerParameters) {
            this.a = (EnhancedCRLCertStatusManagerParameters)certStatusManagerParameters;
            return;
        }
        throw new InvalidAlgorithmParameterException("Parameters must be CRLCertStatusCheckerParameters.");
    }

    @Override
    public boolean engineIsValid(X509Certificate x509Certificate) throws UndeterminedCertStatusException {
        block21: {
            CRLChecker cRLChecker;
            BasicConstraints basicConstraints;
            BasicConstraints basicConstraints2;
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.19");
            Object object = null;
            if (byArray != null) {
                BasicConstraints basicConstraints3;
                basicConstraints2 = basicConstraints3;
                try {
                    basicConstraints3 = new BasicConstraints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints2 = object;
                }
            } else {
                basicConstraints2 = object;
            }
            if (basicConstraints2 == null && !this.a.isIgnoreOldVersionCert()) {
                throw new UndeterminedCertStatusException("Certificate does not have BasicConstraints extension.(Maybe old version certificate.)");
            }
            byArray = x509Certificate.getExtensionValue("2.5.29.31");
            object = null;
            if (byArray != null) {
                CRLDistPoints cRLDistPoints;
                basicConstraints = cRLDistPoints;
                try {
                    cRLDistPoints = new CRLDistPoints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints = object;
                }
            } else {
                basicConstraints = object;
            }
            if (basicConstraints == null && !this.a.isIgnoreOldVersionCert()) {
                throw new UndeterminedCertStatusException("Certificate does not have CRLDistributionPoint extension.(Maybe old version certificate.)");
            }
            int n2 = x509Certificate.getVersion();
            if (this.a.isIgnoreOldVersionCert() && (n2 == 1 || n2 == 2) && !this.a.isUseUserDefinedCRL()) {
                return true;
            }
            if (basicConstraints2 != null && this.a.isIgnoreCACert() && basicConstraints2.isCA()) {
                return true;
            }
            CRLChecker cRLChecker2 = cRLChecker;
            EnhancedCRLCertStatusManager enhancedCRLCertStatusManager = this;
            object = enhancedCRLCertStatusManager.a.getCrlIssuerManager();
            boolean bl = enhancedCRLCertStatusManager.a.isVerifyCRL();
            boolean bl2 = enhancedCRLCertStatusManager.a.isUseDeltaCRL();
            cRLChecker2(x509Certificate, (TrustManager)object, bl, bl2);
            cRLChecker2.setLookUpCRLWithNoDP(this.a.isLookUpCRLWithNoDP());
            cRLChecker.setDefaultDirectoryServerUrl(this.a.getDefaultDirectoryServerUrl());
            if (this.a.getConcernedReason() != null) {
                for (int i2 = 0; i2 < this.a.getConcernedReason().length; ++i2) {
                    cRLChecker2.setConcernedReason(this.a.getConcernedReason()[i2]);
                }
            }
            if (this.a.isUseUserDefinedCRL()) {
                cRLChecker2.setUserCRLs(this.a.getUserDefinedCompleteCRLs(x509Certificate));
                cRLChecker2.setUserDeltaCRLs(this.a.getUserDefinedDeltaCRLs(x509Certificate));
            }
            try {
                int n3 = cRLChecker2.getCertStatus();
                if (n3 == -1) {
                    return true;
                }
                if (n3 == -1 || n3 == 255) break block21;
                return false;
            }
            catch (CRLException cRLException) {
                Debug.handleException(cRLException);
                throw new UndeterminedCertStatusException(cRLException);
            }
        }
        throw new UndeterminedCertStatusException("Certificate status cannot be checked.");
    }

    @Override
    public boolean engineIsUsable() {
        return true;
    }

    @Override
    public boolean engineIsValid() throws UndeterminedCertStatusException {
        block21: {
            CRLChecker cRLChecker;
            BasicConstraints basicConstraints;
            BasicConstraints basicConstraints2;
            byte[] byArray = this.cert.getExtensionValue("2.5.29.19");
            Object object = null;
            if (byArray != null) {
                BasicConstraints basicConstraints3;
                basicConstraints2 = basicConstraints3;
                try {
                    basicConstraints3 = new BasicConstraints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints2 = object;
                }
            } else {
                basicConstraints2 = object;
            }
            if (basicConstraints2 == null && !this.a.isIgnoreOldVersionCert()) {
                throw new UndeterminedCertStatusException("Certificate does not have BasicConstraints extension.(Maybe old version certificate.)");
            }
            byArray = this.cert.getExtensionValue("2.5.29.31");
            object = null;
            if (byArray != null) {
                CRLDistPoints cRLDistPoints;
                basicConstraints = cRLDistPoints;
                try {
                    cRLDistPoints = new CRLDistPoints(byArray);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.handleException((Exception)((Object)aSN1Exception));
                    basicConstraints = object;
                }
            } else {
                basicConstraints = object;
            }
            if (basicConstraints == null && !this.a.isIgnoreOldVersionCert()) {
                throw new UndeterminedCertStatusException("Certificate does not have CRLDistributionPoint extension.(Maybe old version certificate.)");
            }
            EnhancedCRLCertStatusManager enhancedCRLCertStatusManager = this;
            int n2 = enhancedCRLCertStatusManager.cert.getVersion();
            if (enhancedCRLCertStatusManager.a.isIgnoreOldVersionCert() && (n2 == 1 || n2 == 2) && !this.a.isUseUserDefinedCRL()) {
                return true;
            }
            if (basicConstraints2 != null && this.a.isIgnoreCACert() && basicConstraints2.isCA()) {
                return true;
            }
            CRLChecker cRLChecker2 = cRLChecker;
            EnhancedCRLCertStatusManager enhancedCRLCertStatusManager2 = this;
            object = enhancedCRLCertStatusManager2.a.getCrlIssuerManager();
            boolean bl = enhancedCRLCertStatusManager2.a.isVerifyCRL();
            boolean bl2 = enhancedCRLCertStatusManager2.a.isUseDeltaCRL();
            cRLChecker2(this.cert, (TrustManager)object, bl, bl2);
            cRLChecker2.setLookUpCRLWithNoDP(this.a.isLookUpCRLWithNoDP());
            cRLChecker.setDefaultDirectoryServerUrl(this.a.getDefaultDirectoryServerUrl());
            if (this.a.getConcernedReason() != null) {
                for (int i2 = 0; i2 < this.a.getConcernedReason().length; ++i2) {
                    cRLChecker2.setConcernedReason(this.a.getConcernedReason()[i2]);
                }
            }
            if (this.a.isUseUserDefinedCRL()) {
                cRLChecker2.setUserCRLs(this.a.getUserDefinedCompleteCRLs(this.cert));
                cRLChecker2.setUserDeltaCRLs(this.a.getUserDefinedDeltaCRLs(this.cert));
            }
            try {
                int n3 = cRLChecker2.getCertStatus();
                if (n3 == -1) {
                    return true;
                }
                if (n3 == -1 || n3 == 255) break block21;
                return false;
            }
            catch (CRLException cRLException) {
                Debug.handleException(cRLException);
                throw new UndeterminedCertStatusException(cRLException);
            }
        }
        throw new UndeterminedCertStatusException("Certificate status cannot be checked.");
    }
}

