/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger;

import com.initech.inibase.logger.Priority;

public class Level
extends Priority {
    public static final int NOTICE_INT = 29000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF", 0);
    public static final Level FATAL = new Level(50000, "FATAL", 0);
    public static final Level ERROR = new Level(40000, "ERROR", 3);
    public static final Level WARN = new Level(30000, "WARN", 4);
    public static final Level NOTICE = new Level(29000, "NOTICE", 6);
    public static final Level INFO = new Level(20000, "INFO", 6);
    public static final Level DEBUG = new Level(10000, "DEBUG", 7);
    public static final Level ALL = new Level(Integer.MIN_VALUE, "ALL", 7);

    public Level(int n2, String string2, int n3) {
        super(n2, string2, n3);
    }

    public static Level toLevel(String string2) {
        return Level.toLevel(string2, DEBUG);
    }

    public static Level toLevel(int n2) {
        return Level.toLevel(n2, DEBUG);
    }

    public static Level toLevel(int n2, Level level) {
        switch (n2) {
            default: {
                return level;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
            case 50000: {
                return FATAL;
            }
            case 40000: {
                return ERROR;
            }
            case 30000: {
                return WARN;
            }
            case 29000: {
                return NOTICE;
            }
            case 20000: {
                return INFO;
            }
            case 10000: {
                return DEBUG;
            }
            case -2147483648: 
        }
        return ALL;
    }

    public static Level toLevel(String string2, Level level) {
        if (string2 == null) {
            return level;
        }
        if ((string2 = string2.toUpperCase()).equals("ALL")) {
            return ALL;
        }
        if (string2.equals("DEBUG")) {
            return DEBUG;
        }
        if (string2.equals("INFO")) {
            return INFO;
        }
        if (string2.equals("NOTICE")) {
            return NOTICE;
        }
        if (string2.equals("WARN")) {
            return WARN;
        }
        if (string2.equals("ERROR")) {
            return ERROR;
        }
        if (string2.equals("FATAL")) {
            return FATAL;
        }
        if (string2.equals("OFF")) {
            return OFF;
        }
        return level;
    }
}

