/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger;

import com.initech.inibase.logger.Level;

public class Priority {
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int FATAL_INT = 50000;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final Priority FATAL = new Level(50000, "FATAL", 0);
    public static final Priority ERROR = new Level(40000, "ERROR", 3);
    public static final Priority WARN = new Level(30000, "WARN", 4);
    public static final Priority INFO = new Level(20000, "INFO", 6);
    public static final Priority DEBUG = new Level(10000, "DEBUG", 7);
    public int a;
    public String b;
    public int c;

    public Priority(int n2, String string2, int n3) {
        this.a = n2;
        this.b = string2;
        this.c = n3;
    }

    public static Priority[] getAllPossiblePriorities() {
        return new Priority[]{FATAL, ERROR, Level.WARN, INFO, DEBUG};
    }

    public static Priority toPriority(String string2) {
        return Level.toLevel(string2);
    }

    public static Priority toPriority(int n2) {
        return Priority.toPriority(n2, DEBUG);
    }

    public static Priority toPriority(int n2, Priority priority) {
        return Level.toLevel(n2, (Level)priority);
    }

    public static Priority toPriority(String string2, Priority priority) {
        return Level.toLevel(string2, (Level)priority);
    }

    public boolean equals(Object object) {
        if (object instanceof Priority) {
            Priority priority = priority2;
            Priority priority2 = (Priority)object;
            return priority.a == priority2.a;
        }
        return false;
    }

    public final int getSyslogEquivalent() {
        return this.c;
    }

    public boolean isGreaterOrEqual(Priority priority) {
        return this.a >= priority.a;
    }

    public final String toString() {
        return this.b;
    }

    public final int toInt() {
        return this.a;
    }
}

