/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger;

import com.initech.inibase.logger.AppenderSkeleton;
import com.initech.inibase.logger.Layout;
import com.initech.inibase.logger.helpers.LogLog;
import com.initech.inibase.logger.helpers.QuietWriter;
import com.initech.inibase.logger.spi.ErrorHandler;
import com.initech.inibase.logger.spi.LoggingEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class WriterAppender
extends AppenderSkeleton {
    public boolean immediateFlush;
    public String encoding;
    public QuietWriter qw;

    public WriterAppender() {
        this.immediateFlush = true;
    }

    public WriterAppender(Layout layout2, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter;
        WriterAppender writerAppender = outputStreamWriter2;
        OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
        outputStreamWriter = new OutputStreamWriter(outputStream);
        writerAppender(layout2, outputStreamWriter2);
    }

    public WriterAppender(Layout layout2, Writer writer) {
        WriterAppender writerAppender = this;
        writerAppender.immediateFlush = true;
        writerAppender.layout = layout2;
        writerAppender.setWriter(writer);
    }

    public void setImmediateFlush(boolean bl) {
        this.immediateFlush = bl;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(loggingEvent);
    }

    public boolean checkEntryConditions() {
        if (this.closed) {
            LogLog.warn("Not allowed to write to a closed appender.");
            return false;
        }
        if (this.qw == null) {
            this.errorHandler.error("No output stream or file set for the appender named [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for the appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        WriterAppender writerAppender = this;
        writerAppender.closed = true;
        writerAppender.writeFooter();
        writerAppender.reset();
    }

    public void closeWriter() {
        QuietWriter quietWriter = this.qw;
        if (quietWriter != null) {
            try {
                quietWriter.close();
                return;
            }
            catch (IOException iOException) {
                LogLog.error("Could not close " + this.qw, iOException);
            }
        }
    }

    public OutputStreamWriter createWriter(OutputStream outputStream) {
        Object object;
        block5: {
            WriterAppender writerAppender = writerAppender2;
            WriterAppender writerAppender2 = null;
            String string2 = writerAppender.getEncoding();
            if (string2 != null) {
                OutputStreamWriter outputStreamWriter;
                object = outputStreamWriter;
                try {
                    outputStreamWriter = new OutputStreamWriter(outputStream, string2);
                    break block5;
                }
                catch (IOException iOException) {
                    LogLog.warn("Error initializing output writer.");
                    LogLog.warn("Unsupported encoding?");
                }
            }
            object = writerAppender2;
        }
        if (object == null) {
            OutputStreamWriter outputStreamWriter;
            object = outputStreamWriter;
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        return object;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string2) {
        this.encoding = string2;
    }

    @Override
    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            LogLog.warn("You have tried to set a null error-handler.");
            return;
        }
        ((AppenderSkeleton)((Object)quietWriter)).errorHandler = errorHandler;
        QuietWriter quietWriter = ((WriterAppender)((Object)quietWriter)).qw;
        if (quietWriter != null) {
            quietWriter.setErrorHandler(errorHandler);
        }
    }

    public synchronized void setWriter(Writer writer) {
        QuietWriter quietWriter;
        WriterAppender writerAppender = this;
        writerAppender.reset();
        QuietWriter quietWriter2 = quietWriter;
        quietWriter = new QuietWriter(writer, this.errorHandler);
        writerAppender.qw = quietWriter2;
        writerAppender.writeHeader();
    }

    public void subAppend(LoggingEvent stringArray) {
        WriterAppender writerAppender = this;
        writerAppender.qw.write(this.layout.format((LoggingEvent)stringArray));
        if (writerAppender.layout.ignoresThrowable() && (stringArray = stringArray.getThrowableStrRep()) != null) {
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                WriterAppender writerAppender2 = this;
                writerAppender2.qw.write(stringArray[i2]);
                writerAppender2.qw.write(Layout.LINE_SEP);
            }
        }
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    public void reset() {
        this.closeWriter();
        this.qw = null;
    }

    public void writeFooter() {
        QuietWriter quietWriter;
        Object object = this.layout;
        if (object != null && (object = ((Layout)object).getFooter()) != null && (quietWriter = this.qw) != null) {
            quietWriter.write((String)object);
            this.qw.flush();
        }
    }

    public void writeHeader() {
        Object object = ((AppenderSkeleton)this).layout;
        if (object != null && (object = ((Layout)object).getHeader()) != null && (this = ((WriterAppender)this).qw) != null) {
            ((QuietWriter)this).write((String)object);
        }
    }
}

