/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger.config;

import com.initech.beans.IntrospectionException;
import com.initech.beans.Introspector;
import com.initech.beans.PropertyDescriptor;
import com.initech.inibase.logger.Appender;
import com.initech.inibase.logger.Level;
import com.initech.inibase.logger.Priority;
import com.initech.inibase.logger.config.PropertySetterException;
import com.initech.inibase.logger.helpers.LogLog;
import com.initech.inibase.logger.helpers.OptionConverter;
import com.initech.inibase.logger.spi.OptionHandler;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;

public class PropertySetter {
    public Object obj;
    public PropertyDescriptor[] props;

    public PropertySetter(Object object) {
        this.obj = object;
    }

    public static void setProperties(Object object, Properties properties, String string2) {
        new PropertySetter(object).setProperties(properties, string2);
    }

    public void introspect() {
        try {
            this.props = Introspector.getBeanInfo(this.obj.getClass()).getPropertyDescriptors();
            return;
        }
        catch (IntrospectionException introspectionException) {
            LogLog.error("Failed to introspect " + this.obj + ": " + introspectionException.getMessage());
            this.props = new PropertyDescriptor[0];
            return;
        }
    }

    public void setProperties(Properties properties, String string2) {
        int n2 = string2.length();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2) || string3.indexOf(46, n2 + 1) > 0) continue;
            String string4 = string3;
            string3 = OptionConverter.findAndSubst(string3, properties);
            String string5 = string4.substring(n2);
            if ("layout".equals(string5) && this.obj instanceof Appender) continue;
            this.setProperty(string5, string3);
        }
        this.activate();
    }

    public void setProperty(String string2, String string3) {
        if (string3 == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string2 = Introspector.decapitalize(string2));
        if (propertyDescriptor == null) {
            LogLog.warn("No such property [" + string2 + "] in " + this.obj.getClass().getName() + ".");
            return;
        }
        try {
            this.setProperty(propertyDescriptor, string2, string3);
            return;
        }
        catch (PropertySetterException propertySetterException) {
            LogLog.warn("Failed to set property [" + string2 + "] to value \"" + string3 + "\". ", propertySetterException.rootCause);
            return;
        }
    }

    public void setProperty(PropertyDescriptor object, String string2, String object2) throws PropertySetterException {
        if ((object = ((PropertyDescriptor)object).getWriteMethod()) != null) {
            Class<?>[] classArray = ((Method)object).getParameterTypes();
            if (classArray.length == 1) {
                block6: {
                    try {
                        object2 = this.convertArg((String)object2, classArray[0]);
                        if (object2 == null) break block6;
                    }
                    catch (Throwable throwable) {
                        throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed. Reason: " + throwable);
                    }
                    LogLog.debug("Setting property [" + string2 + "] to [" + object2 + "].");
                    try {
                        ((Method)object).invoke(this.obj, object2);
                    }
                    catch (Exception exception) {
                        throw new PropertySetterException(exception);
                    }
                    return;
                }
                throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed.");
            }
            throw new PropertySetterException("#params for setter != 1");
        }
        throw new PropertySetterException("No setter for property [" + string2 + "].");
    }

    public Object convertArg(String string2, Class clazz) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2.trim();
        if (String.class.isAssignableFrom(clazz)) {
            return string2;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return new Integer(string3);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return new Long(string3);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("true".equalsIgnoreCase(string3)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string3)) {
                return Boolean.FALSE;
            }
        } else if (Priority.class.isAssignableFrom(clazz)) {
            return OptionConverter.toLevel(string3, Level.DEBUG);
        }
        return null;
    }

    public PropertyDescriptor getPropertyDescriptor(String string2) {
        if (this.props == null) {
            this.introspect();
        }
        int n2 = 0;
        while (true) {
            PropertyDescriptor[] propertyDescriptorArray = this.props;
            if (n2 >= this.props.length) break;
            if (string2.equals(propertyDescriptorArray[n2].getName())) {
                return this.props[n2];
            }
            ++n2;
        }
        return null;
    }

    public void activate() {
        Object object = ((PropertySetter)object).obj;
        if (object instanceof OptionHandler) {
            ((OptionHandler)object).activateOptions();
        }
    }
}

