/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.misc;

import java.io.ByteArrayOutputStream;

public class ByteUtil {
    public static final byte[] short2byte(short s2) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)s2;
        byArray[0] = (byte)(s2 >> 8);
        return byArray;
    }

    public static final byte[] int2byte(int n2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[3] = (byte)n2;
        byArray2[2] = (byte)(n2 >> 8);
        byArray2[1] = (byte)(n2 >> 16);
        byArray[0] = (byte)(n2 >>> 24);
        return byArray;
    }

    public static final byte[] long2byte(long l2) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = byArray;
        byArray2[7] = (byte)(l2 & 0xFFL);
        byArray2[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray2[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray2[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray2[3] = (byte)(l2 >> 32 & 0xFFL);
        byArray2[2] = (byte)(l2 >> 40 & 0xFFL);
        byArray2[1] = (byte)(l2 >> 48 & 0xFFL);
        byArray[0] = (byte)(l2 >> 56 & 0xFFL);
        return byArray;
    }

    public static final short getshort(byte[] byArray, int n2) {
        return (short)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    public static final int getint(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public static final long getlong(byte[] byArray, int n2) {
        return (long)ByteUtil.getint(byArray, n2) << 32 | (long)ByteUtil.getint(byArray, n2 + 4) & 0xFFFFFFFFL;
    }

    public static final byte[] setshort(byte[] byArray, int n2, short s2) {
        int n3 = n2 + 1;
        byArray[n3] = (byte)s2;
        byArray[n2] = (byte)(s2 >> 8);
        return byArray;
    }

    public static final byte[] setint(byte[] byArray, int n2, int n3) {
        int n4 = n2 + 3;
        byArray[n4] = (byte)n3;
        n4 = n2 + 2;
        byArray[n4] = (byte)(n3 >> 8);
        n4 = n2 + 1;
        byArray[n4] = (byte)(n3 >> 16);
        byArray[n2] = (byte)(n3 >>> 24);
        return byArray;
    }

    public static final byte[] setlong(byte[] byArray, int n2, long l2) {
        ByteUtil.setint(byArray, n2, (int)(l2 >> 32));
        int n3 = n2 + 4;
        ByteUtil.setint(byArray, n3, (int)l2);
        return byArray;
    }

    public static byte[] sub_byte(byte[] byArray, int n2, int n3) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, n2, n3);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }
}

