/*
 * Decompiled with CFR 0.152.
 */
package com.initech.license.crypto;

import com.initech.license.crypto.CryptoException;
import com.initech.license.crypto.asn1.ASN1;
import com.initech.license.crypto.asn1.ASN1Exception;
import com.initech.license.crypto.asn1.ASN1Info;
import com.initech.license.crypto.asn1.AlgorithmID;
import com.initech.license.crypto.asn1.BitString;
import com.initech.license.crypto.asn1.SEQUENCE;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class X509PublicKeyInfo {
    public ASN1Info a;
    public AlgorithmID publicKeyAlgorithm;

    public X509PublicKeyInfo() {
    }

    public X509PublicKeyInfo(byte[] byArray) throws CryptoException {
        X509PublicKeyInfo x509PublicKeyInfo = this;
        try {
            x509PublicKeyInfo.a = new ASN1Info(byArray);
            x509PublicKeyInfo.a();
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CryptoException("\uacf5\uac1c\ud0a4 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4: " + aSN1Exception.toString());
        }
    }

    public X509PublicKeyInfo(InputStream inputStream) throws CryptoException, IOException {
        X509PublicKeyInfo x509PublicKeyInfo = this;
        try {
            x509PublicKeyInfo.a = new ASN1Info(inputStream);
            x509PublicKeyInfo.a();
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CryptoException("\uacf5\uac1c\ud0a4 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4: " + aSN1Exception.toString());
        }
    }

    public X509PublicKeyInfo(ASN1 aSN1) throws CryptoException {
        X509PublicKeyInfo x509PublicKeyInfo = this;
        try {
            x509PublicKeyInfo.a = new ASN1Info(aSN1);
            x509PublicKeyInfo.a();
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CryptoException("\uacf5\uac1c\ud0a4 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4: " + aSN1Exception.toString());
        }
    }

    public void createPublicKeyInfo() {
        SEQUENCE sEQUENCE;
        try {
            X509PublicKeyInfo x509PublicKeyInfo = this;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new RuntimeException("ASN1Exception \ubc1c\uc0dd!");
        }
        SEQUENCE sEQUENCE2 = sEQUENCE;
        sEQUENCE2();
        sEQUENCE.addComponent(this.publicKeyAlgorithm.toASN1());
        sEQUENCE.addComponent(new BitString(this.encode()));
        x509PublicKeyInfo.a = new ASN1Info(sEQUENCE2);
    }

    public abstract void decode(byte[] var1) throws CryptoException;

    public void decode(ASN1 aSN1) throws ASN1Exception {
        this.a = new ASN1Info(aSN1);
        try {
            this.a();
            return;
        }
        catch (CryptoException cryptoException) {
            throw new ASN1Exception(cryptoException.toString());
        }
    }

    public abstract byte[] encode();

    public abstract String getAlgorithm();

    public byte[] getEncoded() {
        return this.a.toByteArray();
    }

    public String getFormat() {
        return "X.509";
    }

    public ASN1 toASN1() {
        return this.a.toASN1();
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("\ud604\uc7ac \uacf5\uac1c\ud0a4 \uc815\ubcf4\ub294 ");
        if (this.publicKeyAlgorithm.equals(AlgorithmID.rsaEncryption)) {
            stringBuffer2.append("RSA \uacf5\uac1c\ud0a4\ub97c \ud3ec\ud568\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.");
        } else if (this.publicKeyAlgorithm.equals(AlgorithmID.dsa)) {
            stringBuffer2.append("DSA \uacf5\uac1c\ud0a4\ub97c \ud3ec\ud568\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.");
        } else if (this.publicKeyAlgorithm.equals(AlgorithmID.kcdsa)) {
            stringBuffer2.append("KCDSA \uacf5\uac1c\ud0a4\ub97c \ud3ec\ud568\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.");
        } else if (this.publicKeyAlgorithm.equals(AlgorithmID.dhKeyAgreement)) {
            stringBuffer2.append("DH \uacf5\uac1c\ud0a4\ub97c \ud3ec\ud568\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.");
        } else {
            stringBuffer2.append(this.publicKeyAlgorithm.getName() + " \ud0a4\ub97c \ud3ec\ud568\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4.");
        }
        return stringBuffer2.toString();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a.writeTo(outputStream);
    }

    public final void a() throws CryptoException {
        try {
            X509PublicKeyInfo x509PublicKeyInfo = this;
            x509PublicKeyInfo.publicKeyAlgorithm = new AlgorithmID(this.a.getComponentAt(0));
            x509PublicKeyInfo.decode((byte[])x509PublicKeyInfo.a.getComponentAt(1).getValue());
            return;
        }
        catch (Exception exception) {
            throw new CryptoException("\uacf5\uac1c\ud0a4 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4: " + exception.toString());
        }
    }
}

