/*
 * Decompiled with CFR 0.152.
 */
package com.initech.license.crypto.asn1;

import com.initech.license.crypto.asn1.Base64Exception;
import com.initech.license.crypto.asn1.Base64InputStream;
import com.initech.license.crypto.asn1.Base64OutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Vector;

public class ASN1Util {
    public static void fillZeros(byte[] byArray) {
        ASN1Util.fillZeros(byArray, 0, byArray.length);
    }

    public static void fillZeros(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byArray[i2] = 0;
        }
    }

    public static void fillZeros(int[] nArray) {
        ASN1Util.fillZeros(nArray, 0, nArray.length);
    }

    public static void fillZeros(int[] nArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            nArray[i2] = 0;
        }
    }

    public static void copy(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[i2];
        }
    }

    public static void copy(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2;
            byArray2[n5] = byArray[n2 + i2];
        }
    }

    public static void copy(int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2];
        }
    }

    public static void copy(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3 + i2;
            nArray2[n5] = nArray[n2 + i2];
        }
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n2 = byArray.length;
        return ASN1Util.equals(byArray, 0, byArray2, 0, n2);
    }

    public static boolean equals(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            if (byArray[n2 + i2] == byArray2[n3 + i2]) continue;
            return false;
        }
        return true;
    }

    public static String a(byte[] object) {
        PrintWriter printWriter;
        PrintWriter printWriter2;
        PrintWriter printWriter3;
        ByteArrayOutputStream byteArrayOutputStream;
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])object)));
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter4 = printWriter3;
        printWriter3 = new PrintWriter((OutputStream)object);
        String string2 = null;
        while (true) {
            String string3;
            block11: {
                string3 = bufferedReader2.readLine();
                if (string3 == null) break;
                if (string2 == null) break block11;
                PrintWriter printWriter5 = printWriter4;
                printWriter5.println("\"" + string2 + "\" +");
            }
            string2 = string3;
        }
        try {
            PrintWriter printWriter6 = printWriter4;
            printWriter2 = printWriter6;
            printWriter = printWriter6;
        }
        catch (IOException iOException) {
            return null;
        }
        printWriter2.println("\"" + string2 + "\";");
        printWriter.flush();
        return new String(((ByteArrayOutputStream)object).toByteArray());
    }

    public static byte[] base64ToBytes(String string2) {
        try {
            return ASN1Util.decodeBase64(string2.getBytes());
        }
        catch (Base64Exception base64Exception) {
            base64Exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeBase64(byte[] object) throws Base64Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream byteArrayInputStream;
        Base64InputStream base64InputStream;
        Base64InputStream base64InputStream2 = base64InputStream;
        Object object2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        base64InputStream = new Base64InputStream((InputStream)object2);
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        object2 = new byte[1024];
        while (true) {
            int n2;
            try {
                n2 = base64InputStream2.read((byte[])object2);
                if (n2 <= 0) break;
            }
            catch (IOException iOException) {
                throw new Base64Exception(iOException.getMessage());
            }
            {
                ((ByteArrayOutputStream)object).write((byte[])object2, 0, n2);
                continue;
            }
            break;
        }
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public static byte[] encodeBase64(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream2, false);
        try {
            base64OutputStream.write(byArray);
            base64OutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream2, bl);
        try {
            base64OutputStream.write(byArray);
            base64OutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static void fillArray(byte[] byArray, InputStream inputStream) throws IOException {
        int n2;
        int n3 = 0;
        int n4 = byArray.length;
        while ((n2 = inputStream.read(byArray, n3, n4)) >= 0) {
            n3 += n2;
            if ((n4 -= n2) > 0) continue;
            return;
        }
        throw new EOFException();
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream(10240);
        byte[] byArray = new byte[10240];
        int n2;
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream2.write(byArray, 0, n2);
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public static byte[] resizeArray(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = Math.min(n2, byArray.length);
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public static Object[] resizeArray(Object[] objectArray, int n2) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        int n3 = Math.min(n2, objectArray.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        return objectArray2;
    }

    public static Object[] toArray(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Object[] toArray(Vector vector, Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, vector.size());
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String toBase64String(byte[] byArray) {
        return ASN1Util.toBase64String(byArray, false);
    }

    public static String toBase64String(byte[] byArray, boolean bl) {
        byArray = ASN1Util.encodeBase64(byArray);
        if (bl) {
            return ASN1Util.a(byArray);
        }
        return new String(byArray);
    }

    public static int toByte(char c2, int n2) {
        if ((c2 = c2 >= '0' && c2 <= '9' ? (char)(c2 - 48) : (c2 >= 'A' && c2 <= 'Z' ? (char)(c2 - 65 + 10) : (c2 >= 'a' && c2 <= 'z' ? (char)(c2 - 97 + 10) : (char)-1))) >= '\u0000' && c2 < n2) {
            return c2;
        }
        return -1;
    }

    public static byte[] toByteArray(String string2) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = string2.length();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = -1;
            if (n3 == -1) {
                n3 = ASN1Util.toByte(string2.charAt(i2), 16);
            } else {
                n4 = ASN1Util.toByte(string2.charAt(i2), 16);
            }
            if (n3 == -1 || n4 == -1) continue;
            byteArrayOutputStream2.write(n3 << 4 | n4);
            n3 = -1;
        }
        return byteArrayOutputStream2.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toPem(byte[] byArray, String string2, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream(10240);
        try {
            String string3 = System.getProperty("line.separator");
            if (string2 == null) {
                string2 = "PRIVACY-ENHANCED MESSAGE";
            }
            byteArrayOutputStream2.write(("-----BEGIN " + string2 + "-----" + string3).getBytes());
            if (!bl) {
                byteArrayOutputStream2.write(ASN1Util.encodeBase64(byArray, true));
            } else {
                byteArrayOutputStream2.write(byArray);
            }
            byteArrayOutputStream2.write((string3 + "-----END " + string2 + "-----" + string3).getBytes());
            return new String(byteArrayOutputStream2.toByteArray());
        }
        catch (IOException iOException) {}
        return new String(byteArrayOutputStream2.toByteArray());
    }

    public static String toString(byte[] byArray) {
        return ASN1Util.toString(byArray, 0, byArray.length);
    }

    public static String toString(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer;
        if (byArray.length < n2 + n3) {
            n3 = byArray.length - n2;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(n3 * 2);
        boolean bl = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer2.append(":");
            }
            stringBuffer2.append(ASN1Util.toString(byArray[n2 + i2]));
        }
        return stringBuffer2.toString();
    }

    public static String toString(byte by) {
        Character c2;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(2);
        char c3 = (by & 0xF0) >> 4;
        by = (byte)(by & 0xF);
        c3 = (char)(c3 > '\t' ? c3 + 65 - 10 : c3 + 48);
        Character c4 = new Character(c3);
        stringBuffer2.append(c4);
        by = (byte)(by > 9 ? by + 65 - 10 : by + 48);
        StringBuffer stringBuffer3 = stringBuffer2;
        Character c5 = c2;
        c5((char)by);
        stringBuffer3.append(c5);
        return stringBuffer3.toString();
    }

    public static String toString(int n2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = n2 >> 24;
        byArray2[1] = (byte)(n2 >> 16);
        byArray2[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)n2;
        return ASN1Util.toString(byArray);
    }

    public static String toString(long l2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        return stringBuilder.append(ASN1Util.toString((int)(l2 >> 32))).append(":").append(ASN1Util.toString((int)l2)).toString();
    }
}

