/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs11.jce;

import com.initech.pkcs.pkcs11.PKCS11Exception;
import com.initech.pkcs.pkcs11.data.CK_ATTRIBUTE;
import com.initech.pkcs.pkcs11.data.CK_MECHANISM;
import com.initech.pkcs.pkcs11.jce.JCEMechanismDictionary;
import com.initech.pkcs.pkcs11.jce.JCEToken;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;

public class JCESession {
    public Cipher cipher;
    public Signature signature;
    public MessageDigest messageDigest;
    public KeyPairGenerator keyPairGenerator;
    public JCEToken token;
    public KeyGenerator keyGenerator;
    public SecureRandom secureRandom;
    public long slotID;
    public long sid;
    public long state;
    public long flags;
    public CK_ATTRIBUTE[] a;
    public Enumeration b;

    public JCESession(long l2, long l3, long l4, JCEToken jCEToken, SecureRandom secureRandom) {
        this.slotID = l2;
        this.sid = l3;
        this.token = jCEToken;
        this.flags = l4;
        this.state = (l4 & 2L) == 0L ? 0L : 2L;
        this.secureRandom = secureRandom;
    }

    public static boolean a(CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
        boolean bl = true;
        for (int i2 = 0; i2 < cK_ATTRIBUTEArray.length; ++i2) {
            boolean bl2 = false;
            for (int i3 = 0; i3 < cK_ATTRIBUTEArray2.length; ++i3) {
                if (cK_ATTRIBUTEArray[i2].type != cK_ATTRIBUTEArray2[i3].type) continue;
                if (cK_ATTRIBUTEArray[i2].value instanceof byte[] && cK_ATTRIBUTEArray2[i3].value instanceof byte[]) {
                    byte[] byArray = (byte[])cK_ATTRIBUTEArray[i2].value;
                    byte[] byArray2 = (byte[])cK_ATTRIBUTEArray2[i3].value;
                    if (byArray.length != byArray2.length) continue;
                    bl2 = true;
                    for (int i4 = 0; i4 < byArray.length; ++i4) {
                        if (byArray[i4] == byArray2[i4]) continue;
                        bl2 = false;
                    }
                    continue;
                }
                if (!cK_ATTRIBUTEArray[i2].value.equals(cK_ATTRIBUTEArray2[i3].value)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    public void login(long l2, byte[] byArray) {
    }

    public void logout() {
    }

    public void findObjectInit(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        this.a = cK_ATTRIBUTEArray;
        this.b = this.token.objManager.getObjectEnum();
    }

    public long[] findObject(long l2) throws PKCS11Exception {
        if (this.a != null && this.b != null) {
            long[] lArray = new long[(int)l2];
            long l3 = l2;
            while (this.b.hasMoreElements() && l3 != 0L) {
                JCESession jCESession = this;
                long l4 = (Long)jCESession.b.nextElement();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = jCESession.token.objManager.getAttribute(l4);
                if (cK_ATTRIBUTEArray != null) {
                    if (!JCESession.a(this.a, cK_ATTRIBUTEArray)) continue;
                    lArray[(int)(l2 - l3)] = l4;
                    --l3;
                    continue;
                }
                throw new PKCS11Exception("ck_attribute is null");
            }
            if (l3 == l2) {
                return null;
            }
            if (l3 != 0L) {
                long[] lArray2 = lArray;
                int n2 = (int)l3;
                lArray = new long[n2];
                System.arraycopy(lArray2, 0, lArray, 0, n2);
            }
            return lArray;
        }
        throw new PKCS11Exception("findObject not initialized");
    }

    public void findObjectFinal() throws PKCS11Exception {
        JCESession jCESession = this;
        jCESession.a = null;
        jCESession.b = null;
    }

    public void signInit(CK_MECHANISM object, long l2) throws PKCS11Exception {
        JCESession jCESession;
        JCESession jCESession2;
        try {
            JCESession jCESession3 = this;
            jCESession2 = jCESession3;
            jCESession = jCESession3;
            jCESession3.signature = Signature.getInstance(JCEMechanismDictionary.getNamebyMechanism((CK_MECHANISM)object));
            object = jCESession3.token.objManager.getAlias(l2);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
        JCEToken jCEToken = jCESession2.token;
        object = (PrivateKey)jCEToken.keyStore.getKey((String)object, jCEToken.pin);
        jCESession.signature.initSign((PrivateKey)object, this.secureRandom);
    }

    public void signUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        try {
            this.signature.update(byArray, n2, n3);
            return;
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
    }

    public byte[] signFinal() throws PKCS11Exception {
        try {
            return this.signature.sign();
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyInit(CK_MECHANISM object, long l2) throws PKCS11Exception {
        Certificate certificate;
        block6: {
            JCESession jCESession;
            try {
                JCESession jCESession2 = this;
                jCESession = jCESession2;
                jCESession2.signature = Signature.getInstance(JCEMechanismDictionary.getNamebyMechanism((CK_MECHANISM)object));
                object = jCESession2.token.objManager.getAlias(l2);
            }
            catch (Exception exception) {
                throw new PKCS11Exception(exception.toString());
            }
            certificate = jCESession.token.keyStore.getCertificate((String)object);
            if (certificate != null) break block6;
            object = this.token.keyStore.getCertificateChain((String)object);
            if (object == null) break block6;
            certificate = object[0];
        }
        if (certificate == null) throw new PKCS11Exception("Certificate not found !!");
        this.signature.initVerify(certificate.getPublicKey());
    }

    public void verifyUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        try {
            this.signature.update(byArray, n2, n3);
            return;
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verifyFinal(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        try {
            if (byArray.length < n3 + n2) throw new PKCS11Exception("sig array is short(" + byArray.length + ") than required length(" + n3 + ")");
            if (n2 < 0) throw new PKCS11Exception("idx is negative");
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
        JCESession jCESession = object;
        byte[] byArray2 = byArray;
        int n4 = n2;
        byte[] byArray3 = new byte[n3];
        Object object = byArray3;
        System.arraycopy(byArray2, n4, byArray3, 0, n3);
        return jCESession.signature.verify((byte[])object);
    }

    public void seedRandom(byte[] byArray) throws PKCS11Exception {
        try {
            this.secureRandom.setSeed(byArray);
            return;
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
    }

    public void generateRandom(byte[] byArray) throws PKCS11Exception {
        try {
            this.secureRandom.nextBytes(byArray);
            return;
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
    }
}

