/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs11.jce;

import com.initech.pkcs.pkcs11.PKCS11;
import com.initech.pkcs.pkcs11.PKCS11Exception;
import com.initech.pkcs.pkcs11.data.CK_ATTRIBUTE;
import com.initech.pkcs.pkcs11.data.CK_INFO;
import com.initech.pkcs.pkcs11.data.CK_MECHANISM;
import com.initech.pkcs.pkcs11.data.CK_MECHANISM_INFO;
import com.initech.pkcs.pkcs11.data.CK_SESSION_INFO;
import com.initech.pkcs.pkcs11.data.CK_SLOT_INFO;
import com.initech.pkcs.pkcs11.data.CK_TOKEN_INFO;
import com.initech.pkcs.pkcs11.data.CK_VERSION;
import com.initech.pkcs.pkcs11.jce.JCEMechanismDictionary;
import com.initech.pkcs.pkcs11.jce.JCESession;
import com.initech.pkcs.pkcs11.jce.JCESessionManager;
import com.initech.pkcs.pkcs11.jce.JCEToken;
import com.initech.pkcs.pkcs11.jce.JCETokenManager;
import com.initech.pkcs.pkcs11.jce.PKCS11JCEImplHelper;
import com.initech.pki.INISAFEPKI;
import java.io.File;
import java.security.SecureRandom;

public class PKCS11JCEImpl
implements PKCS11 {
    public JCESessionManager a;
    public JCETokenManager b;
    public String c;
    public SecureRandom d;

    public PKCS11JCEImpl(String string2) throws PKCS11Exception {
        this.c = string2;
    }

    public void setTokenManager(JCETokenManager jCETokenManager) {
        this.b = jCETokenManager;
    }

    public JCETokenManager getTokenManager() {
        return this.b;
    }

    public void setSessionManager(JCESessionManager jCESessionManager) {
        this.a = jCESessionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void C_Initialize(boolean bl) throws PKCS11Exception {
        try {
            new PKCS11JCEImplHelper(this).parse(new File(this.c));
            if (INISAFEPKI.getInstance().isPrint) {
                System.out.println("PKCS11JCEImpl boot up!!");
            }
            this.d = SecureRandom.getInstance("X9.17", "Initech");
            return;
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.toString());
        }
    }

    @Override
    public void C_Finalize() throws PKCS11Exception {
        if (INISAFEPKI.getInstance().isPrint) {
            System.out.println("PKCS11JCEImpl shut down!!");
        }
    }

    @Override
    public CK_INFO C_GetInfo() throws PKCS11Exception {
        CK_INFO cK_INFO;
        CK_INFO cK_INFO2 = cK_INFO;
        cK_INFO2.cryptokiVersion = new CK_VERSION();
        new CK_VERSION().major = 1;
        new CK_VERSION().minor = 0;
        new CK_INFO().manufacturerID = "Initech Co.,LTD.".getBytes();
        cK_INFO2.flags = 0L;
        cK_INFO2.libraryDescription = "InitechJCEWrapper".getBytes();
        cK_INFO2.libraryVersion = new CK_VERSION();
        new CK_VERSION().major = 1;
        new CK_VERSION().minor = 0;
        return cK_INFO2;
    }

    @Override
    public long[] C_GetSlotList(boolean bl) throws PKCS11Exception {
        return this.b.getSlotList();
    }

    @Override
    public CK_SLOT_INFO C_GetSlotInfo(long l2) throws PKCS11Exception {
        CK_SLOT_INFO cK_SLOT_INFO;
        CK_SLOT_INFO cK_SLOT_INFO2 = cK_SLOT_INFO;
        new CK_SLOT_INFO().slotDescription = "InitechJCEWrapperSlot".getBytes();
        cK_SLOT_INFO2.manufacturerID = "Initech Co.,LTD.".getBytes();
        cK_SLOT_INFO2.flags = 0L;
        cK_SLOT_INFO2.hardwareVersion = new CK_VERSION();
        new CK_VERSION().major = 1;
        new CK_VERSION().minor = 0;
        cK_SLOT_INFO2.firmwareVersion = new CK_VERSION();
        new CK_VERSION().major = 1;
        new CK_VERSION().minor = 0;
        return cK_SLOT_INFO2;
    }

    @Override
    public CK_TOKEN_INFO C_GetTokenInfo(long l2) throws PKCS11Exception {
        CK_TOKEN_INFO cK_TOKEN_INFO;
        CK_TOKEN_INFO cK_TOKEN_INFO2 = cK_TOKEN_INFO;
        new CK_TOKEN_INFO().label = "JCE".getBytes();
        cK_TOKEN_INFO2.manufacturerID = "Initech Co.,LTD.".getBytes();
        cK_TOKEN_INFO2.model = "JCE".getBytes();
        cK_TOKEN_INFO2.serialNumber = "1".getBytes();
        cK_TOKEN_INFO2.utcTime = "1".getBytes();
        cK_TOKEN_INFO2.hardwareVersion = new CK_VERSION();
        new CK_VERSION().major = 1;
        new CK_VERSION().minor = 0;
        cK_TOKEN_INFO2.firmwareVersion = new CK_VERSION();
        new CK_VERSION().major = 1;
        new CK_VERSION().minor = 0;
        return cK_TOKEN_INFO2;
    }

    @Override
    public void C_InitToken(long l2, byte[] byArray, byte[] objectArray) throws PKCS11Exception {
        JCEMechanismDictionary.load();
        objectArray = new char[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            objectArray[i2] = (char)byArray[i2];
        }
        this.b.initToken(l2, (char[])objectArray);
    }

    @Override
    public long[] C_GetMechanismList(long l2) throws PKCS11Exception {
        return JCEMechanismDictionary.getIDList();
    }

    @Override
    public CK_MECHANISM_INFO C_GetMechanismInfo(long l2, long l3) throws PKCS11Exception {
        CK_MECHANISM_INFO cK_MECHANISM_INFO;
        CK_MECHANISM_INFO cK_MECHANISM_INFO2 = cK_MECHANISM_INFO;
        cK_MECHANISM_INFO2();
        cK_MECHANISM_INFO2.flags = JCEMechanismDictionary.getFunctionality(l3);
        cK_MECHANISM_INFO2.ulMinKeySize = JCEMechanismDictionary.getMinKey(l3);
        cK_MECHANISM_INFO.ulMaxKeySize = JCEMechanismDictionary.getMaxKey(l3);
        return cK_MECHANISM_INFO;
    }

    @Override
    public long C_OpenSession(long l2, long l3, Object object, Object object2) throws PKCS11Exception {
        PKCS11JCEImpl pKCS11JCEImpl = secureRandom;
        object = pKCS11JCEImpl.b.getToken(l2);
        SecureRandom secureRandom = ((PKCS11JCEImpl)((Object)secureRandom)).d;
        return pKCS11JCEImpl.a.createSession(l2, (JCEToken)object, l3, secureRandom);
    }

    @Override
    public void C_CloseSession(long l2) throws PKCS11Exception {
        this.a.removeSession(l2);
    }

    @Override
    public void C_CloseAllSessions(long l2) throws PKCS11Exception {
        this.a.removeAllSession(l2);
    }

    @Override
    public CK_SESSION_INFO C_GetSessionInfo(long l2) throws PKCS11Exception {
        return new CK_SESSION_INFO();
    }

    @Override
    public void C_Login(long l2, long l3, byte[] byArray) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.login(l3, byArray);
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public void C_Logout(long l2) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.logout();
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public long C_CreateObject(long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            return jCESession.token.objManager.createObject(cK_ATTRIBUTEArray);
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131\uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public long C_CopyObject(long l2, long l3, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        return -1L;
    }

    @Override
    public void C_DestroyObject(long l2, long l3) throws PKCS11Exception {
    }

    @Override
    public long C_GetObjectSize(long l2, long l3) throws PKCS11Exception {
        return -1L;
    }

    @Override
    public CK_ATTRIBUTE[] C_GetAttributeValue(long l2, long l3, long[] lArray) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            return jCESession.token.objManager.getAttribute(l3, lArray);
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public void C_SetAttributeValue(long l2, long l3, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
    }

    @Override
    public void C_FindObjectsInit(long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.findObjectInit(cK_ATTRIBUTEArray);
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public long[] C_FindObjects(long l2, long l3) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            return jCESession.findObject(l3);
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public void C_FindObjectsFinal(long l2) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.findObjectFinal();
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public void C_SignInit(long l2, CK_MECHANISM cK_MECHANISM, long l3) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.signInit(cK_MECHANISM, l3);
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public byte[] C_Sign(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        this.C_SignUpdate(l2, byArray, n2, n3);
        return this.C_SignFinal(l2);
    }

    @Override
    public void C_SignUpdate(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.signUpdate(byArray, n2, n3);
            return;
        }
        throw new PKCS11Exception("JCESession\uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public byte[] C_SignFinal(long l2) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            return jCESession.signFinal();
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public void C_VerifyInit(long l2, CK_MECHANISM cK_MECHANISM, long l3) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.verifyInit(cK_MECHANISM, l3);
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public boolean C_Verify(long l2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws PKCS11Exception {
        this.C_VerifyUpdate(l2, byArray, n2, n3);
        return this.C_VerifyFinal(l2, byArray2, n4, n5);
    }

    @Override
    public void C_VerifyUpdate(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.verifyUpdate(byArray, n2, n3);
            return;
        }
        throw new PKCS11Exception("JCESession \uc0dd\uc131 \uc2e4\ud328");
    }

    @Override
    public boolean C_VerifyFinal(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            return jCESession.verifyFinal(byArray, n2, n3);
        }
        throw new PKCS11Exception("JCESession \uc0dd\uc131 \uc2e4\ud328");
    }

    @Override
    public void C_EncryptInit(long l2, CK_MECHANISM cK_MECHANISM, long l3) throws PKCS11Exception {
    }

    @Override
    public byte[] C_Encrypt(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return null;
    }

    @Override
    public long C_Encrypt(long l2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return 0L;
    }

    @Override
    public long C_EncryptUpdate(long l2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return 0L;
    }

    @Override
    public byte[] C_EncryptUpdate(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return null;
    }

    @Override
    public long C_EncryptFinal(long l2, byte[] byArray, int n2) throws PKCS11Exception {
        return 0L;
    }

    @Override
    public byte[] C_EncryptFinal(long l2) throws PKCS11Exception {
        return null;
    }

    @Override
    public void C_DecryptInit(long l2, CK_MECHANISM cK_MECHANISM, long l3) throws PKCS11Exception {
    }

    @Override
    public byte[] C_Decrypt(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return null;
    }

    @Override
    public long C_Decrypt(long l2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return 0L;
    }

    @Override
    public long C_DecryptUpdate(long l2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return 0L;
    }

    @Override
    public byte[] C_DecryptUpdate(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return null;
    }

    @Override
    public long C_DecryptFinal(long l2, byte[] byArray, int n2) throws PKCS11Exception {
        return 0L;
    }

    @Override
    public byte[] C_DecryptFinal(long l2) throws PKCS11Exception {
        return null;
    }

    @Override
    public void C_DigestInit(long l2, CK_MECHANISM cK_MECHANISM) throws PKCS11Exception {
    }

    @Override
    public byte[] C_Digest(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return null;
    }

    @Override
    public void C_DigestUpdate(long l2, byte[] byArray, int n2, int n3) throws PKCS11Exception {
    }

    @Override
    public byte[] C_DigestFinal(long l2) throws PKCS11Exception {
        return null;
    }

    @Override
    public long C_GenerateKey(long l2, CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        return -1L;
    }

    @Override
    public long[] C_GenerateKeyPair(long l2, CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) throws PKCS11Exception {
        return null;
    }

    @Override
    public byte[] C_WrapKey(long l2, CK_MECHANISM cK_MECHANISM, long l3, long l4) throws PKCS11Exception {
        return null;
    }

    @Override
    public long C_UnwrapKey(long l2, CK_MECHANISM cK_MECHANISM, long l3, byte[] byArray, int n2, int n3, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        return -1L;
    }

    @Override
    public void C_SeedRandom(long l2, byte[] byArray) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.seedRandom(byArray);
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public void C_GenerateRandom(long l2, byte[] byArray) throws PKCS11Exception {
        JCESession jCESession = ((PKCS11JCEImpl)((Object)jCESession)).a.getSessionObject(l2);
        if (jCESession != null) {
            jCESession.generateRandom(byArray);
            return;
        }
        throw new PKCS11Exception("JCESession \uac1d\uccb4 \uc0dd\uc131 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }
}

