/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkix.cmp.transport;

import com.initech.asn1.IllegalEncodingException;
import com.initech.pkix.cmp.transport.ByteIntConvertor;
import com.initech.pkix.cmp.transport.ErrMsgRep;
import com.initech.pkix.cmp.transport.FinRep;
import com.initech.pkix.cmp.transport.InvalidMessageLengthException;
import com.initech.pkix.cmp.transport.InvalidMessageTypeException;
import com.initech.pkix.cmp.transport.PkiRep;
import com.initech.pkix.cmp.transport.PkiReq;
import com.initech.pkix.cmp.transport.PollRep;
import com.initech.pkix.cmp.transport.PollReq;
import com.initech.pkix.cmp.transport.SessionClosedException;
import com.initech.pkix.cmp.transport.SessionException;
import com.initech.pkix.cmp.transport.VersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class CMPMessage {
    public static final byte PKI_MSG = 0;
    public static final byte PKI_REQ = 0;
    public static final byte POLL_REP = 1;
    public static final byte POLL_REQ = 2;
    public static final byte NEG_POLL_REP = 3;
    public static final byte FIN_REP = 3;
    public static final byte PARTIAL_MSG_REP = 4;
    public static final byte PKI_REP = 5;
    public static final byte FINAL_MSG_REP = 5;
    public static final byte ERR_REP = 6;
    public static final byte VERSION_RFC2510 = 0;
    public static final byte VERSION_PKIX_DRAFT = 10;
    public byte version;
    public byte flag;
    public byte type;
    public byte[] rawdata;

    public static void a(InputStream inputStream, byte[] byArray, int n2, int n3) throws SessionClosedException {
        n2 = 0;
        while (n3 > 0) {
            block4: {
                try {
                    int n4 = inputStream.read(byArray, n2 + 0, n3);
                    if (n4 < 0) break block4;
                    n2 += n4;
                    n3 -= n4;
                    continue;
                }
                catch (IOException iOException) {
                    throw new SessionClosedException(iOException.toString());
                }
            }
            throw new SessionClosedException("connection closed by peer");
        }
    }

    public static final CMPMessage getInstance(InputStream inputStream) throws SessionException, SessionClosedException, VersionNotSupportedException, InvalidMessageTypeException, InvalidMessageLengthException {
        return CMPMessage.getInstance(inputStream, Short.MAX_VALUE);
    }

    public static final CMPMessage getInstance(InputStream inputStream, int n2) throws SessionException, SessionClosedException, VersionNotSupportedException, InvalidMessageTypeException, InvalidMessageLengthException {
        byte[] byArray = new byte[4];
        CMPMessage.a(inputStream, byArray, 0, 4);
        int n3 = ByteIntConvertor.byte2int(byArray, 0);
        if (n3 <= n2 && n3 >= 0) {
            Object object;
            byte[] byArray2 = new byte[n3];
            CMPMessage.a(inputStream, byArray2, 0, n3);
            byte by = (byArray2[0] == 10 ? 10 : 0) == 0 ? byArray2[0] : byArray2[2];
            switch (by) {
                default: {
                    throw new InvalidMessageTypeException(by);
                }
                case 6: {
                    ErrMsgRep errMsgRep;
                    object = errMsgRep;
                    errMsgRep = new ErrMsgRep();
                    break;
                }
                case 5: {
                    PkiRep pkiRep;
                    object = pkiRep;
                    pkiRep = new PkiRep();
                    break;
                }
                case 3: {
                    FinRep finRep;
                    object = finRep;
                    finRep = new FinRep();
                    break;
                }
                case 2: {
                    PollReq pollReq;
                    object = pollReq;
                    pollReq = new PollReq();
                    break;
                }
                case 1: {
                    PollRep pollRep;
                    object = pollRep;
                    pollRep = new PollRep();
                    break;
                }
                case 0: {
                    PkiReq pkiReq;
                    object = pkiReq;
                    pkiReq = new PkiReq();
                }
            }
            try {
                CMPMessage cMPMessage = object;
                cMPMessage.decode(byArray2);
                return cMPMessage;
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
                throw new SessionException("Failed to decode TCP message", (Exception)object);
            }
        }
        throw new InvalidMessageLengthException();
    }

    public final byte getMessageType() {
        return this.type;
    }

    public final boolean shouldClose() {
        return (this.flag & 1) != 0;
    }

    public final void setConnectionClose() {
        this.flag = 1;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int n2) {
        this.version = (byte)n2;
    }

    public final void setVersion(CMPMessage cMPMessage) {
        this.version = (byte)cMPMessage.getVersion();
    }

    public final byte[] getRawData() {
        return (byte[])this.rawdata.clone();
    }

    public final byte[] getEncoded() {
        int n2;
        byte[] byArray;
        CMPMessage cMPMessage = this;
        byte[] byArray2 = cMPMessage.encodeValue();
        cMPMessage.rawdata = byArray2;
        if (cMPMessage.version == 0) {
            byte[] byArray3 = new byte[byArray2.length + 5];
            byArray = byArray3;
            ByteIntConvertor.int2byte(byArray2.length + 1, byArray, 0);
            byArray3[4] = this.type;
            n2 = 5;
        } else {
            byte[] byArray4 = new byte[byArray2.length + 7];
            byArray = byArray4;
            ByteIntConvertor.int2byte(byArray2.length + 3, byArray, 0);
            byArray[4] = 10;
            byArray[5] = this.flag;
            byArray4[6] = this.type;
            n2 = 7;
        }
        int n3 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return byArray;
    }

    public final void decode(byte[] byArray) throws IllegalEncodingException {
        int n2 = byArray[0] == 10 ? 10 : 0;
        this.version = (byte)n2;
        if (n2 == 0) {
            this.flag = 0;
            this.type = byArray[0];
            n2 = 1;
        } else {
            this.flag = byArray[1];
            this.type = byArray[2];
            n2 = 3;
        }
        byte[] byArray2 = byArray;
        int n3 = byArray.length - n2;
        byArray = new byte[n3];
        System.arraycopy(byArray2, n2, byArray, 0, n3);
        this.rawdata = byArray;
        this.decodeValue(byArray);
    }

    public abstract byte[] encodeValue();

    public abstract void decodeValue(byte[] var1) throws IllegalEncodingException;

    public final void writeTo(OutputStream outputStream) throws SessionException {
        try {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(this.getEncoded());
            outputStream2.flush();
            return;
        }
        catch (IOException iOException) {
            throw new SessionException(iOException.toString());
        }
    }
}

