/*
 * Decompiled with CFR 0.152.
 */
package com.initech.xsafe.cert;

import android.content.Context;
import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.BEREncoder;
import com.initech.core.INISAFECore;
import com.initech.core.crypto.INIHandlerKeyPair;
import com.initech.core.exception.INICoreException;
import com.initech.core.x509.X509CertImpl;
import com.initech.core.x509.x509CertificateInfo;
import com.initech.inibase.logger.PropertyConfigurator;
import com.initech.pkcs.pkcs7.ContentInfo;
import com.initech.pkcs.pkcs7.PKCS7Type;
import com.initech.pkcs.pkcs7.SignedData;
import com.initech.pkcs.pkcs7.SignerInfo;
import com.initech.pki.util.Base64Util;
import com.initech.provider.crypto.InitechProvider;
import com.initech.xsafe.INISAFEXSAFE;
import com.initech.xsafe.cert.AliasCA;
import com.initech.xsafe.cert.AliasOID;
import com.initech.xsafe.cert.CertInfo;
import com.initech.xsafe.cert.CertUtil;
import com.initech.xsafe.cert.INIXSAFEException;
import com.initech.xsafe.cert.InnerDirectoryFilter;
import com.initech.xsafe.cert.InnerExtensionFilter;
import com.initech.xsafe.cert.KeyPadCipher;
import com.initech.xsafe.storage.CertStorageManager;
import com.initech.xsafe.util.ContextManager;
import com.initech.xsafe.util.Converter;
import com.initech.xsafe.util.StorageUtil;
import com.initech.xsafe.util.mlog.IniSafeLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;

public class CertificateManager {
    public static final FileFilter CERT_FILTER;
    public static final FileFilter KEY_FILTER;
    public static final FileFilter ANY_FILE_FILTER;
    public static final FileFilter USER_DIRECTORY_FILTER;
    public static final String PRODUCT_NAME_SHORT = "INISAFEXSafe";
    public static volatile String f;
    public static volatile boolean g;
    public static volatile String[] h;
    public static final /* synthetic */ boolean i;
    public ArrayList<CertInfo> a;
    public ArrayList<CertInfo> b;
    public ArrayList<CertInfo> c;
    public ArrayList<CertInfo> d;
    public Context e;

    /*
     * WARNING - void declaration
     */
    public CertificateManager(Context context) {
        void var1_1;
        this.a = new ArrayList();
        this.b = new ArrayList();
        this.c = new ArrayList();
        this.d = new ArrayList();
        if (!INISAFEXSAFE.hasLicense()) {
            return;
        }
        CertificateManager certificateManager = this;
        this.e = var1_1;
        ContextManager.setContext((Context)var1_1);
        certificateManager.init();
        certificateManager.a();
    }

    /*
     * WARNING - void declaration
     */
    public CertificateManager(Context context, InputStream licenseStream) throws INIXSAFEException {
        void var1_1;
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        ArrayList arrayList5 = arrayList4;
        arrayList4 = new ArrayList();
        this.a = arrayList5;
        arrayList5 = arrayList3;
        arrayList3 = new ArrayList();
        this.b = arrayList5;
        arrayList5 = arrayList2;
        arrayList2 = new ArrayList();
        this.c = arrayList5;
        arrayList5 = arrayList;
        arrayList = new ArrayList();
        this.d = arrayList5;
        if (licenseStream != null) {
            void var2_2;
            INISAFEXSAFE.setLicense((InputStream)var2_2);
        }
        CertificateManager certificateManager = this;
        this.e = var1_1;
        ContextManager.setContext((Context)var1_1);
        certificateManager.init();
        certificateManager.a();
    }

    /*
     * WARNING - void declaration
     */
    public CertificateManager(Context context, String config) {
        void var2_2;
        void var1_1;
        this.a = new ArrayList();
        this.b = new ArrayList();
        this.c = new ArrayList();
        this.d = new ArrayList();
        if (!INISAFEXSAFE.hasLicense()) {
            return;
        }
        CertificateManager certificateManager = this;
        this.e = var1_1;
        ContextManager.setContext((Context)var1_1);
        certificateManager.a((String)var2_2);
        certificateManager.a();
    }

    /*
     * WARNING - void declaration
     */
    public CertificateManager(Context context, int useStorageType) {
        void var2_2;
        void var1_1;
        this.a = new ArrayList();
        this.b = new ArrayList();
        this.c = new ArrayList();
        this.d = new ArrayList();
        if (!INISAFEXSAFE.hasLicense()) {
            return;
        }
        CertificateManager certificateManager = this;
        this.e = var1_1;
        ContextManager.setContext((Context)var1_1);
        certificateManager.init();
        certificateManager.b((int)var2_2);
    }

    @Deprecated
    public CertificateManager() {
        this.a = new ArrayList();
        this.b = new ArrayList();
        this.c = new ArrayList();
        this.d = new ArrayList();
        if (!INISAFEXSAFE.hasLicense()) {
            return;
        }
        CertificateManager certificateManager = this;
        certificateManager.init();
        certificateManager.a();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public CertificateManager(InputStream licenseStream) throws INIXSAFEException {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        ArrayList arrayList5 = arrayList4;
        arrayList4 = new ArrayList();
        this.a = arrayList5;
        arrayList5 = arrayList3;
        arrayList3 = new ArrayList();
        this.b = arrayList5;
        arrayList5 = arrayList2;
        arrayList2 = new ArrayList();
        this.c = arrayList5;
        arrayList5 = arrayList;
        arrayList = new ArrayList();
        this.d = arrayList5;
        if (licenseStream != null) {
            void var1_1;
            INISAFEXSAFE.setLicense((InputStream)var1_1);
        }
        CertificateManager certificateManager = this;
        certificateManager.init();
        certificateManager.a();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public CertificateManager(String config) {
        void var1_1;
        this.a = new ArrayList();
        this.b = new ArrayList();
        this.c = new ArrayList();
        this.d = new ArrayList();
        if (!INISAFEXSAFE.hasLicense()) {
            return;
        }
        CertificateManager certificateManager = this;
        certificateManager.a((String)var1_1);
        certificateManager.a();
    }

    @Deprecated
    public static void setBaseCertificatePath(String certpath) {
    }

    public static void setIssuerDnFilter(String issuerDnFilter) {
        f = issuerDnFilter;
    }

    @Deprecated
    public static void reloadCertificates() {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static PrivateKey loadPrivateKey(CertInfo certInfo, String password, boolean isNFilterCipher) throws Exception {
        void var2_3;
        CertInfo certInfo2;
        String string2;
        void v02 = string2;
        int n2 = INISAFEXSAFE.getUseStorageType();
        string2 = certInfo2.priPath;
        char[] cArray = v02.toCharArray();
        return CertStorageManager.loadPrivateKey(ContextManager.getContext(), n2, string2, cArray, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static PrivateKey loadPrivateKey(CertInfo certInfo, String password, int cipherMode) throws Exception {
        void var2_3;
        CertInfo certInfo2;
        String string2;
        void v02 = string2;
        int n2 = INISAFEXSAFE.getUseStorageType();
        string2 = certInfo2.priPath;
        char[] cArray = v02.toCharArray();
        return CertStorageManager.loadPrivateKey(ContextManager.getContext(), n2, string2, cArray, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey loadPrivateKey(CertInfo certInfo, char[] password, int cipherMode) throws Exception {
        void var2_3;
        void var1_2;
        CertInfo certInfo2;
        int n2 = INISAFEXSAFE.getUseStorageType();
        return CertStorageManager.loadPrivateKey(ContextManager.getContext(), n2, certInfo2.priPath, (char[])var1_2, (int)var2_3);
    }

    public static void setLocale(String locale) {
        g = locale.equalsIgnoreCase("en");
    }

    static {
        i = CertificateManager.class.desiredAssertionStatus() ^ true;
        CERT_FILTER = CertUtil.b;
        KEY_FILTER = CertUtil.c;
        ANY_FILE_FILTER = new InnerExtensionFilter(null);
        USER_DIRECTORY_FILTER = new InnerDirectoryFilter(new String[]{"USER"});
        f = "O";
        InitechProvider.changeMode();
    }

    /*
     * Unable to fully structure code
     */
    public void init() {
        block12: {
            block11: {
                if (CertificateManager.h != null) break block12;
                var1_3 = v0;
                v0 = new Properties();
                var2_4 = CertificateManager.g != false ? "OID_en.properties" : "OID.properties";
                var3_6 = this.e;
                if (var3_6 == null) break block11;
                v1 = var3_6.getAssets().open(var2_4);
lbl11:
                // 2 sources

                while (true) {
                    this = v1;
                    ** GOTO lbl18
                    break;
                }
            }
            v1 = this.getClass().getResourceAsStream("/assets/" + var2_4);
            ** continue;
lbl18:
            // 1 sources

            var1_3.load(this);
            if (CertificateManager.i || this != null) ** GOTO lbl22
            throw new AssertionError();
lbl22:
            // 1 sources

            this.close();
            var0_1 = Integer.parseInt(var1_3.getProperty("CertPolicyNum", "0"));
            if (var0_1 <= 0) break block12;
            CertificateManager.h = new String[var0_1];
            var2_5 = 0;
            while (var2_5 < var0_1) {
                v2 = CertificateManager.h;
                v3 = var2_5;
                v4 = var1_3;
                v5 = new StringBuilder().append("CertPolicy.");
                var3_7 = var2_5 + 1;
                try {
                    v2[v3] = v4.getProperty(v5.append(var3_7).toString());
                    IniSafeLog.debug("OID " + CertificateManager.h[var2_5]);
                    var2_5 = var3_7;
                }
                catch (IOException var0_2) {
                    IniSafeLog.error(var0_2.toString(), var0_2);
                    break;
                }
            }
        }
    }

    public boolean isExternalStorageAvailable() {
        return StorageUtil.isExternalStorageAvailable(this.e);
    }

    public void loadUserCert() {
        CertificateManager certificateManager = this;
        CertificateManager certificateManager2 = certificateManager;
        ArrayList<CertInfo>[] arrayListArray = CertStorageManager.loadUserCertList(certificateManager.e, INISAFEXSAFE.getUseStorageType(), h, f, g);
        try {
            this.b = arrayListArray[0];
            this.c = arrayListArray[1];
            certificateManager2.d = arrayListArray[2];
        }
        catch (INIXSAFEException iNIXSAFEException) {
            iNIXSAFEException.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public PrivateKey loadPrivateKey(byte[] priKey, String password, int cipherMode) throws Exception {
        void var3_3;
        void var2_2;
        return CertUtil.b(priKey, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public PrivateKey loadPrivateKey(byte[] priKey, char[] password, int cipherMode) throws Exception {
        void var3_3;
        void var2_2;
        return CertUtil.b(priKey, (char[])var2_2, (int)var3_3);
    }

    public String getCertType(X509Certificate cert) {
        return CertUtil.getCertType(cert, h, g);
    }

    public boolean CertValidateCheck(X509Certificate cert) {
        return CertUtil.CertValidateCheck(cert);
    }

    public boolean getLocale() {
        return g;
    }

    @Deprecated
    public void ClearCACertStorage() {
        this.a.clear();
    }

    @Deprecated
    public String getClassName() {
        return "CertificateManager";
    }

    public ArrayList<CertInfo> getCertList() {
        return this.b;
    }

    public ArrayList<CertInfo> getKMCertList() {
        return this.c;
    }

    public ArrayList<CertInfo> getGPKIEncCertList() {
        return this.d;
    }

    public ArrayList<CertInfo> getAllCertList() {
        ArrayList<CertInfo> arrayList;
        ArrayList<CertInfo> arrayList2 = arrayList;
        arrayList2();
        arrayList2.addAll(this.b);
        arrayList2.addAll(this.c);
        arrayList.addAll(this.d);
        return arrayList;
    }

    public ArrayList<CertInfo> getCaCertList() {
        return this.a;
    }

    public String[] getUserCertLists() {
        ArrayList<String> arrayList;
        IniSafeLog.debug("<-- [getUserCertLists()]");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n2 = this.b.size();
        IniSafeLog.debug("- Size of CertStorage : " + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(this.b.get(i2).toString());
        }
        if (arrayList2.size() <= 0) {
            return null;
        }
        ArrayList<String> arrayList3 = arrayList2;
        IniSafeLog.debug("--> [getUserCertLists()]");
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    public String getUserCertList() {
        CertificateManager certificateManager = this;
        return certificateManager.a(certificateManager.b);
    }

    public String getUserKMCertList() {
        CertificateManager certificateManager = this;
        return certificateManager.a(certificateManager.c);
    }

    public String getUserGPKIEncCertList() {
        CertificateManager certificateManager = this;
        return certificateManager.a(certificateManager.d);
    }

    public String getCACertList() {
        CertificateManager certificateManager = this;
        return certificateManager.a(certificateManager.a);
    }

    public void setChangeMode(boolean flag) {
        INISAFECore.setChangeMode(flag);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getCACertFilter(String filter) {
        void var1_1;
        if ((this = this.getCACertFilter((String)var1_1, null, false, 0)) == null || this.length <= 0) {
            IniSafeLog.error("There is NO certificate matched by filter, CA=[" + (String)var1_1 + "].");
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getCACertFilter(String filter, int expire) {
        void var2_2;
        void var1_1;
        if ((this = this.getCACertFilter((String)var1_1, null, false, (int)var2_2)) == null || this.length <= 0) {
            IniSafeLog.error("There is NO certificate matched by filter, CA=[" + (String)var1_1 + "].");
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getCACertFilter(String caFilter, String oidFilter) {
        void var2_2;
        void var1_1;
        return this.getCACertFilter((String)var1_1, (String)var2_2, false, 0);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getCACertFilter(String caFilter, String oidFilter, int expire) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getCACertFilter((String)var1_1, (String)var2_2, false, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getCACertFilter(String caFilter, String oidFilter, boolean useFullDN) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getCACertFilter((String)var1_1, (String)var2_2, (boolean)var3_3, 0);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getCACertFilter(String caFilter, String oidFilter, boolean useFullDN, int expire) {
        ArrayList<String> arrayList;
        AliasOID aliasOID;
        AliasCA aliasCA;
        void var2_3;
        IniSafeLog.debug("<-- [" + this.getClass().getName() + ".getCACertFilter()]");
        if (caFilter == null && var2_3 == null) {
            return null;
        }
        AliasCA aliasCA2 = aliasCA;
        aliasCA = new AliasCA();
        AliasOID aliasOID2 = aliasOID;
        aliasOID = new AliasOID();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (this.b.size() == 0) {
            this.loadUserCert();
        }
        int n2 = this.b.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_2;
            X509Certificate x509Certificate;
            CertInfo certInfo;
            block7: {
                void var3_4;
                void var4_5;
                int n3;
                CertInfo certInfo2;
                Context context;
                CertificateManager certificateManager = this;
                certInfo = certificateManager.b.get(i2);
                try {
                    context = certificateManager.e;
                    certInfo2 = certInfo;
                    n3 = INISAFEXSAFE.getUseStorageType();
                }
                catch (Exception exception) {
                    IniSafeLog.error("Error occurred during loading certificate.", exception);
                    return null;
                }
                x509Certificate = CertStorageManager.loadCertificate(context, n3, certInfo2.certPath);
                if (var4_5 == true && !this.CertValidateCheck(x509Certificate)) continue;
                if (var3_4 == false) break block7;
                if (!aliasCA2.isMatchedFullCertByFilter(x509Certificate, (String)var1_2) || !aliasOID2.isMatchedCertByFilter(x509Certificate, (String)var2_3)) continue;
                IniSafeLog.debug("- Add : " + certInfo);
                arrayList2.add(certInfo.toString());
                continue;
            }
            if (!aliasCA2.isMatchedCertByFilter(x509Certificate, (String)var1_2) || !aliasOID2.isMatchedCertByFilter(x509Certificate, (String)var2_3)) continue;
            IniSafeLog.debug("- Add : " + certInfo);
            arrayList2.add(certInfo.toString());
        }
        if (arrayList2.size() <= 0) {
            return null;
        }
        ArrayList<String> arrayList3 = arrayList2;
        IniSafeLog.debug("--> [getCACertFilter method]");
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getOIDCertFilter(String filter) {
        void var1_1;
        IniSafeLog.debug("<-- [" + this_.getClass().getName() + ".getOIDCertFilter()]");
        String[] this_ = this_.getCACertFilter(null, (String)var1_1);
        if (this_ == null || this_.length <= 0) {
            IniSafeLog.error("There is NO certificate matched by filter, OID=[" + (String)var1_1 + "].");
        }
        IniSafeLog.debug("--> [getOIDCertFilter method]");
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public String getUserCertFilter(String filter) {
        void var1_1;
        return this.getUserCertFilter((String)var1_1, false);
    }

    public String getUserCertFilter(String filter, boolean toHex) {
        int n2;
        ArrayList<String> arrayList;
        StringBuilder stringBuilder;
        CertificateManager certificateManager = this_;
        StringBuilder this_ = stringBuilder;
        stringBuilder = new StringBuilder();
        if ((arrayList = certificateManager.a((String)((Object)arrayList), n2 != 0)) == null) {
            return "";
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            this_.append(arrayList.get(n2)).append("|");
        }
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String[] getUserCertListFilter(String filter) {
        void var1_1;
        return this.getUserCertListFilter((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getUserCertListFilter(String filter, boolean toHex) {
        void var2_2;
        void var1_1;
        if ((this = ((CertificateManager)this).a((String)var1_1, (boolean)var2_2)) != null && ((ArrayList)this).size() != 0) {
            Object object = this;
            return ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        }
        return null;
    }

    public ArrayList<CertInfo> getCertListFilter(ArrayList<CertInfo> certInfoList, String filter) {
        ArrayList<CertInfo> arrayList;
        String[][] stringArray = Converter.toKeyValueList(filter);
        if (stringArray == null) {
            return null;
        }
        block20: for (String[] stringArray2 : stringArray) {
            Object object = stringArray2;
            object = object[1];
            String string2 = stringArray2[0].toUpperCase();
            string2.hashCode();
            int n2 = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1763999732: {
                    if (!string2.equals("SERIAL_NUMBER")) break;
                    n2 = 7;
                    break;
                }
                case 1114090544: {
                    if (!string2.equals("SERIAL_NUMBER_HEX")) break;
                    n2 = 6;
                    break;
                }
                case 323996507: {
                    if (!string2.equals("OID_ALIAS")) break;
                    n2 = 5;
                    break;
                }
                case 78250: {
                    if (!string2.equals("OID")) break;
                    n2 = 4;
                    break;
                }
                case -88514403: {
                    if (!string2.equals("SUBJECT_DN")) break;
                    n2 = 3;
                    break;
                }
                case -591252731: {
                    if (!string2.equals("EXPIRED")) break;
                    n2 = 2;
                    break;
                }
                case -1322688560: {
                    if (!string2.equals("ISSUER_DN")) break;
                    n2 = 1;
                    break;
                }
                case -1322688591: {
                    if (!string2.equals("ISSUER_CN")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    continue block20;
                }
                case 7: {
                    arrayList = this.getCertListSerialNumberFilter(arrayList, (String)object);
                    continue block20;
                }
                case 6: {
                    arrayList = this.getCertListSerialNumberHexFilter(arrayList, (String)object);
                    continue block20;
                }
                case 5: {
                    arrayList = this.getCertListOidAliasFilter(arrayList, (String)object);
                    continue block20;
                }
                case 4: {
                    arrayList = this.getCertListOidFilter(arrayList, (String)object);
                    continue block20;
                }
                case 3: {
                    arrayList = this.getCertListSubjectDnFilter(arrayList, (String)object);
                    continue block20;
                }
                case 2: {
                    arrayList = this.getCertListExpiredFilter(arrayList);
                    continue block20;
                }
                case 1: {
                    arrayList = this.getCertListIssuerDnFilter(arrayList, (String)object);
                    continue block20;
                }
                case 0: {
                    arrayList = this.getCertListIssuerCnFilter(arrayList, (String)object);
                }
            }
        }
        return arrayList;
    }

    public ArrayList<CertInfo> getCertListExpiredFilter(ArrayList<CertInfo> certInfoList) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            if (certInfo.expired) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CertInfo> getCertListIssuerCnFilter(ArrayList<CertInfo> certInfoList, String issuerCnFilter) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            void var2_2;
            if (!CertUtil.a(CertUtil.getIssuerCn(certInfo.issuerDn), (String)var2_2)) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CertInfo> getCertListIssuerDnFilter(ArrayList<CertInfo> certInfoList, String issuerDnFilter) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            void var2_2;
            if (!CertUtil.a(certInfo.issuerDn, (String)var2_2)) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CertInfo> getCertListOidFilter(ArrayList<CertInfo> certInfoList, String oidFilter) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            void var2_2;
            if (!CertUtil.a(certInfo.oid, (String)var2_2)) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CertInfo> getCertListOidAliasFilter(ArrayList<CertInfo> certInfoList, String oidAliasFilter) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            void var2_2;
            if (!CertUtil.a(new AliasOID().getAlias(certInfo.oid), (String)var2_2)) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CertInfo> getCertListSerialNumberFilter(ArrayList<CertInfo> certInfoList, String serialNumberFilter) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            void var2_2;
            if (!CertUtil.a(certInfo.serialNumber, (String)var2_2)) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CertInfo> getCertListSerialNumberHexFilter(ArrayList<CertInfo> certInfoList, String serialNumberHexFilter) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            void var2_2;
            if (!CertUtil.a(certInfo.serialNumberHex, (String)var2_2)) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<CertInfo> getCertListSubjectDnFilter(ArrayList<CertInfo> certInfoList, String subjectDnFilter) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (CertInfo certInfo : certInfoList) {
            void var2_2;
            if (!CertUtil.a(certInfo.subjectDn, (String)var2_2)) continue;
            arrayList2.add(certInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public String getUserCertificatePath(int idx) {
        void var1_1;
        return this.b((int)var1_1, this.b);
    }

    /*
     * WARNING - void declaration
     */
    public String getUserKMCertificatePath(int idx) {
        void var1_1;
        return this.b((int)var1_1, this.c);
    }

    /*
     * WARNING - void declaration
     */
    public String getUserGPKIEncCertificatePath(int idx) {
        void var1_1;
        return this.b((int)var1_1, this.d);
    }

    /*
     * WARNING - void declaration
     */
    public String getUserPrivateKeyPath(int idx) {
        void var1_1;
        return this.c((int)var1_1, this.b);
    }

    /*
     * WARNING - void declaration
     */
    public String getUserKMPrivateKeyPath(int idx) {
        void var1_1;
        return this.c((int)var1_1, this.c);
    }

    /*
     * WARNING - void declaration
     */
    public String getUserGPKIEncPrivateKeyPath(int idx) {
        void var1_1;
        return this.c((int)var1_1, this.d);
    }

    /*
     * WARNING - void declaration
     */
    public CertInfo getUserCertInfo(int index) {
        void var1_1;
        return this.a((int)var1_1, this.b);
    }

    /*
     * WARNING - void declaration
     */
    public CertInfo getCertInfo(int index) {
        void var1_1;
        return this.a((int)var1_1, this.b);
    }

    /*
     * WARNING - void declaration
     */
    public X509Certificate viewCertificateInfo(int idx) {
        void var1_1;
        CertificateManager certificateManager = this_;
        Object this_ = null;
        String string2 = certificateManager.getUserCertificatePath((int)var1_1);
        try {
            this_ = CertStorageManager.loadCertificate(certificateManager.e, INISAFEXSAFE.getUseStorageType(), string2);
        }
        catch (Exception exception) {
            IniSafeLog.error(exception.toString(), exception);
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getSeletedUserKey(int idx) {
        void var1_1;
        String[] stringArray = new String[2];
        CertificateManager certificateManager = string2;
        String string2 = certificateManager.getUserCertificatePath((int)var1_1);
        String string3 = certificateManager.getUserPrivateKeyPath((int)var1_1);
        stringArray[0] = string2;
        stringArray[1] = string3;
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getCertificate(int idx, boolean isPem) throws INIXSAFEException {
        block4: {
            byte[][] byArray;
            void var1_3;
            CertificateManager certificateManager = this_;
            IniSafeLog.debug("<-- [getCertificate()]");
            IniSafeLog.debug("- idx : " + (int)var1_3);
            Object this_ = null;
            try {
                byArray = certificateManager.getCertificateData((int)var1_3);
            }
            catch (Exception exception) {
                IniSafeLog.error(exception.toString(), exception);
                throw new INIXSAFEException("Failed to get certificate.", "2002");
            }
            catch (NullPointerException nullPointerException) {
                IniSafeLog.error(nullPointerException.toString());
                throw new INIXSAFEException(nullPointerException.toString(), "2006");
            }
            {
                void var2_5;
                if (byArray[0] == null) break block4;
                this_ = var2_5 != false ? Converter.derCertToPemCert(byArray[0]) : byArray[0];
            }
        }
        IniSafeLog.debug("--> [getCertificate method]");
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public byte[][] getCertificateData(int idx) throws INIXSAFEException {
        void var1_1;
        return this.getCertificateData((int)var1_1, this.b);
    }

    /*
     * WARNING - void declaration
     */
    public byte[][] getKmCertificateData(int idx) throws INIXSAFEException {
        void var1_1;
        return this.getCertificateData((int)var1_1, this.c);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[][] getCertificateData(int idx, ArrayList<CertInfo> certList) throws INIXSAFEException {
        byte[][] byArrayArray;
        block5: {
            byte[][] byArrayArray2;
            String string3;
            String string2;
            void var2_5;
            void var1_3;
            IniSafeLog.debug("<-- [getCertificateData()]");
            IniSafeLog.debug("- idx : " + (int)var1_3);
            byArrayArray = null;
            try {
                string2 = this.b((int)var1_3, (ArrayList<CertInfo>)var2_5);
            }
            catch (Exception exception) {
                IniSafeLog.error(exception.toString(), exception);
                byArrayArray = null;
                break block5;
            }
            catch (NullPointerException nullPointerException) {
                IniSafeLog.error(nullPointerException.toString());
                throw new INIXSAFEException(nullPointerException.toString(), "2006");
            }
            {
                string3 = this.c((int)var1_3, (ArrayList<CertInfo>)var2_5);
                if (string2 == null || string3 == null) break block5;
                byArrayArray2 = new byte[2][];
            }
            byArrayArray = byArrayArray2;
            {
                byArrayArray2[0] = CertStorageManager.loadCertificateBytes(this.e, INISAFEXSAFE.getUseStorageType(), string2);
                byArrayArray2[1] = CertStorageManager.loadPrivateKeyBytes(this.e, INISAFEXSAFE.getUseStorageType(), string3);
            }
        }
        IniSafeLog.debug("--> [getCertificateData method]");
        return byArrayArray;
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteUserCert(int idx) throws INIXSAFEException {
        void var1_1;
        if ((this = ((CertificateManager)this).getCertInfo((int)var1_1)) == null) {
            return false;
        }
        return CertUtil.deleteUserCert(((CertInfo)this).path);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean changePassword(int idx, String oldPassword, String newPassword) {
        void v2;
        void v1;
        CertificateManager certificateManager;
        try {
            void var2_2;
            void var3_3;
            void var1_1;
            certificateManager = this_;
            v1 = var1_1;
            v2 = var3_3;
            Object this_ = var2_2.toCharArray();
        }
        catch (INIXSAFEException iNIXSAFEException) {
            return false;
        }
        return certificateManager.changePassword((int)v1, (char[])this_, v2.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean changePasswordEX(int idx, String oldPassword, String newPassword) throws Exception {
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.changePassword((int)var1_1, (char[])this_, var3_3.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean changePasswordEX(int idx, char[] oldPassword, char[] newPassword) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.changePassword((int)var1_1, (char[])var2_2, (char[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean changePassword(int idx, char[] oldPassword, char[] newPassword, boolean isNFilterCipher) throws Exception {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.changePassword((int)var1_1, (char[])var2_2, (char[])var3_3, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean changePassword(int idx, String oldPassword, String newPassword, boolean isNFilterCipher) throws Exception {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.changePassword((int)var1_1, (char[])this_, var3_3.toCharArray(), (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean changePassword(int idx, String oldPassword, String newPassword, int cipherMode) throws Exception {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.changePassword((int)var1_1, (char[])this_, var3_3.toCharArray(), (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public boolean changePassword(int idx, char[] oldPassword, char[] newPassword, int cipherMode) throws Exception {
        boolean bl;
        char[] cArray;
        block7: {
            void var3_5;
            void var1_3;
            void var4_6;
            char[] cArray2 = null;
            cArray = null;
            try {
                cArray2 = KeyPadCipher.getDecryptedString(oldPassword, (int)var4_6);
            }
            catch (Throwable throwable) {
                if (cArray2 != null) {
                    Arrays.fill(cArray2, '\u0000');
                }
                if (cArray != null) {
                    Arrays.fill(cArray, '\u0000');
                }
                throw throwable;
            }
            CertificateManager certificateManager = this;
            void v1 = var1_3;
            char[] cArray3 = cArray2;
            cArray = KeyPadCipher.getDecryptedString((char[])var3_5, (int)var4_6);
            bl = certificateManager.changePassword((int)v1, cArray3, cArray);
            if (cArray2 == null) break block7;
            Arrays.fill(cArray2, '\u0000');
        }
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean changePassword(int idx, char[] oldPassword, char[] newPassword) throws INIXSAFEException {
        int n2;
        ArrayList<CertInfo> this_ = ((CertificateManager)((Object)this_)).a(n2);
        int n3 = this_.size();
        IniSafeLog.debug(n3 + " CertInfos are matched by Index " + n2);
        for (n2 = 0; n2 < n3; ++n2) {
            void var3_4;
            void var2_3;
            String string2 = ((CertInfo)this_.get((int)n2)).priPath;
            if (CertUtil.changePassword(string2, (char[])var2_3, (char[])var3_4)) continue;
            IniSafeLog.debug("Failed to change password of " + n2 + "-PriKey.(" + string2 + ")");
            for (int i2 = 0; i2 < n2; ++i2) {
                CertUtil.changePassword(string2, (char[])var3_4, (char[])var2_3);
            }
            if (!string2.toLowerCase().contains("signpri")) {
                if (!string2.toLowerCase().contains("kmpri")) {
                    if (string2.toLowerCase().contains("_env")) {
                        throw new INIXSAFEException("\uac1c\uc778\ud0a4 \ube44\ubc00\ubc88\ud638 \ubcc0\uacbd \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.(GPKIEncCert)", "4009");
                    }
                    throw new INIXSAFEException("\uac1c\uc778\ud0a4 \ube44\ubc00\ubc88\ud638 \ubcc0\uacbd \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", "6304");
                }
                throw new INIXSAFEException("\uac1c\uc778\ud0a4 \ube44\ubc00\ubc88\ud638 \ubcc0\uacbd \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.(KMCert)", "4008");
            }
            throw new INIXSAFEException("\uac1c\uc778\ud0a4 \ube44\ubc00\ubc88\ud638 \ubcc0\uacbd \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.(SignCert)", "4007");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public byte[] changePassword(byte[] priKey, String oldPassword, String newPassword, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.changePassword((byte[])var1_1, (char[])this_, var3_3.toCharArray(), (int)var4_4);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] changePassword(byte[] priKey, char[] oldPassword, char[] newPassword, int cipherMode) throws INIXSAFEException {
        Throwable throwable2222222;
        char[] cArray;
        block10: {
            byte[] byArray;
            void var4_6;
            Object object = null;
            cArray = null;
            char[] cArray2 = KeyPadCipher.getDecryptedString(oldPassword, (int)var4_6);
            {
                catch (Throwable throwable2222222) {
                    break block10;
                }
                catch (INICoreException iNICoreException) {}
                {
                    throw new INIXSAFEException(iNICoreException);
                }
            }
            object = cArray2;
            {
                void var3_5;
                cArray = KeyPadCipher.getDecryptedString((char[])var3_5, (int)var4_6);
                {
                    byArray = INIHandlerKeyPair.doPrivateKeyChangePassword(byArray, (char[])object, cArray);
                }
            }
            if (cArray2 != null) {
                Arrays.fill((char[])object, '\u0000');
            }
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            return byArray;
        }
        if (object != null) {
            Arrays.fill((char[])object, '\u0000');
        }
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
        throw throwable2222222;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkPassword(int idx, String password) throws Exception {
        void var2_2;
        void var1_1;
        return this.checkPassword((int)var1_1, var2_2.toCharArray(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkPassword(int idx, char[] password) throws Exception {
        void var2_2;
        void var1_1;
        return this.checkPassword((int)var1_1, (char[])var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkPassword(int idx, String password, boolean isNFilterCipher) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkPassword((int)var1_1, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkPassword(int idx, char[] password, boolean isNFilterCipher) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkPassword((int)var1_1, (char[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkPassword(int idx, String password, int cipherMode) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkPassword((int)var1_1, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkPassword(int idx, char[] password, int cipherMode) throws Exception {
        int n2;
        boolean bl = true;
        ArrayList<CertInfo> arrayList = this.a(n2);
        int n3 = arrayList.size();
        try {
            IniSafeLog.debug(n3 + " CertInfos are matched by Index " + n2);
        }
        catch (INIXSAFEException iNIXSAFEException) {
            IniSafeLog.error(iNIXSAFEException.toString());
            throw iNIXSAFEException;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            CertificateManager certificateManager = this;
            CertInfo certInfo = arrayList.get(n2);
            try {
                void var3_3;
                void var2_2;
                if (CertUtil.checkPassword(certificateManager.e, certInfo.priPath, (char[])var2_2, (int)var3_3)) {
                    continue;
                }
            }
            catch (Exception exception) {}
            bl = false;
            break;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkSignCertPassword(int idx, String password) throws Exception {
        void var2_2;
        void var1_1;
        return this.checkPassword((int)var1_1, var2_2.toCharArray(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkSignCertPassword(int idx, char[] password) throws Exception {
        void var2_2;
        void var1_1;
        return this.checkPassword((int)var1_1, (char[])var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkSignCertPassword(int idx, String password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkSignCertPassword((int)var1_1, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkSignCertPassword(int idx, char[] password, int cipherMode) throws INIXSAFEException {
        void var1_3;
        block6: {
            void var3_5;
            void var2_4;
            CertInfo certInfo;
            String string2 = "";
            try {
                certInfo = this.getCertInfo((int)var1_3);
                if (certInfo == null) break block6;
            }
            catch (Exception exception) {
                IniSafeLog.error("\uac1c\uc778\ud0a4 \ud30c\uc77c \uc624\ub958: " + string2, exception);
                throw new INIXSAFEException("\uac1c\uc778\ud0a4 \ud30c\uc77c \uc624\ub958: + " + string2, exception, "2006");
            }
            CertificateManager certificateManager = this;
            CertificateManager certificateManager2 = certificateManager;
            CertificateManager certificateManager3 = certificateManager;
            string2 = certInfo.priPath;
            Context context = certificateManager2.e;
            CertInfo certInfo2 = certInfo;
            int n2 = INISAFEXSAFE.getUseStorageType();
            return certificateManager3.checkSignCertPassword(CertStorageManager.loadPrivateKeyBytes(context, n2, certInfo2.priPath), (char[])var2_4, (int)var3_5);
        }
        throw new INIXSAFEException("\uc778\ub371\uc2a4(" + (int)var1_3 + ")\uc5d0 \ud574\ub2f9\ud558\ub294 \uc778\uc99d\uc11c \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", "6303");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkSignCertPassword(int idx, String password, boolean isNFilterCipher) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkSignCertPassword((int)var1_1, var2_2.toCharArray(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkSignCertPassword(int idx, char[] password, boolean isNFilterCipher) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkSignCertPassword((int)var1_1, (char[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkSignCertPassword(byte[] priKey, String password) {
        void var2_2;
        return CertUtil.checkPassword(priKey, var2_2.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkSignCertPassword(byte[] priKey, char[] password) {
        void var2_2;
        return CertUtil.checkPassword(priKey, (char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkSignCertPassword(byte[] priKey, String password, boolean isNFilterCipher) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkSignCertPassword((byte[])var1_1, var2_2.toCharArray(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkSignCertPassword(byte[] priKey, char[] password, boolean isNFilterCipher) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkSignCertPassword((byte[])var1_1, (char[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean checkSignCertPassword(byte[] priKey, String password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkSignCertPassword((byte[])var1_1, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkSignCertPassword(byte[] priKey, char[] password, int cipherMode) throws INIXSAFEException {
        char[] cArray = null;
        try {
            void var1_3;
            void var3_5;
            cArray = KeyPadCipher.getDecryptedString(password, (int)var3_5);
            boolean bl = this.checkSignCertPassword((byte[])var1_3, cArray);
            return bl;
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean CheckVID(int idx, String password, String ssn) throws INIXSAFEException {
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.checkVID((int)var1_1, (char[])this_, var3_3.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean CheckVID(int idx, String password, String ssn, boolean isNFilterCipher) throws Exception {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.checkVID((int)var1_1, (char[])this_, var3_3.toCharArray(), (boolean)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean CheckVID(int idx, String password, String ssn1, String encSsn2) throws INIXSAFEException {
        void var1_1;
        if ((this_ = ((CertificateManager)this_).getCertInfo((int)var1_1)) != null) {
            void var4_5;
            char[] cArray;
            char[] cArray2;
            void v02 = cArray2;
            Object this_ = ((CertInfo)this_).priPath;
            char[] cArray3 = cArray.toCharArray();
            cArray2 = var4_5.toCharArray();
            cArray = v02.toCharArray();
            return CertUtil.a(((CertInfo)this_).certPath, (String)this_, cArray3, cArray2, cArray, 1);
        }
        throw new INIXSAFEException("\uc778\ub371\uc2a4(" + (int)var1_1 + ")\uc5d0 \ud574\ub2f9\ud558\ub294 \uc778\uc99d\uc11c \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", "6303");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean CheckVID(String certPath, String priPath, String password, String ssn1, String encSsn2) throws INIXSAFEException {
        void var3_3;
        void var5_5;
        void var4_4;
        char[] cArray;
        void v02 = cArray;
        Object object = var4_4.toCharArray();
        char[] cArray2 = var5_5.toCharArray();
        cArray = var3_3.toCharArray();
        return CertUtil.a(certPath, (String)v02, (char[])object, cArray2, cArray, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean CheckVIDEx(int idx, String password, String ssn, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.checkVID((int)var1_1, (char[])this_, var3_3.toCharArray(), (int)var4_4, false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean CheckVIDEx(int idx, String password, String ssn, int cipherMode, boolean isEncSsn) throws INIXSAFEException {
        void var5_5;
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.checkVID((int)var1_1, (char[])this_, var3_3.toCharArray(), (int)var4_4, (boolean)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkVID(int idx, char[] password, char[] ssn) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkVID((int)var1_1, (char[])var2_2, (char[])var3_3, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkVID(int idx, char[] password, char[] ssn, boolean isNFilterCipher) throws Exception {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkVID((int)var1_1, (char[])var2_2, (char[])var3_3, (int)var4_4, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkVID(int idx, char[] password, char[] ssn, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkVID((int)var1_1, (char[])var2_2, (char[])var3_3, (int)var4_4, false);
    }

    /*
     * Exception decompiling
     */
    public boolean checkVID(int idx, char[] password, char[] ssn, int cipherMode, boolean isEncSsn) throws INIXSAFEException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [9 : 86->95)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getVIDRandom(int idx, char[] password) throws INIXSAFEException {
        void var1_1;
        CertInfo certInfo = this.getCertInfo((int)var1_1);
        if (certInfo != null) {
            void var2_2;
            return this.getVIDRandom(certInfo.priPath, (char[])var2_2);
        }
        throw new INIXSAFEException("\uc778\ub371\uc2a4(" + (int)var1_1 + ")\uc5d0 \ud574\ub2f9\ud558\ub294 \uc778\uc99d\uc11c \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", "6303");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public byte[] getVIDRandom(int idx, String password) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        return this.getVIDRandom((int)var1_1, var2_2.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public byte[] getVIDRandom(String priPath, String password) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        return this.getVIDRandom((String)var1_1, var2_2.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getVIDRandom(String priPath, char[] password) throws INIXSAFEException {
        try {
            void var2_2;
            void var1_1;
            return INIHandlerKeyPair.getVIDRandom(CertStorageManager.loadPrivateKeyBytes(this.e, INISAFEXSAFE.getUseStorageType(), (String)var1_1), (char[])var2_2);
        }
        catch (INICoreException iNICoreException) {
            IniSafeLog.error("Error occurred during reading Random value from private key.");
            throw new INIXSAFEException("\uac1c\uc778\ud0a4\uc5d0\uc11c Random \uac12 \uc77d\uc5b4\uc624\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", "1004");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public byte[] getVIDRandom(int idx, String password, boolean isBase64, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getVIDRandom((int)var1_1, var2_2.toCharArray(), (boolean)var3_3, (int)var4_4);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getVIDRandom(int idx, char[] password, boolean isBase64, int cipherMode) throws INIXSAFEException {
        Throwable throwable2222222;
        char[] cArray;
        block6: {
            block7: {
                void var4_6;
                cArray = null;
                cArray = KeyPadCipher.getDecryptedString(password, (int)var4_6);
                {
                    catch (Throwable throwable2222222) {
                        break block6;
                    }
                    catch (Exception exception) {}
                    {
                        IniSafeLog.error(exception.toString(), exception);
                        throw new INIXSAFEException("\uac1c\uc778\ud0a4\uc5d0\uc11c Random \uac12 \uc77d\uc5b4\uc624\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", "1004");
                    }
                }
                {
                    void var3_5;
                    void var1_3;
                    CertificateManager certificateManager = object;
                    Object object = certificateManager.getUserPrivateKeyPath((int)var1_3);
                    object = INIHandlerKeyPair.getVIDRandom(CertStorageManager.loadPrivateKeyBytes(certificateManager.e, INISAFEXSAFE.getUseStorageType(), (String)object), cArray, (boolean)var3_5);
                    if (cArray == null) break block7;
                }
                Arrays.fill(cArray, '\u0000');
            }
            return object;
        }
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
        throw throwable2222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] addVIDRandom(String priPath, char[] password, int cipherMode, String attrOid, byte[] pkcs7Data, boolean b64) throws INIXSAFEException {
        block19: {
            var2_5 = null;
            var3_7 = v0;
            try {
                v0 = new ByteArrayInputStream(Base64Util.decode((byte[])var5_9));
            }
            catch (Exception var0_3) {
                IniSafeLog.error(var0_3.toString(), var0_3);
                throw new INIXSAFEException("unauthenticatedAttributes \uc601\uc5ed\uc5d0 Random\uac12 \ucd94\uac00 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", "1005");
            }
            var5_9 = v1;
            {
                v1 = new BERDecoder((InputStream)var3_7);
            }
            {
                v2 = new ContentInfo();
                v2.decode((ASN1Decoder)var5_9);
                var3_7 = (SignedData)v2.getContent();
            }
            var2_5 = KeyPadCipher.getDecryptedString(password, (int)var3_6);
            {
                catch (Throwable var0_1) {
                    break block19;
                }
                catch (Exception var0_2) {}
                {
                    IniSafeLog.error(var0_2.toString(), var0_2);
                    throw new INIXSAFEException("\uac1c\uc778\ud0a4\uc5d0\uc11c Random \uac12 \uc77d\uc5b4\uc624\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", "1005");
                }
            }
            {
                this = INIHandlerKeyPair.getVIDRandom(CertStorageManager.loadPrivateKeyBytes(this.e, INISAFEXSAFE.getUseStorageType(), (String)var1_4), (char[])var2_5, false);
                if (var2_5 == null) ** GOTO lbl25
            }
            {
                Arrays.fill((char[])var2_5, '\u0000');
lbl25:
                // 2 sources

                var1_4 = var3_7.getSignerInfos();
            }
            {
                if (var1_4.hasMoreElements() == false) throw new INIXSAFEException("signerInfo \ud68d\ub4dd \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", "1005");
                v3 = var6_10;
                v4 = (SignerInfo)var1_4.nextElement();
            }
            var1_4 = v5;
            {
                var1_4();
                v5.setByteArray((byte[])this);
            }
            this = v6;
            {
                this();
                v6.encodeBitString((ASN1BitString)var1_4);
            }
            var1_4 = v7;
            {
                var1_4();
                var1_4.setAttrName((String)var4_8);
                v7.add(this.toByteArray());
                v4.addUnauthenticatedAttribute(v7);
            }
            this = v8;
            {
                v8 = new ByteArrayOutputStream();
            }
            var1_4 = v9;
            {
                v9 = new BEREncoder((OutputStream)this);
            }
            var2_5 = v10;
            {
                var2_5();
                var2_5.setContent((PKCS7Type)var3_7);
                v10.encode((ASN1Encoder)var1_4);
                return v3 == false ? this.toByteArray() : Base64Util.encode(this.toByteArray());
            }
        }
        if (var2_5 == null) throw var0_1;
        {
            Arrays.fill((char[])var2_5, '\u0000');
            throw var0_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] addVIDRandom(int idx, char[] password, int cipherMode, String attrOid, byte[] pkcs7Data, boolean b64) throws INIXSAFEException {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CertificateManager certificateManager = this;
        return certificateManager.addVIDRandom(certificateManager.getUserPrivateKeyPath((int)var1_1), (char[])var2_2, (int)var3_3, (String)var4_4, (byte[])var5_5, (boolean)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getKISA_VID(int idx, boolean isBase64) throws INIXSAFEException {
        Object object;
        CertificateManager certificateManager;
        boolean bl;
        try {
            void var1_2;
            bl = isBase64;
            CertificateManager certificateManager2 = object;
            certificateManager = certificateManager2;
            object = certificateManager2.getUserCertificatePath((int)var1_2);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception.getMessage());
        }
        object = CertStorageManager.loadCertificate(certificateManager.e, INISAFEXSAFE.getUseStorageType(), (String)object);
        object = new X509CertImpl(((Certificate)object).getEncoded()).getVid();
        if (bl) {
            object = Base64Util.encode((byte[])object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void saveCertificate(byte[] certData, byte[] priData, String oldPass, String newPass, int cipherMode) throws INIXSAFEException {
        void var5_5;
        void var2_2;
        void var1_1;
        void var4_4;
        char[] cArray;
        CertificateManager certificateManager = this_;
        Object this_ = cArray.toCharArray();
        cArray = var4_4.toCharArray();
        certificateManager.saveCertificate((byte[])var1_1, (byte[])var2_2, (char[])this_, cArray, (int)var5_5);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCertificate(byte[] certData, byte[] priData, char[] oldPass, char[] newPass, int cipherMode) throws INIXSAFEException {
        Throwable throwable2222222;
        char[] cArray;
        char[] cArray2;
        block10: {
            void var5_7;
            cArray2 = null;
            cArray = null;
            cArray2 = KeyPadCipher.getDecryptedString(oldPass, (int)var5_7);
            {
                catch (Throwable throwable2222222) {
                    break block10;
                }
                catch (Exception exception) {}
                {
                    throw new INIXSAFEException(exception);
                }
            }
            {
                void var4_6;
                CertificateManager certificateManager = object;
                cArray = KeyPadCipher.getDecryptedString((char[])var4_6, (int)var5_7);
                {
                    void var1_3;
                    void var2_4;
                    Object object = INIHandlerKeyPair.doPrivateKeyChangePassword((byte[])var2_4, cArray2, cArray);
                    certificateManager.a(x509CertificateInfo.loadCertificate((byte[])var1_3), (byte[])object, 0, false);
                }
            }
            if (cArray2 != null) {
                Arrays.fill(cArray2, '\u0000');
            }
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            return;
        }
        if (cArray2 != null) {
            Arrays.fill(cArray2, '\u0000');
        }
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
        throw throwable2222222;
    }

    /*
     * WARNING - void declaration
     */
    public void saveCertificate(X509Certificate cert, byte[] priKey) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        CertStorageManager.saveCertificateAndPrivateKey(this.e, INISAFEXSAFE.getUseStorageType(), (X509Certificate)var1_1, (byte[])var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean saveCertificate(X509Certificate cert, byte[] priKey, boolean checkExists) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        void var1_1;
        return CertStorageManager.saveCertificateAndPrivateKey(this.e, INISAFEXSAFE.getUseStorageType(), (X509Certificate)var1_1, (byte[])var2_2, (boolean)var3_3, false) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void saveCertificate(X509Certificate cert, byte[] priKey, char[] password) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        CertStorageManager.saveCertificateAndPrivateKey(this.e, INISAFEXSAFE.getUseStorageType(), (X509Certificate)var1_1, (byte[])var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public String[] saveCertificateExt(X509Certificate cert, byte[] priKey, int option) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        CertificateManager certificateManager = certificateManager.e;
        int n2 = INISAFEXSAFE.getUseStorageType();
        boolean bl = false;
        boolean bl2 = option == 1;
        return CertStorageManager.saveCertificateAndPrivateKey((Context)certificateManager, n2, (X509Certificate)var1_1, (byte[])var2_2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean importCertificate(String authStr, String encInfo) {
        try {
            void var2_3;
            void var1_2;
            return CertUtil.a(null, var1_2.toCharArray(), (String)var2_3, null, 0) != null;
        }
        catch (INIXSAFEException iNIXSAFEException) {
            IniSafeLog.error(iNIXSAFEException.toString(), iNIXSAFEException);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificate(char[] authStr, String encInfo) {
        try {
            void var2_2;
            void var1_1;
            return CertUtil.a(null, (char[])var1_1, (String)var2_2, null, 0) != null;
        }
        catch (INIXSAFEException iNIXSAFEException) {
            INIXSAFEException iNIXSAFEException2 = iNIXSAFEException;
            IniSafeLog.error(iNIXSAFEException.toString(), iNIXSAFEException2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean importCertificate(String ssnStr, String authStr, String encInfo) {
        try {
            void var3_4;
            void var2_3;
            return CertUtil.a(ssnStr.toCharArray(), var2_3.toCharArray(), (String)var3_4, null, 0) != null;
        }
        catch (INIXSAFEException iNIXSAFEException) {
            IniSafeLog.error(iNIXSAFEException.toString(), iNIXSAFEException);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificate(char[] ssnStr, char[] authStr, String encInfo) {
        try {
            void var3_3;
            void var2_2;
            return CertUtil.a(ssnStr, (char[])var2_2, (String)var3_3, null, 0) != null;
        }
        catch (INIXSAFEException iNIXSAFEException) {
            INIXSAFEException iNIXSAFEException2 = iNIXSAFEException;
            IniSafeLog.error(iNIXSAFEException.toString(), iNIXSAFEException2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean importCertificateEX(String authStr, String encInfo) throws INIXSAFEException {
        void var2_2;
        return CertUtil.a(null, authStr.toCharArray(), (String)var2_2, null, 0) != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificateEX(char[] authStr, String encInfo) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        return CertUtil.a(null, (char[])var1_1, (String)var2_2, null, 0) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean importCertificateEX(String ssnStr, String authStr, String encInfo) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.a(ssnStr.toCharArray(), var2_2.toCharArray(), (String)var3_3, null, 0) != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificateEX(char[] ssnStr, char[] authStr, String encInfo) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.a(ssnStr, (char[])var2_2, (String)var3_3, null, 0) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String[] importCertificateReturnPath(String authStr, String encInfo) throws INIXSAFEException {
        void var2_2;
        return CertUtil.a(null, authStr.toCharArray(), (String)var2_2, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    public String[] importCertificateReturnPath(char[] authStr, String encInfo) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        return CertUtil.a(null, (char[])var1_1, (String)var2_2, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String[] importCertificateReturnPath(String authStr, String encInfo, String password, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var2_2;
        void var3_3;
        char[] cArray;
        CertificateManager certificateManager = this_;
        Object this_ = cArray.toCharArray();
        cArray = var3_3.toCharArray();
        return certificateManager.importCertificateReturnPath((char[])this_, (String)var2_2, cArray, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public String[] importCertificateReturnPath(char[] authStr, String encInfo, char[] password, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return CertUtil.a(null, (char[])var1_1, (String)var2_2, (char[])var3_3, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v10(int idx, String ssn, String authCode) throws Exception {
        void var3_4;
        char[] cArray;
        void var1_1;
        String string2 = ((CertificateManager)((Object)this_)).getUserCertificatePath((int)var1_1);
        String this_ = ((CertificateManager)((Object)this_)).getUserPrivateKeyPath((int)var1_1);
        char[] cArray2 = cArray.toCharArray();
        cArray = var3_4.toCharArray();
        return CertUtil.a(string2, this_, cArray2, cArray, null, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v10(int idx, String ssn, String authCode, String oldPassword, String newPassword) throws Exception {
        void var5_6;
        char[] cArray;
        char[] cArray2;
        char[] cArray3;
        void var1_1;
        String string2 = ((CertificateManager)((Object)this_)).getUserCertificatePath((int)var1_1);
        String this_ = ((CertificateManager)((Object)this_)).getUserPrivateKeyPath((int)var1_1);
        char[] cArray4 = cArray3.toCharArray();
        cArray3 = cArray2.toCharArray();
        cArray2 = cArray.toCharArray();
        cArray = var5_6.toCharArray();
        return CertUtil.a(string2, this_, cArray4, cArray3, cArray2, cArray, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v10(int idx, String ssn, String authCode, String oldPassword, String newPassword, boolean isNFilterCipher) throws Exception {
        void var6_7;
        void var5_6;
        char[] cArray;
        char[] cArray2;
        char[] cArray3;
        void var1_1;
        String string2 = ((CertificateManager)((Object)this_)).getUserCertificatePath((int)var1_1);
        String this_ = ((CertificateManager)((Object)this_)).getUserPrivateKeyPath((int)var1_1);
        char[] cArray4 = cArray3.toCharArray();
        cArray3 = cArray2.toCharArray();
        cArray2 = cArray.toCharArray();
        cArray = var5_6.toCharArray();
        return CertUtil.a(string2, this_, cArray4, cArray3, cArray2, cArray, (int)var6_7);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v10(String certPath, String keyPath, String ssn, String authCode) throws Exception {
        void var4_4;
        void var2_2;
        void var3_3;
        Object object = var3_3.toCharArray();
        return CertUtil.a(certPath, (String)var2_2, (char[])object, var4_4.toCharArray(), null, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v10(String certPath, String priPath, String ssn, String authCode, String oldPassword, String newPassword) throws Exception {
        void var6_6;
        void var5_5;
        void var4_4;
        char[] cArray;
        char[] cArray2;
        void v02 = cArray2;
        Object object = cArray.toCharArray();
        char[] cArray3 = var4_4.toCharArray();
        cArray2 = var5_5.toCharArray();
        cArray = var6_6.toCharArray();
        return CertUtil.a(certPath, (String)v02, (char[])object, cArray3, cArray2, cArray, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v10(String certPath, String priPath, String ssn, String authCode, String oldPassword, String newPassword, boolean isNFilterCipher) throws Exception {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        char[] cArray;
        char[] cArray2;
        void v02 = cArray2;
        Object object = cArray.toCharArray();
        char[] cArray3 = var4_4.toCharArray();
        cArray2 = var5_5.toCharArray();
        cArray = var6_6.toCharArray();
        return CertUtil.a(certPath, (String)v02, (char[])object, cArray3, cArray2, cArray, (int)var7_7);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(int idx, String authCode) throws INIXSAFEException {
        void v1;
        String string2;
        try {
            void var2_3;
            void var1_2;
            string2 = ((CertificateManager)((Object)this_)).getUserCertificatePath((int)var1_2);
            v1 = var2_3;
            String this_ = ((CertificateManager)((Object)this_)).getUserPrivateKeyPath((int)var1_2);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        return CertUtil.b(string2, this_, v1.toCharArray(), null, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(int idx, String authCode, String oldPassword, String newPassword) throws INIXSAFEException {
        void v3;
        char[] cArray;
        void v2;
        char[] cArray2;
        void v1;
        String string2;
        try {
            void var4_6;
            void var1_2;
            string2 = ((CertificateManager)((Object)this_)).getUserCertificatePath((int)var1_2);
            v1 = var4_6;
            v2 = cArray2;
            v3 = cArray;
            String this_ = ((CertificateManager)((Object)this_)).getUserPrivateKeyPath((int)var1_2);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        char[] cArray3 = v3.toCharArray();
        cArray = v2.toCharArray();
        cArray2 = v1.toCharArray();
        return CertUtil.b(string2, this_, cArray3, cArray, cArray2, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(int idx, String authCode, String oldPassword, String newPassword, boolean isNFilterCipher) throws INIXSAFEException {
        void v3;
        char[] cArray;
        void v2;
        char[] cArray2;
        void v1;
        String string2;
        int n2 = isNFilterCipher ? 1 : 0;
        try {
            void var4_6;
            void var1_2;
            string2 = ((CertificateManager)((Object)string3)).getUserCertificatePath((int)var1_2);
            v1 = var4_6;
            v2 = cArray2;
            v3 = cArray;
            String string3 = ((CertificateManager)((Object)string3)).getUserPrivateKeyPath((int)var1_2);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        char[] cArray3 = v3.toCharArray();
        cArray = v2.toCharArray();
        cArray2 = v1.toCharArray();
        return CertUtil.b(string2, string3, cArray3, cArray, cArray2, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(int idx, String authCode, String oldPassword, String newPassword, int cipherMode) throws INIXSAFEException {
        void var5_7;
        void v3;
        char[] cArray;
        void v2;
        char[] cArray2;
        void v1;
        String string2;
        try {
            void var4_6;
            void var1_2;
            string2 = ((CertificateManager)((Object)this_)).getUserCertificatePath((int)var1_2);
            v1 = var4_6;
            v2 = cArray2;
            v3 = cArray;
            String this_ = ((CertificateManager)((Object)this_)).getUserPrivateKeyPath((int)var1_2);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        char[] cArray3 = v3.toCharArray();
        cArray = v2.toCharArray();
        cArray2 = v1.toCharArray();
        return CertUtil.b(string2, this_, cArray3, cArray, cArray2, (int)var5_7);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(String certPath, String priPath, String authCode) throws INIXSAFEException {
        try {
            void var3_4;
            void var2_3;
            return CertUtil.b(certPath, (String)var2_3, var3_4.toCharArray(), null, null, 0);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(String certPath, String priPath, String authCode, String oldPassword, String newPassword) throws INIXSAFEException {
        void v3;
        void v2;
        void v1;
        char[] cArray;
        String string2;
        try {
            void var3_4;
            void var4_5;
            void var5_6;
            string2 = certPath;
            v1 = cArray;
            v2 = var5_6;
            v3 = var4_5;
            Object object = var3_4.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        char[] cArray2 = v3.toCharArray();
        cArray = v2.toCharArray();
        return CertUtil.b(string2, (String)v1, (char[])object, cArray2, cArray, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(String certPath, String keyPath, String authCode, String oldPassword, String newPassword, boolean isNFilterCipher) throws INIXSAFEException {
        char[] cArray;
        void v3;
        void v2;
        void v1;
        char[] cArray2;
        void v02;
        char[] cArray3;
        int n2 = isNFilterCipher ? 1 : 0;
        try {
            void var4_6;
            void var5_7;
            v02 = cArray3;
            v1 = cArray2;
            v2 = var5_7;
            v3 = var4_6;
            cArray3 = cArray.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        cArray2 = v3.toCharArray();
        cArray = v2.toCharArray();
        return CertUtil.b((String)v02, (String)v1, cArray3, cArray2, cArray, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v11(String certPath, String keyPath, String authCode, String oldPassword, String newPassword, int cipherMode) throws INIXSAFEException {
        void var6_7;
        void v3;
        void v2;
        void v1;
        char[] cArray;
        String string2;
        try {
            void var3_4;
            void var4_5;
            void var5_6;
            string2 = certPath;
            v1 = cArray;
            v2 = var5_6;
            v3 = var4_5;
            Object object = var3_4.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        char[] cArray2 = v3.toCharArray();
        cArray = v2.toCharArray();
        return CertUtil.b(string2, (String)v1, (char[])object, cArray2, cArray, (int)var6_7);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean importCertificate_v12(String pkcs12, String password) throws INIXSAFEException {
        void var2_2;
        return CertUtil.a(pkcs12, var2_2.toCharArray(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificate_v12(String pkcs12, char[] password) throws INIXSAFEException {
        void var2_2;
        return CertUtil.a(pkcs12, (char[])var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean importCertificate_v12(String pkcs12, String password, boolean isNFilterCipher) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.a(pkcs12, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificate_v12(String pkcs12, char[] password, boolean isNFilterCipher) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.a(pkcs12, (char[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean importCertificate_v12(String pkcs12, String password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.a(pkcs12, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificate_v12(String pkcs12, char[] password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.a(pkcs12, (char[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean importCertificate_v12(String pkcs12, char[] oldPassword, char[] newPassword, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var2_2;
        return CertUtil.a(pkcs12, (char[])var2_2, (char[])var3_3, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<byte[][]> importCertificate_v12_ReturnData(String pkcs12, char[] password) throws INIXSAFEException {
        void var2_2;
        return CertUtil.b(pkcs12, (char[])var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ArrayList<byte[][]> importCertificate_v12_ReturnData(String pkcs12, String password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.b(pkcs12, var2_2.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<byte[][]> importCertificate_v12_ReturnData(String pkcs12, char[] password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        return CertUtil.b(pkcs12, (char[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(int idx, String password) throws INIXSAFEException {
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        void v1 = var2_2;
        Object this_ = v1.toCharArray();
        return certificateManager.exportCertificate_v12((int)var1_1, (char[])this_, v1.toCharArray(), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(int idx, String password, boolean isNFilterCipher) throws INIXSAFEException {
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        void v1 = var2_2;
        Object this_ = v1.toCharArray();
        return certificateManager.exportCertificate_v12((int)var1_1, (char[])this_, v1.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(int idx, char[] password, boolean isNFilterCipher) throws INIXSAFEException {
        void var3_3;
        void var1_1;
        void var2_2;
        void v02 = var2_2;
        return this.exportCertificate_v12((int)var1_1, (char[])v02, (char[])v02, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(int idx, char[] password) throws INIXSAFEException {
        void var1_1;
        void var2_2;
        void v02 = var2_2;
        return this.exportCertificate_v12((int)var1_1, (char[])v02, (char[])v02, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(int idx, String password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        void v1 = var2_2;
        Object this_ = v1.toCharArray();
        return certificateManager.exportCertificate_v12((int)var1_1, (char[])this_, v1.toCharArray(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(int idx, char[] password, int cipherMode) throws INIXSAFEException {
        void var3_3;
        void var1_1;
        void var2_2;
        void v02 = var2_2;
        return this.exportCertificate_v12((int)var1_1, (char[])v02, (char[])v02, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(int idx, String oldPassword, String newPassword, int cipherMode) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        CertificateManager certificateManager = this_;
        Object this_ = var2_2.toCharArray();
        return certificateManager.exportCertificate_v12((int)var1_1, (char[])this_, var3_3.toCharArray(), (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(int idx, char[] oldPassword, char[] newPassword, int cipherMode) throws INIXSAFEException {
        void var4_5;
        void var3_4;
        void var2_3;
        void var1_1;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList4 = arrayList;
        arrayList4();
        arrayList3.add(this_.getUserCertificatePath((int)var1_1));
        arrayList.add(this_.getUserPrivateKeyPath((int)var1_1));
        String string2 = this_.getUserKMCertificatePath((int)var1_1);
        if (string2 != null) {
            arrayList3.add(string2);
            arrayList4.add(this_.getUserKMPrivateKeyPath((int)var1_1));
        }
        if ((string2 = this_.getUserGPKIEncCertificatePath((int)var1_1)) != null) {
            arrayList3.add(string2);
            arrayList4.add(this_.getUserGPKIEncPrivateKeyPath((int)var1_1));
        }
        String[] stringArray = this_;
        ArrayList<String> arrayList5 = arrayList3;
        String[] this_ = new String[arrayList5.size()];
        String[] stringArray2 = new String[arrayList3.size()];
        arrayList5.toArray(this_);
        arrayList4.toArray(stringArray2);
        return stringArray.exportCertificate_v12(this_, stringArray2, (char[])var2_3, (char[])var3_4, (int)var4_5);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(String[] certPath, String[] priPath, String password) throws INIXSAFEException {
        void v3;
        void v1;
        String[] stringArray;
        try {
            void var3_4;
            void var2_3;
            stringArray = certPath;
            v1 = var2_3;
            void v2 = var3_4;
            v3 = v2;
            Object object = v2.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        return CertUtil.a(stringArray, (String[])v1, (char[])object, v3.toCharArray(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(String[] certPath, String[] priPath, char[] password) throws INIXSAFEException {
        try {
            void var2_3;
            void var3_4;
            void v02 = var3_4;
            return CertUtil.a(certPath, (String[])var2_3, (char[])v02, (char[])v02, 0);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(String[] certPath, String[] priPath, String oldPassword, String newPassword) throws INIXSAFEException {
        void v2;
        void v1;
        String[] stringArray;
        try {
            void var3_4;
            void var4_5;
            void var2_3;
            stringArray = certPath;
            v1 = var2_3;
            v2 = var4_5;
            Object object = var3_4.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        return CertUtil.a(stringArray, (String[])v1, (char[])object, v2.toCharArray(), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(String[] certPath, String[] priPath, String password, boolean isNFilterCipher) throws INIXSAFEException {
        void v3;
        void v1;
        void v02;
        char[] cArray;
        int n2 = isNFilterCipher ? 1 : 0;
        try {
            void var3_5;
            void var2_4;
            v02 = cArray;
            v1 = var2_4;
            void v2 = var3_5;
            v3 = v2;
            cArray = v2.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        return CertUtil.a((String[])v02, (String[])v1, cArray, v3.toCharArray(), n2);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(String[] certPath, String[] priPath, char[] password, boolean isNFilterCipher) throws INIXSAFEException {
        int n2 = isNFilterCipher ? 1 : 0;
        try {
            void var2_4;
            void var1_3;
            void var3_5;
            void v02 = var3_5;
            return CertUtil.a((String[])var1_3, (String[])var2_4, (char[])v02, (char[])v02, n2);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(String[] certPath, String[] priPath, String oldPassword, String newPassword, boolean isNFilterCipher) throws INIXSAFEException {
        void v2;
        void v1;
        void v02;
        char[] cArray;
        int n2 = isNFilterCipher ? 1 : 0;
        try {
            void var3_5;
            void var4_6;
            void var2_4;
            v02 = cArray;
            v1 = var2_4;
            v2 = var4_6;
            cArray = var3_5.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        return CertUtil.a((String[])v02, (String[])v1, cArray, v2.toCharArray(), n2);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(String[] certPath, String[] priPath, char[] oldPassword, char[] newPassword, boolean isNFilterCipher) throws INIXSAFEException {
        int n2 = isNFilterCipher ? 1 : 0;
        try {
            void var4_6;
            void var3_5;
            void var2_4;
            void var1_3;
            return CertUtil.a((String[])var1_3, (String[])var2_4, (char[])var3_5, (char[])var4_6, n2);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(String[] certPath, String[] priPath, String password, int cipherMode) throws INIXSAFEException {
        void var4_5;
        void v3;
        void v1;
        String[] stringArray;
        try {
            void var3_4;
            void var2_3;
            stringArray = certPath;
            v1 = var2_3;
            void v2 = var3_4;
            v3 = v2;
            Object object = v2.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        return CertUtil.a(stringArray, (String[])v1, (char[])object, v3.toCharArray(), (int)var4_5);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(String[] certPath, String[] priPath, char[] password, int cipherMode) throws INIXSAFEException {
        try {
            void var4_5;
            void var2_3;
            void var3_4;
            void v02 = var3_4;
            return CertUtil.a(certPath, (String[])var2_3, (char[])v02, (char[])v02, (int)var4_5);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String exportCertificate_v12(String[] certPath, String[] priPath, String oldPassword, String newPassword, int cipherMode) throws INIXSAFEException {
        void var5_6;
        void v2;
        void v1;
        String[] stringArray;
        try {
            void var3_4;
            void var4_5;
            void var2_3;
            stringArray = certPath;
            v1 = var2_3;
            v2 = var4_5;
            Object object = var3_4.toCharArray();
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
        return CertUtil.a(stringArray, (String[])v1, (char[])object, v2.toCharArray(), (int)var5_6);
    }

    /*
     * WARNING - void declaration
     */
    public String exportCertificate_v12(String[] certPath, String[] priPath, char[] oldPassword, char[] newPassword, int cipherMode) throws INIXSAFEException {
        try {
            void var5_6;
            void var4_5;
            void var3_4;
            void var2_3;
            return CertUtil.a(certPath, (String[])var2_3, (char[])var3_4, (char[])var4_5, (int)var5_6);
        }
        catch (Exception exception) {
            throw new INIXSAFEException(exception);
        }
    }

    public final void a(String string2) {
        Properties properties = ((CertificateManager)((Object)properties)).b(string2);
        PropertyConfigurator.configure(string2);
        string2 = properties.getProperty("CryptoChangeMode", "true");
        INISAFECore.setChangeMode(string2.equalsIgnoreCase("false") ^ true);
        IniSafeLog.debug("Crypto \uc554\ud638\uac80\uc99d \uc0ac\uc6a9 \uc5ec\ubd80 \uc635\uc158(false: \uac80\uc99d\ubaa8\ub4dc, true: \ube44\uac80\uc99d\ubaa8\ub4dc) : CryptoChangeMode [ " + string2 + " ]");
        int n2 = Integer.parseInt(properties.getProperty("CertPolicyNum", "0"));
        if (n2 > 0) {
            h = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                CertificateManager.h[n3++] = properties.getProperty("CertPolicy." + n3);
            }
        }
    }

    public final void a() {
        this.b(INISAFEXSAFE.getUseStorageType());
    }

    public final void b(int n2) {
        CertificateManager certificateManager = this;
        CertificateManager certificateManager2 = certificateManager;
        certificateManager.a = CertStorageManager.loadCaCertList(certificateManager.e, n2, h, f, g);
        ArrayList<CertInfo>[] arrayListArray = CertStorageManager.loadUserCertList(certificateManager.e, n2, h, f, g);
        try {
            this.b = arrayListArray[0];
            this.c = arrayListArray[1];
            certificateManager2.d = arrayListArray[2];
        }
        catch (INIXSAFEException iNIXSAFEException) {
            iNIXSAFEException.printStackTrace();
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Properties b(String string2) {
        void var0_3;
        FileInputStream fileInputStream;
        block14: {
            void var1_7;
            block13: {
                FileInputStream fileInputStream2;
                Properties properties;
                IniSafeLog.debug("\uc124\uc815\ud30c\uc77c \uacbd\ub85c: " + string2);
                Properties properties2 = properties;
                properties = new Properties();
                Object var2_8 = null;
                fileInputStream = fileInputStream2;
                Object object = properties2;
                FileInputStream fileInputStream3 = fileInputStream;
                FileInputStream fileInputStream4 = fileInputStream3;
                fileInputStream3(string2);
                ((Properties)object).load(fileInputStream4);
                try {
                    fileInputStream2.close();
                    return properties2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return properties2;
                }
                catch (Exception exception) {
                    break block13;
                }
                catch (Throwable throwable) {
                    fileInputStream = var2_8;
                    break block14;
                }
                catch (Exception exception) {
                    fileInputStream = var2_8;
                }
            }
            IniSafeLog.error(var1_7.toString(), (Throwable)var1_7);
            if (fileInputStream == null) return properties2;
            fileInputStream.close();
            return properties2;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (fileInputStream == null) throw var0_3;
        try {
            fileInputStream.close();
            throw var0_3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        throw var0_3;
    }

    public final String a(ArrayList<CertInfo> arrayList) {
        StringBuilder stringBuilder;
        IniSafeLog.debug("<-- [getCertList()]");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n2 = arrayList.size();
        IniSafeLog.debug("- Size of CertList : " + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder2.append(arrayList.get(i2).toString()).append("|");
        }
        IniSafeLog.debug("--> [getCertList method]");
        return stringBuilder2.toString();
    }

    public final ArrayList<String> a(String string2, boolean bl) {
        ArrayList<String> arrayList;
        IniSafeLog.debug("<-- [" + this.getClass().getName() + ".getUserCertList()]");
        IniSafeLog.debug("- filter : " + string2);
        String string3 = null;
        String string4 = null;
        if (string2 == null) {
            return null;
        }
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (this.b.size() == 0) {
            this.loadUserCert();
        }
        int n2 = this.b.size();
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            StringTokenizer stringTokenizer;
            X509Certificate x509Certificate;
            CertificateManager certificateManager = this;
            CertInfo certInfo = certificateManager.b.get(i2);
            Context context = certificateManager.e;
            CertInfo certInfo2 = certInfo;
            int n3 = INISAFEXSAFE.getUseStorageType();
            try {
                x509Certificate = CertStorageManager.loadCertificate(context, n3, certInfo2.certPath);
            }
            catch (Exception exception) {
                IniSafeLog.error("Error occurred during loading certificate.", exception);
                exception.printStackTrace();
                return null;
            }
            StringTokenizer stringTokenizer2 = stringTokenizer;
            int n4 = 0;
            int n5 = new StringTokenizer(string2, "|").countTokens();
            while (stringTokenizer2.hasMoreTokens()) {
                String string5;
                block16: {
                    block13: {
                        block15: {
                            block14: {
                                block12: {
                                    string5 = stringTokenizer2.nextToken();
                                    int n6 = string5.indexOf("=");
                                    if (n6 != -1) {
                                        string3 = string5.substring(0, n6);
                                        string4 = string5.substring(n6 + 1);
                                        IniSafeLog.debug("- filter_str : " + string3 + " , filter : " + string4);
                                    }
                                    if (!string3.equalsIgnoreCase("subjectDN")) break block12;
                                    string5 = x509Certificate.getSubjectDN().toString();
                                    break block13;
                                }
                                if (!string3.equalsIgnoreCase("issuerDN")) break block14;
                                string5 = x509Certificate.getIssuerDN().toString();
                                break block13;
                            }
                            if (!string3.equalsIgnoreCase("serialNumber")) break block15;
                            string5 = bl ? x509Certificate.getSerialNumber().toString(16) : x509Certificate.getSerialNumber().toString();
                            break block13;
                        }
                        if (!string3.equalsIgnoreCase("expire")) break block16;
                        string5 = this.CertValidateCheck(x509Certificate) ? "0" : "1";
                    }
                    IniSafeLog.debug("- user_filter : " + string5);
                    if (!string5.equalsIgnoreCase(string4)) continue block3;
                    if (++n4 != n5) continue;
                    IniSafeLog.debug("- Add : " + certInfo);
                    arrayList2.add(certInfo.toString());
                    continue;
                }
                IniSafeLog.error("Filter value is NOT in a supported formats(SubjectDN, IssuerDN, SerialNumber).");
                IniSafeLog.error("[Ex] SerialNumber=1234");
                IniSafeLog.error("Your filter value is [ " + string5 + " ].");
                return null;
            }
            continue;
        }
        if (arrayList2.size() <= 0) {
            IniSafeLog.error("There is NO certificate matched by filter, dn=[" + string2 + "].");
        }
        IniSafeLog.debug("--> [getUserCertList method]");
        return arrayList2;
    }

    public final String b(int n2, ArrayList<CertInfo> arrayList) {
        if ((this = ((CertificateManager)this).a(n2, arrayList)) != null) {
            return ((CertInfo)this).certPath;
        }
        return null;
    }

    public final String c(int n2, ArrayList<CertInfo> arrayList) {
        if ((this = ((CertificateManager)this).a(n2, arrayList)) != null) {
            return ((CertInfo)this).priPath;
        }
        return null;
    }

    public final CertInfo a(int n2, ArrayList<CertInfo> arrayList) {
        CertInfo certInfo;
        block2: {
            int n3 = arrayList.size();
            CertInfo certInfo2 = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                certInfo = arrayList.get(i2);
                if (certInfo.index != n2) {
                    continue;
                }
                break block2;
            }
            certInfo = certInfo2;
        }
        return certInfo;
    }

    public final ArrayList<CertInfo> a(int n2) {
        ArrayList<CertInfo> arrayList;
        CertificateManager certificateManager = certInfo2;
        ArrayList<CertInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<CertInfo>();
        CertInfo certInfo = certificateManager.a(n2, certificateManager.b);
        if (certInfo != null) {
            arrayList2.add(certInfo);
        }
        CertificateManager certificateManager2 = certInfo2;
        certInfo = certificateManager2.a(n2, certificateManager2.c);
        if (certInfo != null) {
            arrayList2.add(certInfo);
        }
        CertificateManager certificateManager3 = certInfo2;
        CertInfo certInfo2 = certificateManager3.a(n2, certificateManager3.d);
        if (certInfo2 != null) {
            arrayList2.add(certInfo2);
        }
        return arrayList2;
    }

    public final String[] a(X509Certificate x509Certificate, byte[] byArray, int n2, boolean bl) throws INIXSAFEException {
        int n3 = n2;
        CertificateManager certificateManager = certificateManager.e;
        n2 = INISAFEXSAFE.getUseStorageType();
        boolean bl2 = n3 == 1;
        return CertStorageManager.saveCertificateAndPrivateKey((Context)certificateManager, n2, x509Certificate, byArray, bl, bl2);
    }
}

