/*
 * Decompiled with CFR 0.152.
 */
package com.initech.xsafe.storage;

import android.content.Context;
import android.net.Uri;
import androidx.documentfile.provider.DocumentFile;
import com.initech.core.crypto.INIHandlerKeyPair;
import com.initech.core.x509.x509CertificateInfo;
import com.initech.xsafe.INISAFEXSAFE;
import com.initech.xsafe.cert.CertInfo;
import com.initech.xsafe.cert.INIXSAFEException;
import com.initech.xsafe.storage.KeyPadCipher;
import com.initech.xsafe.storage.a;
import com.initech.xsafe.storage.b;
import com.initech.xsafe.storage.c;
import com.initech.xsafe.util.mlog.IniSafeLog;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;

public class CertStorageManager {
    public static a a(Context context, int n2) {
        if (n2 == 4) {
            return new b(context);
        }
        boolean bl = INISAFEXSAFE.isUseInternalOtherStorage();
        boolean bl2 = INISAFEXSAFE.isUseTwoFactorEncryption();
        return new c(context, n2, bl, bl2);
    }

    public static a a(Context context, int n2, boolean bl, boolean bl2) {
        if (n2 == 4) {
            return new b(context);
        }
        return new c(context, n2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<CertInfo> loadCaCertList(Context context, int useStorageType, String[] oidList, String issuerDnFilter, boolean isEnglish) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return CertStorageManager.a(context, (int)var1_1).a((String[])var2_2, (String)var3_3, (boolean)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<CertInfo>[] loadUserCertList(Context context, int useStorageType, String[] oidList, String issuerDnFilter, boolean isEnglish) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return CertStorageManager.a(context, (int)var1_1).b((String[])var2_2, (String)var3_3, (boolean)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] saveCertificateAndPrivateKey(Context context, int useStorageType, X509Certificate cert, byte[] priKey, boolean doNotSaveIfExist, boolean deleteBeforeSaving) throws INIXSAFEException {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return CertStorageManager.a(context, (int)var1_1).a((X509Certificate)var2_2, (byte[])var3_3, (boolean)var4_4, (boolean)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    public static Uri[] saveCertificateAndPrivateKey(Context context, DocumentFile docBaseDir, X509Certificate cert, byte[] priKey, boolean doNotSaveIfExist) throws INIXSAFEException {
        void var4_5;
        void var1_2;
        void var3_4;
        void var2_3;
        Context context2;
        boolean bl = INISAFEXSAFE.isUseTwoFactorEncryption();
        return new c(context2, 1, INISAFEXSAFE.isUseInternalOtherStorage(), bl).a((X509Certificate)var2_3, (byte[])var3_4, (DocumentFile)var1_2, (boolean)var4_5);
    }

    /*
     * WARNING - void declaration
     */
    public static void savePrivateKey(Context context, int useStorageType, String priPath, byte[] priKey) throws INIXSAFEException {
        void var3_3;
        void var2_2;
        void var1_1;
        CertStorageManager.a(context, (int)var1_1).a((String)var2_2, (byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void savePrivateKey(Context context, int useStorageType, boolean useTwoFactorEncryption, String priPath, byte[] priKey) throws INIXSAFEException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CertStorageManager.a(context, (int)var1_1, INISAFEXSAFE.isUseInternalOtherStorage(), (boolean)var2_2).a((String)var3_3, (byte[])var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public static X509Certificate loadCertificate(Context context, int useStorageType, String certPath) throws INIXSAFEException {
        try {
            void var2_3;
            void var1_2;
            return x509CertificateInfo.loadCertificate(CertStorageManager.loadCertificateBytes(context, (int)var1_2, (String)var2_3));
        }
        catch (Exception exception) {
            IniSafeLog.error("\uc778\uc99d\uc11c \ub85c\ub4dc \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", exception);
            throw new INIXSAFEException("\uc778\uc99d\uc11c \ub85c\ub4dc \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey loadPrivateKey(Context context, int useStorageType, String priPath, char[] password, int cipherMode) throws Exception {
        char[] cArray = null;
        try {
            void var2_3;
            void var1_2;
            Object object;
            void var4_5;
            cArray = KeyPadCipher.getDecryptedString(password, (int)var4_5);
            object = INIHandlerKeyPair.loadPrivateKey(CertStorageManager.loadPrivateKeyBytes(object, (int)var1_2, (String)var2_3), cArray);
            return object;
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] loadCertificateBytes(Context context, int useStorageType, String certPath) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        return CertStorageManager.a(context, (int)var1_1).b((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] loadPrivateKeyBytes(Context context, int useStorageType, String priPath) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        return CertStorageManager.a(context, (int)var1_1).a((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void removeCertificateAndPrivateKey(Context context, int useStorageType, String key) throws INIXSAFEException {
        void var2_2;
        void var1_1;
        CertStorageManager.a(context, (int)var1_1).c((String)var2_2);
    }
}

