/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.crypto;

public class AlgorismMapTable {
    public static final int HASH_IDX = 0;
    public static final int HMAC_IDX = 1;
    public static final int CIPHER_NAME_IDX = 0;
    public static final int CIPHER_MODE_IDX = 1;
    public static final int CIPHER_PADDING_IDX = 2;
    public static final int SHA1 = 128;
    public static final int SHA256 = 64;
    public static final int SHA384 = 32;
    public static final int SHA512 = 16;
    public static final int HMACwithSHA1 = 1;
    public static final int HMACwithSHA256 = 2;
    public static final int HMACwithSHA384 = 4;
    public static final int HMACwithSHA512 = 8;
    public static final int AES = 49152;
    public static final int DES = 40960;
    public static final int DESede = 36864;
    public static final int SEED = 34816;
    public static final int ARIA = 33792;
    public static final int RC2 = 33280;
    public static final int RC5 = 33024;
    public static final int RSA = 16384;
    public static final int ECB = 16;
    public static final int CBC = 32;
    public static final int CFB = 64;
    public static final int OFB = 128;
    public static final int NoPadding = 8;
    public static final int PKCS5Padding = 4;
    public static final int PKCS1Padding = 2;
    public static final int OAEPPadding = 1;
    public static final int NONE = 0;

    public static String a(String string2, int n2) {
        int n3 = string2.length();
        if (n3 < n2) {
            for (int i2 = 0; i2 < n2 - n3; ++i2) {
                string2 = "0" + string2;
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String mappingHashName(int n2) throws Exception {
        if (n2 == 0) return "none";
        if (n2 == 1) return "HMACwithSHA1";
        if (n2 == 2) return "HMACwithSHA256";
        if (n2 == 4) return "HMACwithSHA384";
        if (n2 == 8) return "HMACwithSHA512";
        if (n2 == 16) return "SHA512";
        if (n2 == 32) return "SHA384";
        if (n2 == 64) return "SHA256";
        if (n2 != 128) throw new Exception("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 Hash\uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. <" + n2 + ">");
        return "SHA1";
    }

    public static String a(int n2) throws Exception {
        String string2;
        switch (n2) {
            default: {
                throw new Exception("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc554\ud638\ud654 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. <" + n2 + ">");
            }
            case 49152: {
                string2 = "AES";
                break;
            }
            case 40960: {
                string2 = "DES";
                break;
            }
            case 36864: {
                string2 = "DESede";
                break;
            }
            case 34816: {
                string2 = "SEED";
                break;
            }
            case 33792: {
                string2 = "ARIA";
                break;
            }
            case 33280: {
                string2 = "RC2";
                break;
            }
            case 33024: {
                string2 = "RC5";
                break;
            }
            case 16384: {
                string2 = "RSA";
                break;
            }
            case 128: {
                string2 = "OFB";
                break;
            }
            case 64: {
                string2 = "CFB";
                break;
            }
            case 32: {
                string2 = "CBC";
                break;
            }
            case 16: {
                string2 = "ECB";
                break;
            }
            case 8: {
                string2 = "NoPadding";
                break;
            }
            case 4: {
                string2 = "PKCS5Padding";
                break;
            }
            case 2: {
                string2 = "PKCS1Padding";
                break;
            }
            case 1: {
                string2 = "OAEPPadding";
                break;
            }
            case 0: {
                string2 = "none";
            }
        }
        return string2;
    }

    public static int hashAlgorizmValue(String string2, String string3) throws Exception {
        return AlgorismMapTable.hashAlgorizmValue(string2) + AlgorismMapTable.hashAlgorizmValue(string3);
    }

    public static int hashAlgorizmValue(String string2) throws Exception {
        if ("SHA1".equalsIgnoreCase(string2)) {
            return 128;
        }
        if ("SHA256".equalsIgnoreCase(string2)) {
            return 64;
        }
        if ("SHA384".equalsIgnoreCase(string2)) {
            return 32;
        }
        if ("SHA512".equalsIgnoreCase(string2)) {
            return 16;
        }
        if ("HMACwithSHA1".equalsIgnoreCase(string2)) {
            return 1;
        }
        if ("HMACwithSHA256".equalsIgnoreCase(string2)) {
            return 2;
        }
        if ("HMACwithSHA384".equalsIgnoreCase(string2)) {
            return 4;
        }
        if ("HMACwithSHA512".equalsIgnoreCase(string2)) {
            return 8;
        }
        throw new Exception("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 Hash\uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. <" + string2 + ">");
    }

    public static String[] hashAlgorizmName(int n2) throws Exception {
        String string2 = AlgorismMapTable.a(Integer.toBinaryString(n2), 8);
        int n3 = Integer.parseInt(string2.substring(0, 4) + "0000", 2);
        int n4 = Integer.parseInt(string2.substring(4), 2);
        return new String[]{AlgorismMapTable.mappingHashName(n3), AlgorismMapTable.mappingHashName(n4)};
    }

    public static int cipherAlgorizmInfoValue(String string2) throws Exception {
        int n2 = 0;
        String[] stringArray = string2.split("/");
        int n3 = stringArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += AlgorismMapTable.cipherAlgorizmValue(stringArray[i2]);
        }
        return n2;
    }

    public static int cipherAlgorizmValue(String string2, String string3, String string4) throws Exception {
        int n2 = AlgorismMapTable.cipherAlgorizmValue(string3);
        int n3 = AlgorismMapTable.cipherAlgorizmValue(string4);
        return AlgorismMapTable.cipherAlgorizmValue(string2) + n2 + n3;
    }

    public static int cipherAlgorizmValue(String string2) throws Exception {
        if ("AES".equalsIgnoreCase(string2)) {
            return 49152;
        }
        if ("DES".equalsIgnoreCase(string2)) {
            return 40960;
        }
        if ("DESede".equalsIgnoreCase(string2)) {
            return 36864;
        }
        if ("SEED".equalsIgnoreCase(string2)) {
            return 34816;
        }
        if ("ARIA".equalsIgnoreCase(string2)) {
            return 33792;
        }
        if ("RC2".equalsIgnoreCase(string2)) {
            return 33280;
        }
        if ("RC5".equalsIgnoreCase(string2)) {
            return 33024;
        }
        if ("RSA".equalsIgnoreCase(string2)) {
            return 16384;
        }
        if ("ECB".equalsIgnoreCase(string2)) {
            return 16;
        }
        if ("CBC".equalsIgnoreCase(string2)) {
            return 32;
        }
        if ("CFB".equalsIgnoreCase(string2)) {
            return 64;
        }
        if ("OFB".equalsIgnoreCase(string2)) {
            return 128;
        }
        if ("NoPadding".equalsIgnoreCase(string2)) {
            return 8;
        }
        if ("PKCS5Padding".equalsIgnoreCase(string2)) {
            return 4;
        }
        if ("PKCS1Padding".equalsIgnoreCase(string2)) {
            return 2;
        }
        if ("OAEPPadding".equalsIgnoreCase(string2)) {
            return 1;
        }
        throw new Exception("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc554\ud638\ud654 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. <" + string2 + ">");
    }

    public static String cipherAlgorizmInfo(int n2) throws Exception {
        String[] stringArray = AlgorismMapTable.cipherAlgorizmAttributes(n2);
        return stringArray[0] + "/" + stringArray[1] + "/" + stringArray[2];
    }

    public static String[] cipherAlgorizmAttributes(int n2) throws Exception {
        String string2 = AlgorismMapTable.a(Integer.toBinaryString(n2), 16);
        int n3 = Integer.parseInt(string2.substring(0, 8) + "00000000", 2);
        int n4 = Integer.parseInt(string2.substring(8, 12) + "0000", 2);
        int n5 = Integer.parseInt(string2.substring(12), 2);
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        stringArray2[0] = AlgorismMapTable.a(n3);
        stringArray2[1] = AlgorismMapTable.a(n4);
        stringArray[2] = AlgorismMapTable.a(n5);
        return stringArray;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("# \ud574\uc2dc \uc54c\uace0\ub9ac\uc998 \ud14c\uc2a4\ud2b8");
        System.out.println(AlgorismMapTable.hashAlgorizmName(64)[0]);
        System.out.println(AlgorismMapTable.hashAlgorizmName(64)[1]);
        System.out.println("# \uc554\ud638 \uc54c\uace0\ub9ac\uc998 \ud14c\uc2a4\ud2b8");
        System.out.println(AlgorismMapTable.cipherAlgorizmAttributes(34945)[0]);
        System.out.println(AlgorismMapTable.cipherAlgorizmAttributes(34945)[1]);
        System.out.println(AlgorismMapTable.cipherAlgorizmAttributes(34945)[2]);
        System.out.println("------------------------------------------------");
        System.out.println(AlgorismMapTable.hashAlgorizmValue("SHA256", "HMACwithSHA256"));
        System.out.println(AlgorismMapTable.hashAlgorizmValue("SHA256"));
        System.out.println(AlgorismMapTable.hashAlgorizmValue("HMACwithSHA256"));
        System.out.println(AlgorismMapTable.cipherAlgorizmValue("SEED", "OFB", "OAEPPadding"));
        System.out.println("------------------------------------------------");
        System.out.println(AlgorismMapTable.cipherAlgorizmInfo(34945));
        System.out.println("------------------------------------------------");
        System.out.println(AlgorismMapTable.cipherAlgorizmInfoValue("SEED/OFB/OAEPPadding"));
    }
}

