/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.ocsp;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.core.crypto.INISignature;
import com.initech.core.ocsp.OCSPException;
import com.initech.core.ocsp.Request;
import com.initech.x509.Certificates;
import com.initech.x509.X509CertImpl;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class OCSPRequest
extends ASN1Object {
    public int a;
    public GeneralName b;
    public Vector c;
    public Extensions d;
    public AlgorithmID e;
    public ASN1BitString f;
    public Certificates g;
    public boolean h;
    public byte[] i;
    public X509Certificate x509;
    public String j;

    public OCSPRequest() {
        Certificates certificates;
        ASN1BitString aSN1BitString;
        Extensions extensions;
        Vector vector;
        GeneralName generalName;
        object.a = 1;
        object.h = false;
        object.i = null;
        object.x509 = null;
        object.j = "SHA256";
        Object object = generalName;
        generalName = new GeneralName();
        v1.b = object;
        object = vector;
        vector = new Vector();
        v1.c = object;
        object = extensions;
        extensions = new Extensions();
        v1.d = object;
        v1.e = null;
        object = aSN1BitString;
        aSN1BitString = new ASN1BitString();
        v1.f = object;
        object = certificates;
        certificates = new Certificates();
        v1.g = object;
    }

    public OCSPRequest(byte[] byArray) throws ASN1Exception {
        OCSPRequest oCSPRequest = this;
        OCSPRequest oCSPRequest2 = this;
        oCSPRequest2();
        oCSPRequest2.decode((ASN1Decoder)new DERDecoder(byArray));
        oCSPRequest.encoded = (byte[])byArray.clone();
        oCSPRequest.modified = false;
    }

    public OCSPRequest(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws OCSPException {
        OCSPRequest oCSPRequest = this;
        oCSPRequest();
        oCSPRequest.add(x509Certificate, x509Certificate2);
    }

    public byte[] getTBSRequest() throws ASN1Exception {
        int n2;
        DEREncoder dEREncoder;
        Object object;
        if (!this.h) {
            object = this.i;
            if (this.i != null) {
                return object;
            }
        }
        object = dEREncoder;
        dEREncoder = new DEREncoder();
        int n3 = dEREncoder.encodeSequence();
        if (this.a > 1) {
            n2 = object.encodeExplicit(ASN1Tag.makeContextTag((int)0));
            object.encodeInteger(this.a - 1);
            object.endOf(n2);
        }
        if (!this.b.isNullName()) {
            int n4 = object.encodeExplicit(ASN1Tag.makeContextTag((int)1));
            this.b.encode((ASN1Encoder)object);
            object.endOf(n4);
        }
        n2 = object.encodeSequenceOf();
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            ((Request)((Object)this.c.elementAt(i2))).encode((ASN1Encoder)object);
        }
        object.endOf(n2);
        if (this.d.size() > 0) {
            int n5 = object.encodeExplicit(ASN1Tag.makeContextTag((int)2));
            this.d.encode((ASN1Encoder)object);
            object.endOf(n5);
        }
        object.endOf(n3);
        object = object.toByteArray();
        OCSPRequest oCSPRequest = this;
        oCSPRequest.i = object;
        oCSPRequest.h = false;
        return object;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        int n2 = aSN1Encoder.encodeSequence();
        aSN1Encoder.encodeAny(this.getTBSRequest());
        if (this.f != null && this.e != null) {
            OCSPRequest oCSPRequest = this;
            ASN1Encoder aSN1Encoder2 = aSN1Encoder;
            int n3 = aSN1Encoder2.encodeExplicit(ASN1Tag.makeContextTag((int)0));
            int n4 = aSN1Encoder2.encodeSequence();
            oCSPRequest.e.encode(aSN1Encoder);
            aSN1Encoder.encodeBitString(oCSPRequest.f);
            if (this.g.size() > 0) {
                ASN1Encoder aSN1Encoder3 = aSN1Encoder;
                int n5 = aSN1Encoder3.encodeExplicit(ASN1Tag.makeContextTag((int)0));
                this.g.encode(aSN1Encoder);
                aSN1Encoder3.endOf(n5);
            }
            ASN1Encoder aSN1Encoder4 = aSN1Encoder;
            aSN1Encoder4.endOf(n4);
            aSN1Encoder4.endOf(n3);
        }
        aSN1Encoder.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        Request request;
        int n2;
        ASN1Decoder aSN1Decoder2 = aSN1Decoder;
        int n3 = aSN1Decoder2.decodeSequence();
        int n4 = aSN1Decoder2.decodeSequence();
        if (aSN1Decoder2.nextIsDefault(ASN1Tag.makeExplicitTag((int)0))) {
            this.a = 1;
        } else {
            ASN1Decoder aSN1Decoder3 = aSN1Decoder;
            n2 = aSN1Decoder3.decodeExplicit(ASN1Tag.makeContextTag((int)0));
            this.a = aSN1Decoder3.decodeIntegerAsInt();
            ++this.a;
            aSN1Decoder.endOf(n2);
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)1))) {
            this.b.setNull();
        } else {
            ASN1Decoder aSN1Decoder4 = aSN1Decoder;
            int n5 = aSN1Decoder4.decodeExplicit(ASN1Tag.makeContextTag((int)1));
            this.b.decode(aSN1Decoder);
            aSN1Decoder4.endOf(n5);
        }
        this.c.clear();
        n2 = aSN1Decoder.decodeSequenceOf();
        while (!aSN1Decoder.endOf(n2)) {
            Request request2;
            request = request2;
            request();
            request2.decode(aSN1Decoder);
            this.c.addElement(request);
        }
        this.d.clear();
        if (!aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)2))) {
            ASN1Decoder aSN1Decoder5 = aSN1Decoder;
            int n6 = aSN1Decoder5.decodeExplicit(ASN1Tag.makeContextTag((int)2));
            this.d.decode(aSN1Decoder);
            aSN1Decoder5.endOf(n6);
        }
        aSN1Decoder.endOf(n4);
        this.g.clear();
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)0))) {
            OCSPRequest oCSPRequest = this;
            oCSPRequest.f = null;
            oCSPRequest.e = null;
        } else {
            ASN1Decoder aSN1Decoder6 = aSN1Decoder;
            n4 = aSN1Decoder6.decodeExplicit(ASN1Tag.makeContextTag((int)0));
            n2 = aSN1Decoder6.decodeSequence();
            if (this.e == null) {
                AlgorithmID algorithmID;
                request = algorithmID;
                algorithmID = new AlgorithmID();
                this.e = request;
            }
            this.e.decode(aSN1Decoder);
            this.f = aSN1Decoder.decodeBitString();
            if (!aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)0))) {
                ASN1Decoder aSN1Decoder7 = aSN1Decoder;
                int n7 = aSN1Decoder7.decodeExplicit(ASN1Tag.makeContextTag((int)0));
                this.g.decode(aSN1Decoder);
                aSN1Decoder7.endOf(n7);
            }
            ASN1Decoder aSN1Decoder8 = aSN1Decoder;
            aSN1Decoder8.endOf(n2);
            aSN1Decoder8.endOf(n4);
        }
        aSN1Decoder.endOf(n3);
    }

    public byte[] getEncoded() throws ASN1Exception {
        if (this.h || this.modified || this.encoded == null) {
            DEREncoder dEREncoder;
            DEREncoder dEREncoder2;
            DEREncoder dEREncoder3 = dEREncoder2 = dEREncoder;
            dEREncoder3();
            this.encode((ASN1Encoder)dEREncoder3);
            this.encoded = dEREncoder2.toByteArray();
            dEREncoder.finish();
            this.modified = false;
        }
        return this.encoded;
    }

    public byte[] getSignature() {
        return this.f.getAsByteArray();
    }

    public String getSigAlgName() {
        return this.e.getAlgName();
    }

    public String getSigAlgOID() {
        return this.e.getAlg();
    }

    public byte[] getSigAlgParams() {
        return this.e.getParameter();
    }

    public boolean isSigned() {
        OCSPRequest oCSPRequest = oCSPRequest.e;
        return oCSPRequest != null && oCSPRequest != null;
    }

    public void verify(PublicKey publicKey) throws OCSPException {
        this.verify(publicKey, "Initech");
    }

    public void verify(PublicKey publicKey, String string2) throws OCSPException {
        block7: {
            INISignature iNISignature;
            block6: {
                int n2;
                string2 = "SHA1";
                try {
                    n2 = object.getSigAlgName().indexOf("with");
                    if (n2 < 0) break block6;
                }
                catch (Exception exception) {
                    throw new OCSPException(exception);
                }
                string2 = object.getSigAlgName().substring(0, n2);
            }
            INISignature iNISignature2 = iNISignature;
            PublicKey publicKey2 = publicKey;
            OCSPRequest oCSPRequest = object;
            OCSPRequest oCSPRequest2 = oCSPRequest;
            iNISignature2();
            Object object = oCSPRequest.getTBSRequest();
            if (iNISignature.doVerify(publicKey2, (byte[])object, oCSPRequest2.getSignature(), string2)) break block7;
            return;
        }
        throw new OCSPException("Bad Signature");
    }

    public void sign(PrivateKey privateKey, AlgorithmID algorithmID) throws OCSPException {
        this.sign(privateKey, algorithmID, "Initech");
    }

    public void sign(PrivateKey privateKey, String string2, Object object) throws OCSPException {
        this.sign(privateKey, string2, object, "Initech");
    }

    public void sign(PrivateKey privateKey, AlgorithmID algorithmID, String string2) throws OCSPException {
        INISignature iNISignature;
        OCSPRequest oCSPRequest;
        try {
            OCSPRequest oCSPRequest2 = object;
            oCSPRequest = oCSPRequest2;
            OCSPRequest oCSPRequest3 = oCSPRequest2;
            oCSPRequest2.e = (AlgorithmID)algorithmID.clone();
            oCSPRequest2.h = true;
        }
        catch (Exception exception) {
            throw new OCSPException(exception);
        }
        INISignature iNISignature2 = iNISignature;
        PrivateKey privateKey2 = privateKey;
        AlgorithmID algorithmID2 = algorithmID;
        iNISignature2();
        Object object = object.getTBSRequest();
        object = iNISignature.doSign(privateKey2, (byte[])object, algorithmID2.getAlgName(), string2);
        oCSPRequest.f.setByteArray((byte[])object);
        oCSPRequest3.modified = true;
    }

    public void sign(PrivateKey privateKey, String string2, Object object, String string3) throws OCSPException {
        INISignature iNISignature;
        OCSPRequest oCSPRequest;
        try {
            OCSPRequest oCSPRequest2 = object2;
            oCSPRequest = oCSPRequest2;
            OCSPRequest oCSPRequest3 = oCSPRequest2;
            oCSPRequest2.e = (AlgorithmID)object;
            oCSPRequest2.h = true;
        }
        catch (Exception exception) {
            throw new OCSPException(exception);
        }
        object = iNISignature;
        ((INISignature)object)();
        Object object2 = iNISignature.doSign(privateKey, object2.getTBSRequest(), string2, string3);
        oCSPRequest.f.setByteArray((byte[])object2);
        oCSPRequest3.modified = true;
    }

    public void sign(X509Certificate x509Certificate, PrivateKey privateKey, AlgorithmID algorithmID) throws OCSPException {
        this.sign(x509Certificate, privateKey, algorithmID, "Initech");
    }

    public void sign(X509Certificate x509Certificate, PrivateKey privateKey, AlgorithmID algorithmID, String string2) throws OCSPException {
        if (x509Certificate instanceof X509CertImpl) {
            this.b.set((GeneralNameInterface)((X509CertImpl)x509Certificate).getSubjectDN());
        } else {
            this.b.set(4, ((Object)x509Certificate.getSubjectDN()).toString());
        }
        this.g.add(x509Certificate);
        this.sign(privateKey, algorithmID, string2);
    }

    public void sign(X509Certificate x509Certificate, PrivateKey privateKey, String string2, Object object, String string3) throws OCSPException {
        if (x509Certificate instanceof X509CertImpl) {
            this.b.set((GeneralNameInterface)((X509CertImpl)x509Certificate).getSubjectDN());
        } else {
            this.b.set(4, ((Object)x509Certificate.getSubjectDN()).toString());
        }
        this.g.add(x509Certificate);
        this.x509 = x509Certificate;
        this.sign(privateKey, string2, object, string3);
    }

    public byte[] getExtensionValue(String string2) {
        OCSPRequest oCSPRequest = oCSPRequest.d.getExtension(string2);
        if (oCSPRequest != null) {
            return oCSPRequest.getExtValue();
        }
        return null;
    }

    public void addExtension(Extension extension) {
        this.h = true;
        this.d.add(extension);
    }

    public void clearExtensions() {
        this.h = true;
        this.d.clear();
    }

    public void removeExtension(String string2) {
        this.h = true;
        this.d.remove(string2);
    }

    public void add(Request request) {
        this.h = true;
        this.c.addElement(request);
    }

    public void add(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws OCSPException {
        OCSPRequest oCSPRequest = this;
        oCSPRequest.add(oCSPRequest.j, x509Certificate, x509Certificate2);
    }

    public void add(String string2, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws OCSPException {
        this.h = true;
        this.c.addElement(new Request(string2, x509Certificate, x509Certificate2));
    }

    public Enumeration getRequests() {
        return this.c.elements();
    }

    public Request getRequestAt(int n2) {
        if (n2 >= 0 && n2 <= this.c.size() - 1) {
            return (Request)((Object)this.c.elementAt(n2));
        }
        return null;
    }

    public int size() {
        return this.c.size();
    }

    public void setHashAlg(String string2) {
        this.j = string2;
    }
}

