/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.x509;

import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.AnotherName;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.core.INISAFECore;
import com.initech.core.crypto.CryptoVerification;
import com.initech.core.crypto.INIMessageDigest;
import com.initech.core.crypto.INISignature;
import com.initech.core.exception.INICoreException;
import com.initech.core.util.LogUtil;
import com.initech.core.x509.IdentifyData;
import com.initech.core.x509.VID;
import com.initech.core.x509.VIDUserInfo;
import com.initech.cpv.CertPathValidateResult;
import com.initech.cpv.crl.manager.CRLManager;
import com.initech.cpv.exception.UndeterminedCertStatusException;
import com.initech.cpv.manager.CertStatusManager;
import com.initech.cpv.manager.impl.CRLCertStatusManagerParameters;
import com.initech.cpv.manager.impl.OCSPGDCertStatusManagerParameters;
import com.initech.cpv.manager.impl.OPPRACertStatusManagerParameters;
import com.initech.cpv.manager.impl.VFSVRCertStatusManagerParameters;
import com.initech.cpv.wrapper.CPVWrapper;
import com.initech.pki.util.ArrayComparator;
import com.initech.pki.util.Base64Util;
import com.initech.pki.util.Hex;
import com.initech.x509.X509CRLImpl;
import com.initech.x509.X509CertImpl;
import com.initech.x509.extensions.AccessDescription;
import com.initech.x509.extensions.AuthorityInfoAccess;
import com.initech.x509.extensions.AuthorityKeyIdentifier;
import com.initech.x509.extensions.CRLDistPoints;
import com.initech.x509.extensions.CertificatePolicies;
import com.initech.x509.extensions.DistPoint;
import com.initech.x509.extensions.ExtKeyUsage;
import com.initech.x509.extensions.PolicyInfo;
import com.initech.x509.extensions.SubjectAltName;
import com.initech.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class x509CertificateInfo
extends CryptoVerification {
    public static final String PEM_BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String PEM_END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static String i = "2.5.29.32";
    public static String j;
    public static StringBuffer sbufTxt;
    public static StringBuffer sbufOid;
    public static String x509Extnull = "";
    public ASN1OID a = null;
    public VIDUserInfo b = null;
    public VID c = null;
    public AlgorithmID d = null;
    public char[] e = null;
    public byte[] f = null;
    public byte[] g = null;
    public byte[] h = null;

    public static X509Certificate loadCertificate(String string2) throws Exception {
        return x509CertificateInfo.loadCertificate(string2.getBytes());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509Certificate loadCertificate(byte[] object) throws Exception {
        ByteArrayInputStream byteArrayInputStream;
        X509Certificate x509Certificate;
        String string2;
        Object object2 = string2;
        if (new String((byte[])object).startsWith(PEM_BEGIN_CERTIFICATE)) {
            byte[] byArray;
            String string3 = object2;
            try {
                byArray = Base64Util.decode(string3.substring(27, string3.indexOf(PEM_END_CERTIFICATE)).getBytes());
            }
            catch (IOException iOException) {
                void var0_3;
                INISAFECore.CoreLogger(1, "\ubc14\uc774\ub108\ub9ac \uc778\uc99d\uc11c \uac12\uc744 Base64 \uc778\ucf54\ub529 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. certData=[" + Hex.dumpHex((byte[])var0_3) + "]");
                LogUtil.writeStackTrace(INISAFECore.CoreLogger, iOException);
                throw new IOException("IOException : " + iOException);
            }
            x509Certificate = x509CertificateInfo.loadCertificate(new ByteArrayInputStream(byArray));
            return x509Certificate;
        }
        object2 = byteArrayInputStream;
        try {
            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "X509\ud615\uc2dd\uc758 \uc778\uc99d\uc11c\ub85c \ubcc0\ud658 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. certData=[" + Hex.dumpHex(object) + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception(exception);
        }
        x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509", INISAFECore.getProviderName()).generateCertificate((InputStream)object2);
        return x509Certificate;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadCertificateFromFile(String var0) throws Exception {
        block16: {
            var1_6 = null;
            if (var0 == null) throw new Exception("certPath is null");
            var2_8 = v0;
            try {
                v0 = new FileInputStream((String)var0);
            }
            catch (FileNotFoundException var2_9) {
                // empty catch block
                ** GOTO lbl-1000
            }
            try {
                var0 = x509CertificateInfo.loadCertificate(v0);
            }
            catch (Exception var0_1) {
                ** GOTO lbl-1000
            }
            catch (FileNotFoundException var1_7) {
                var1_6 = var2_8;
                var2_8 = var1_7;
                ** GOTO lbl-1000
            }
            catch (Throwable var0_4) {
                var1_6 = var2_8;
                break block16;
            }
            try {
                v0.close();
                return var0;
            }
            catch (Exception v1) {}
            return var0;
            catch (Throwable var0_2) {
                break block16;
            }
            catch (Exception var0_3) {
                var2_8 = var1_6;
            }
lbl-1000:
            // 2 sources

            {
                INISAFECore.CoreLogger(1, "X509\ud615\uc2dd\uc758 \uc778\uc99d\uc11c\ub85c \ubcc0\ud658 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. ");
                LogUtil.writeStackTrace(INISAFECore.CoreLogger, (Exception)var0);
                throw new Exception((Throwable)var0);
            }
lbl-1000:
            // 2 sources

            {
                INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.certPath=[" + (String)var0 + "]");
                LogUtil.writeStackTrace(INISAFECore.CoreLogger, (Exception)var2_8);
                throw new Exception((Throwable)var2_8);
            }
        }
        if (var1_6 == null) throw var0_5;
        try {
            var1_6.close();
            throw var0_5;
        }
        catch (Exception v2) {}
        throw var0_5;
    }

    public static X509Certificate loadCertificate(InputStream inputStream) throws Exception {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509", "Initech").generateCertificate(inputStream);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            INISAFECore.CoreLogger(1, "provider\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. (provider: Initech)");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchProviderException);
            throw new NoSuchProviderException("NoSuchProviderException : " + noSuchProviderException.toString());
        }
        catch (CertificateException certificateException) {
            INISAFECore.CoreLogger(1, "X509\ud615\uc2dd\uc758 \uc778\uc99d\uc11c\ub85c \ubcc0\ud658 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, certificateException);
            throw new CertificateException("CertificateException : " + certificateException.toString());
        }
    }

    public static X509CRL loadCertCRL(FileInputStream fileInputStream) throws Exception {
        try {
            return (X509CRLImpl)CertificateFactory.getInstance("X.509", "Initech").generateCRL(fileInputStream);
        }
        catch (CRLException cRLException) {
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, cRLException);
            throw new CRLException("CRLException : " + cRLException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            INISAFECore.CoreLogger(1, "provider\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. (provider: Initech)");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchProviderException);
            throw new NoSuchProviderException("NoSuchProviderException : " + noSuchProviderException);
        }
        catch (CertificateException certificateException) {
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, certificateException);
            throw new CertificateException("CertificateException : " + certificateException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadCertFromURL(String string2) throws MalformedURLException, IOException {
        Throwable throwable2222222;
        InputStream inputStream;
        block16: {
            block15: {
                INISAFECore.CoreLogger(4, "urlStr: " + string2);
                inputStream = new URL(string2).openConnection().getInputStream();
                int n2 = inputStream.available();
                if (n2 > Integer.MAX_VALUE || n2 < Integer.MIN_VALUE) break block15;
                InputStream inputStream2 = inputStream;
                InputStream inputStream3 = inputStream2;
                InputStream inputStream4 = inputStream2;
                byte[] byArray = new byte[n2];
                inputStream2.read(byArray);
                inputStream4.close();
                if (inputStream3 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    return x509CertificateInfo.loadCertificate(new String(byArray));
                }
                catch (Exception exception) {
                    INISAFECore.CoreLogger(1, "URL\uc744 \ud1b5\ud574 \uc778\uc99d\uc11c\ub97c \uc77d\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. urlStr=[" + string2 + "]");
                    LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                    return null;
                }
            }
            try {
                throw new IOException();
            }
            catch (Throwable throwable2222222) {
                break block16;
            }
            catch (Exception exception) {
                LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                throw new IOException();
            }
        }
        if (inputStream == null) throw throwable2222222;
        try {
            inputStream.close();
            throw throwable2222222;
        }
        catch (Exception exception) {}
        throw throwable2222222;
    }

    public static String X509CertificateToStr(X509Certificate object) throws IOException, CertificateEncodingException {
        object = Base64Util.encode(((Certificate)object).getEncoded(), false);
        return new String((byte[])object);
    }

    public static String X509CertificateToPem(X509Certificate object) throws IOException, CertificateEncodingException {
        if ((object = x509CertificateInfo.X509CertificateToStr((X509Certificate)object)) != null && !((String)object).equals("")) {
            return "-----BEGIN CERTIFICATE-----\n" + (String)object + "\n-----END CERTIFICATE-----";
        }
        throw new CertificateEncodingException("\uc778\uc99d\uc11c \ubcc0\ud658(PEM) \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
    }

    public static String binraryCert(String string2) throws Exception {
        block5: {
            String string3 = PEM_END_CERTIFICATE;
            try {
                INISAFECore.CoreLogger(4, "pemCert: " + string2);
                if (string2.indexOf(PEM_BEGIN_CERTIFICATE) < 0) break block5;
            }
            catch (Exception exception) {
                INISAFECore.CoreLogger(1, "Pem type\uc778\uc99d\uc11c\ub97c \ubc14\uc774\ub108\ub9ac\ub85c \ubc14\uafb8\ub294\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                throw new Exception("an error occurred during converting the PEM certificate into binary format.");
            }
            if (string2.indexOf(string3) < 0) break block5;
            String string4 = string2;
            int n2 = 27;
            string2 = string4.substring(n2, string4.indexOf(string3));
        }
        return string2;
    }

    public static boolean verifyCert(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws Exception {
        INISignature iNISignature;
        String string2;
        block10: {
            block9: {
                try {
                    string2 = x509Certificate2.getSigAlgName();
                }
                catch (Exception exception) {
                    INISAFECore.CoreLogger(1, "CA\uc778\uc99d\uc11c\ub85c \uc785\ub825\ubc1b\uc740 \uc778\uc99d\uc11c\ub97c \uac80\uc99d\ud558\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                    INISAFECore.CoreLogger(1, "CA\uc778\uc99d\uc11c \uc815\ubcf4=[" + ((Object)x509Certificate.getSubjectDN()).toString() + "]");
                    INISAFECore.CoreLogger(1, "\uac80\uc99d\ubc1b\uc744 \uc778\uc99d\uc11c \uc815\ubcf4=[" + ((Object)x509Certificate2.getSubjectDN()).toString() + "]");
                    LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                    throw new Exception(exception);
                }
                int n2 = string2.indexOf("with");
                if (n2 < 0) break block9;
                string2 = string2.substring(0, n2);
                break block10;
            }
            string2 = "SHA1";
        }
        Object object = iNISignature;
        X509Certificate x509Certificate3 = x509Certificate2;
        X509Certificate x509Certificate4 = x509Certificate3;
        X509Certificate x509Certificate5 = x509Certificate3;
        ((INISignature)object)();
        object = x509Certificate3.getPublicKey();
        byte[] byArray = x509Certificate5.getTBSCertificate();
        byte[] byArray2 = x509Certificate4.getSignature();
        return iNISignature.doVerify((PublicKey)object, byArray, byArray2, string2);
    }

    public static boolean verifyServerCert(X509Certificate serializable, String object) throws Exception {
        Exception exception;
        String string2;
        block14: {
            Date date;
            File file;
            string2 = "";
            Object object2 = ((Name)serializable.getIssuerDN()).getEncoded();
            object2 = new INIMessageDigest().doDigest((byte[])object2, "MD5");
            for (int i2 = 3; i2 >= 0; --i2) {
                string2 = string2 + Hex.dumpHex(object2[i2]);
                continue;
            }
            try {
                string2 = string2.toLowerCase();
            }
            catch (Exception exception2) {
                LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception2);
                throw new Exception(exception2);
            }
            File file2 = file;
            File file3 = file;
            file2((String)object + File.separatorChar + "CACert" + File.separatorChar + string2 + ".0");
            if (!file3.canRead()) break block14;
            object = date;
            date = new Date(System.currentTimeMillis());
            object2 = serializable.getNotAfter();
            if (serializable.getNotBefore().before((Date)object) && object2.after((Date)object)) {
                INISignature iNISignature;
                INISAFECore.CoreLogger(4, "\uc720\ud6a8\ud55c \uc778\uc99d\uc11c \uc785\ub2c8\ub2e4.");
                x509CertificateInfo.loadCertificateFromFile(string2);
                object = serializable.getSigAlgName();
                int n2 = ((String)object).indexOf("with");
                object = n2 >= 0 ? ((String)object).substring(0, n2) : "SHA1";
                Object object3 = iNISignature;
                X509Certificate x509Certificate = serializable;
                ((INISignature)object3)();
                serializable = x509Certificate.getPublicKey();
                object3 = x509Certificate.getTBSCertificate();
                object2 = x509Certificate.getSignature();
                return iNISignature.doVerify((PublicKey)serializable, (byte[])object3, (byte[])object2, (String)object);
            }
            INISAFECore.CoreLogger(4, "\ub9cc\ub8cc\ub41c \uc778\uc99d\uc11c \uc774\uac70\ub098 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc778\uc99d\uc11c \uc785\ub2c8\ub2e4.");
            return false;
        }
        INISAFECore.CoreLogger(1, "filePath: " + (String)object + File.separatorChar + "CACert" + File.separatorChar + string2 + ".0");
        INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c \ud30c\uc77c\uc744 \uc77d\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        Exception exception3 = exception;
        Exception exception4 = exception;
        exception3("[" + (String)object + "] the file does not exist or cannot read it. ");
        throw exception4;
    }

    public static String getCertificatePolicy(X509Certificate x509Certificate) throws Exception {
        CertificatePolicies certificatePolicies;
        X509Certificate x509Certificate2 = x509Certificate;
        x509Certificate = null;
        Object[] objectArray = x509Certificate2.getExtensionValue(i);
        CertificatePolicies certificatePolicies2 = certificatePolicies;
        ASN1OID[] aSN1OIDArray = new CertificatePolicies(objectArray).getPolicyIDs();
        objectArray = aSN1OIDArray;
        int n2 = aSN1OIDArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            x509Certificate = certificatePolicies2.getPolicy((ASN1OID)objectArray[i2]);
        }
        if (x509Certificate != null) {
            return x509Certificate.getPolicyID().get();
        }
        INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c \uc815\ucc45(policy)\uc744 \uac00\uc838\uc624\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        throw new Exception("an error occurred during loading a certificate policy.");
    }

    public static boolean validate(X509Certificate x509Certificate, String object, String string2) throws INICoreException {
        try {
            return CPVWrapper.getInstance((String)object, string2).validate(x509Certificate) != null;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            INISAFECore.CoreLogger(1, " CertPathValidator Exception : cert path validation is fail.");
            INISAFECore.CoreLogger(1, "Cert: [" + x509Certificate + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, (Exception)object);
            throw new INICoreException((Exception)object);
        }
    }

    public static boolean validate(X509Certificate x509Certificate, String string2, String string3, String string4) throws INICoreException {
        try {
            return CPVWrapper.getInstance(string2, string3).validate(x509Certificate, string4) != null;
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, " CertPathValidator Exception : cert path validation is fail. ");
            INISAFECore.CoreLogger(1, "Cert: [" + x509Certificate + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new INICoreException(exception);
        }
    }

    public static boolean validate(X509Certificate x509Certificate, Properties object, String string2) throws INICoreException {
        String string3;
        String string4;
        String string5;
        block17: {
            block16: {
                block15: {
                    string5 = "Not Exists.";
                    string4 = "Not Exists.";
                    string3 = "Not Exists.";
                    try {
                        object = new CPVWrapper((Properties)object, string2).validate(x509Certificate);
                    }
                    catch (Exception exception) {
                        INISAFECore.CoreLogger(1, " CertPathValidator Exception : cert path validation is fail. ");
                        INISAFECore.CoreLogger(1, "Cert: [" + x509Certificate + "]");
                        LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                        return false;
                    }
                    if (((CertPathValidateResult)object).getTrustAnchorCert() == null) break block15;
                    string5 = ((CertPathValidateResult)object).getTrustAnchorCert().toString();
                }
                if (((CertPathValidateResult)object).getPublicKey() == null) break block16;
                string4 = Hex.prettyDump(((CertPathValidateResult)object).getPublicKey().getEncoded(), 48, ' ');
            }
            if (((CertPathValidateResult)object).getPolicyTree() == null) break block17;
            string3 = ((CertPathValidateResult)object).getPolicyTree().toString();
        }
        INISAFECore.CoreLogger(3, "Trust Anchor : " + string5);
        INISAFECore.CoreLogger(3, "Target Certificate's Public Key : " + string4);
        INISAFECore.CoreLogger(3, "Valid Policy Tree : " + string3);
        return true;
    }

    public static boolean validate(X509Certificate x509Certificate, Properties object, String string2, String string3) throws INICoreException {
        String string4;
        String string5;
        String string6;
        block17: {
            block16: {
                block15: {
                    CPVWrapper cPVWrapper;
                    string6 = "Not Exists.";
                    string5 = "Not Exists.";
                    string4 = "Not Exists.";
                    CPVWrapper cPVWrapper2 = cPVWrapper;
                    try {
                        cPVWrapper2((Properties)object, string2);
                        object = cPVWrapper.validate(x509Certificate, string3);
                    }
                    catch (Exception exception) {
                        INISAFECore.CoreLogger(1, " CertPathValidator Exception : cert path validation is fail. ");
                        INISAFECore.CoreLogger(1, "Cert: [" + x509Certificate + "]");
                        LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                        return false;
                    }
                    if (((CertPathValidateResult)object).getTrustAnchorCert() == null) break block15;
                    string6 = ((CertPathValidateResult)object).getTrustAnchorCert().toString();
                }
                if (((CertPathValidateResult)object).getPublicKey() == null) break block16;
                string5 = Hex.prettyDump(((CertPathValidateResult)object).getPublicKey().getEncoded(), 48, ' ');
            }
            if (((CertPathValidateResult)object).getPolicyTree() == null) break block17;
            string4 = ((CertPathValidateResult)object).getPolicyTree().toString();
        }
        INISAFECore.CoreLogger(3, "Trust Anchor : " + string6);
        INISAFECore.CoreLogger(3, "Target Certificate's Public Key : " + string5);
        INISAFECore.CoreLogger(3, "Valid Policy Tree : " + string4);
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static Hashtable checkCertStatus(String var0, String[] var1_1, String[] var2_4, String var3_5, X509Certificate var4_6, String var5_7, String var6_8, String var7_9) throws INICoreException {
        var0 = v0;
        v0 = new Hashtable<K, V>();
        for (var8_10 = 0; var8_10 < ((Object)var1_1).length; ++var8_10) {
            block45: {
                block49: {
                    block48: {
                        block46: {
                            block47: {
                                block43: {
                                    block44: {
                                        var9_11 = var1_1[var8_10];
                                        var10_12 = var8_10 < var2_4.length ? var2_4[var8_10] : var2_4[var2_4.length - 1];
                                        try {
                                            block50: {
                                                if (var9_11.equals("CRL")) {
                                                    v1 = var9_11;
                                                    CRLManager.setStoreManagerConfigPath((String)var10_12);
                                                    v2 = new CRLCertStatusManagerParameters();
lbl11:
                                                    // 2 sources

                                                    while (true) {
                                                        v3 = CertStatusManager.getInstance((String)v1, v2);
lbl13:
                                                        // 5 sources

                                                        while (true) {
                                                            var10_12 = v3;
                                                            break block43;
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                }
                                                if (!var9_11.equals("VFSVR")) break block50;
                                                v3 = CertStatusManager.getInstance((String)var9_11, new VFSVRCertStatusManagerParameters((String)var10_12));
                                                ** GOTO lbl13
                                            }
                                            if (var9_11.equals("OCSPCD")) {
                                                v1 = var9_11;
                                                v2 = new CRLCertStatusManagerParameters();
                                                ** continue;
                                            }
                                            if (!var9_11.equals("OPPRA")) ** GOTO lbl68
                                            if (var3_5 == null || var3_5.equals("")) break block44;
                                            if ((var3_5 = var3_5.substring(1, 3)) == null) ** GOTO lbl45
                                        }
                                        catch (Exception var1_3) {
                                            v4 = var0;
                                            INISAFECore.CoreLogger(1, "verifycert, 9. \uc778\uc99d\uc11c \uc0c1\ud0dc \uac80\uc99d\uc744 \uc704\ud55c CSC Provider \ucd08\uae30\ud654\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc0c1\uc138 \uc624\ub958 : " + var1_3.toString());
                                            LogUtil.writeStackTrace(INISAFECore.CoreLogger, var1_3);
                                            v4.put("RETURN_CODE", "940");
                                            v4.put("RETURN_MSG", "9. \uc778\uc99d\uc11c \uc0c1\ud0dc \uac80\uc99d\uc744 \uc704\ud55c CSC Provider \ucd08\uae30\ud654\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc0c1\uc138 \uc624\ub958 : " + var1_3.toString());
                                            return v4;
                                        }
                                        if (var3_5.equals("")) ** GOTO lbl45
                                        v5 = var9_11;
                                        v6 = var3_5;
                                        v7 = 4;
                                        INISAFECore.CoreLogger(v7, "OPPRA CertPolicy, 9. \uc81c\ucd9c\ud558\uc2e0 \uc778\uc99d\uc11c\ub294 [" + var3_5 + "] \uc785\ub2c8\ub2e4.");
                                        v3 = CertStatusManager.getInstance((String)v5, v6, new OPPRACertStatusManagerParameters((String)var10_12));
                                        ** GOTO lbl13
lbl45:
                                        // 2 sources

                                        v8 = var0;
                                        v9 = v8;
                                        v10 = v8;
                                        INISAFECore.CoreLogger(1, "OPPRA CertPolicy, 9. OID.ini \ud30c\uc77c\uc5d0\uc11c \uc778\uc99d\uc11c \uc815\ucc45 \ucf54\ub4dc(Policy Code)\uac00 \uc124\uc815\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc815\ucc45 \ucf54\ub4dc\ub97c \ucd94\uac00 \ud6c4\uc5d0 \ub2e4\uc2dc \uc9c4\ud589\ud574\uc8fc\uc138\uc694.");
                                        v8.put("RETURN_CODE", "940");
                                        v10.put("RETURN_MSG", "9. OID.ini \ud30c\uc77c\uc5d0\uc11c \uc778\uc99d\uc11c \uc815\ucc45 \ucf54\ub4dc(Policy Code)\uac00 \uc124\uc815\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc815\ucc45 \ucf54\ub4dc\ub97c \ucd94\uac00 \ud6c4\uc5d0 \ub2e4\uc2dc \uc9c4\ud589\ud574\uc8fc\uc138\uc694.");
                                        return v9;
                                    }
                                    v11 = var9_11;
                                    INISAFECore.CoreLogger(3, "OPPRA CertPolicy, 9. \ud574\ub2f9 \uc815\ucc45 \uc124\uc815\uc5d0\uc11c CertOIDs \uc635\uc158\uc774 \ube60\uc838\uc788\uac70\ub098, OID.ini \ud30c\uc77c \ub0b4\uc6a9\uc5d0 \ubb38\uc81c\uac00 \uc788\uc2b5\ub2c8\ub2e4.");
                                    INISAFECore.CoreLogger(3, "OPPRA CertPolicy, 9. OPPRA \uae30\ub2a5\uc744 \uc0ac\uc6a9\ud558\uae30 \uc704\ud574\uc11c\ub294 \ubc18\ub4dc\uc2dc!!! CertOIDs \uc635\uc158\uc744 \ucd94\uac00\ud574\uc8fc\uc2dc\uac70\ub098 OID.ini \ud30c\uc77c \ub0b4\uc6a9\uc744 \ud655\uc778 \ud6c4 \uc62c\ubc14\ub974\uac8c \uc218\uc815\ud574\uc8fc\uc138\uc694.");
                                    INISAFECore.CoreLogger(3, "OPPRA CertPolicy, 9. [_shttp_client_cert_policy_text_]\uac12\uc744 \uac00\uc838\uc624\uc9c0 \ubabb\ud574\uc11c \ub514\ud3f4\ud2b8 \uac12\uc73c\ub85c \ucc98\ub9ac\ub429\ub2c8\ub2e4.");
                                    INISAFECore.CoreLogger(3, "OPPRA CertPolicy, 9. \ub514\ud3f4\ud2b8\ub85c \ucc98\ub9ac\ub418\ub294 OID \ub300\uc0c1\uc740 \uc544\ub798\uc640 \uac19\uc2b5\ub2c8\ub2e4.");
                                    INISAFECore.CoreLogger(3, "OPPRA CertPolicy, 9. [1.2.410.200005.1.1.5], [1.2.410.200004.5.1.1.7], [1.2.410.200004.5.4.1.2], [1.2.410.200005.1.1.2], [1.2.410.200005.1.1.1], [1.2.410.200004.5.1.1.5], [1.2.410.200004.5.4.1.1], [1.2.410.200005.1.1.6.8]");
                                    v12 = 3;
                                    INISAFECore.CoreLogger(v12, "OPPRA CertPolicy, 9. \uc81c\ucd9c\ud558\uc2e0 \uc778\uc99d\uc11c\uc758 oid\uac12\uc740 [" + x509CertificateInfo.getCertOID(var4_6) + "]\uc785\ub2c8\ub2e4.");
                                    v3 = CertStatusManager.getInstance((String)v11, new OPPRACertStatusManagerParameters((String)var10_12));
                                    ** GOTO lbl13
lbl68:
                                    // 1 sources

                                    if (var9_11.equals("OCSPGD")) {
                                        v3 = CertStatusManager.getInstance((String)var9_11, new OCSPGDCertStatusManagerParameters((String)var10_12));
                                        ** continue;
                                    }
                                    break block45;
                                }
                                v13 = var10_12;
                                var10_12.setClientInfo(var5_7, var6_8);
                                v13.setCertificate(var4_6);
                                if (!v13.isUsable()) {
                                    if (var8_10 < ((Object)var1_1).length - 1) {
                                        INISAFECore.CoreLogger(3, "verifycert, 9. " + (String)var9_11 + " \ub85c\ub294 \ud604\uc7ac \uc778\uc99d\uc11c \uc0c1\ud0dc\ub97c \uac80\uc99d\ud560 \uc218 \uc5c6\uc5b4 \ub2e4\uc74c Provider \ub85c \ucc98\ub9ac\ub97c \ub118\uae41\ub2c8\ub2e4. \uc0ac\uc720 : (" + var10_12.getErrorMessage() + ")");
                                        continue;
                                    }
                                    v14 = var0;
                                    INISAFECore.CoreLogger(1, "verifycert, 9. " + (String)var9_11 + " \ub85c\ub294 \ud604\uc7ac \uc778\uc99d\uc11c \uc0c1\ud0dc\ub97c \uac80\uc99d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc0ac\uc720 : (" + var10_12.getErrorMessage() + ")");
                                    INISAFECore.CoreLogger(1, "verifycert, 9. \ud604\uc7ac \uc124\uc815\ub41c \ubaa8\ub4e0 Provider \ub85c \uc0c1\ud0dc\ub97c \uac80\uc99d\ud560 \uc218 \uc5c6\ub294 \uc778\uc99d\uc11c\uc774\ubbc0\ub85c \uc624\ub958\ub85c \ucc98\ub9ac\ud569\ub2c8\ub2e4. \uc0ac\uc720 : (" + var10_12.getErrorMessage() + ")");
                                    v14.put("RETURN_CODE", "940");
                                    return v14;
                                }
                                if (!var10_12.isValid()) break block46;
                                v15 = var0;
                                INISAFECore.CoreLogger(3, "verifycert, 9. " + (String)var9_11 + " \ub85c \uc778\uc99d\uc11c \uc0c1\ud0dc(\uc720\ud6a8\uc131) \uac80\uc99d\uc5d0 \uc131\uacf5\ud588\uc2b5\ub2c8\ub2e4. \uc720\ud6a8\ud55c \uc778\uc99d\uc11c \uc785\ub2c8\ub2e4.");
                                v15.put("RETURN_CODE", "000");
                                v15.put("SCS", var9_11);
                                if (!var9_11.equals("OCSPGD") || !OCSPGDCertStatusManagerParameters.dbQuery || OCSPGDCertStatusManagerParameters.certRegURL == null || var7_9 != null) break block47;
                                v16 = var0;
                                INISAFECore.CoreLogger(3, "verifycert, 9. " + (String)var9_11 + " \uc5d0 \uc758\ud574 \ud0c0\ud589/\ud0c0\uae30\uad00 \uc778\uc99d\uc11c \ub4f1\ub85d \ud398\uc774\uc9c0\ub85c \uc774\ub3d9\ud569\ub2c8\ub2e4.(redirect)");
                                v16.put("RETURN_CODE", "500");
                                v16.put("RETURN_MSG", "9. " + (String)var9_11 + " \uc5d0 \uc758\ud574 \ud0c0\ud589/\ud0c0\uae30\uad00 \uc778\uc99d\uc11c \ub4f1\ub85d \ud398\uc774\uc9c0\ub85c \uc774\ub3d9\ud569\ub2c8\ub2e4.(redirect)");
                                v16.put("REDIRECT_URL", OCSPGDCertStatusManagerParameters.certRegURL);
                                return v16;
                            }
                            v17 = var0;
                            v18 = v17;
                            v19 = v17;
                            var10_12 = var10_12.getResultInfo();
                            v17.put("RETURN_CODE", "000");
                            v19.put("INFO", var10_12);
                            return v18;
                        }
                        var11_14 = var10_12.getErrorMessage();
                        if (var11_14 == null) ** GOTO lbl132
                        if (var11_14.equals("")) ** GOTO lbl132
                        v20 = 1;
                        INISAFECore.CoreLogger(v20, "verifycert, 9. " + var11_14);
                        continue;
lbl132:
                        // 2 sources

                        if (!var10_12.isInefficacy()) break block48;
                        v21 = var0;
                        INISAFECore.CoreLogger(3, "verifycert, 9. \uc778\uc99d\uc11c\uac00 \ud6a8\ub825 \uc815\uc9c0\ub418\uc5b4 \ud604\uc7ac\ub294 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ucc98\ub9ac Provider : " + (String)var9_11);
                        v21.put("RETURN_CODE", "939");
                        v21.put("RETURN_MSG", "verifycert, 9. \uc778\uc99d\uc11c\uac00 \ud6a8\ub825 \uc815\uc9c0\ub418\uc5b4 \ud604\uc7ac\ub294 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ucc98\ub9ac Provider : " + (String)var9_11);
                        return v21;
                    }
                    v22 = var0;
                    INISAFECore.CoreLogger(1, "verifycert, 9. \uc778\uc99d\uc11c\uac00 \ud3d0\uae30 \ub418\uc5b4 \ub354\uc774\uc0c1 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ucc98\ub9ac Provider : " + (String)var9_11);
                    v22.put("RETURN_CODE", "938");
                    try {
                        v22.put("RETURN_MSG", "verifycert, 9. \uc778\uc99d\uc11c\uac00 \ud3d0\uae30 \ub418\uc5b4 \ub354\uc774\uc0c1 \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ucc98\ub9ac Provider : " + (String)var9_11);
                    }
                    catch (Exception var1_2) {
                        v23 = var0;
                        INISAFECore.CoreLogger(1, "verifycert, 9. " + (String)var9_11 + " \ub85c \ud604\uc7ac \uc778\uc99d\uc11c \uc0c1\ud0dc\ub97c \uac80\uc99d\ud558\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                        INISAFECore.CoreLogger(1, "verifycert, >> \uc0c1\uc138 \uc815\ubcf4 : " + var1_2);
                        v23.put("RETURN_CODE", "940");
                        v23.put("RETURN_MSG", "verifycert, 9. " + (String)var9_11 + " \ub85c \ud604\uc7ac \uc778\uc99d\uc11c \uc0c1\ud0dc\ub97c \uac80\uc99d\ud558\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                        return v23;
                    }
                    catch (UndeterminedCertStatusException var10_13) {
                        if (var8_10 >= ((Object)var1_1).length - 1) break block49;
                        INISAFECore.CoreLogger(1, "verifycert, 9. " + (String)var9_11 + " \ub85c \ud604\uc7ac \uc778\uc99d\uc11c \uc0c1\ud0dc \uac80\uc99d\uc5d0 \uc2e4\ud328\ud558\uc5ec \ub2e4\uc74c Provider \ub85c \ucc98\ub9ac\ub97c \ub118\uae41\ub2c8\ub2e4. \uc694\uc57d \uc815\ubcf4 : " + var10_13.getMessage());
                        INISAFECore.CoreLogger(1, "verifycert, >> \uc0c1\uc138 \uc815\ubcf4 : " + var10_13.toString());
                        var9_11 = var10_13.getCauseException();
                        if (var9_11 == null) continue;
                        INISAFECore.CoreLogger(1, "verifycert, >> \uc6d0\uc778 \uc815\ubcf4 : " + var9_11.toString());
                    }
                    return v22;
                    continue;
                }
                INISAFECore.CoreLogger(1, "verifycert, 9. " + (String)var9_11 + " \ub85c \ud604\uc7ac \uc778\uc99d\uc11c \uc0c1\ud0dc \uac80\uc99d\uc5d0 \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4.");
                INISAFECore.CoreLogger(1, "verifycert, >> \uc0c1\uc138 \uc815\ubcf4 : " + var10_13.toString());
                var1_1 = var10_13.getCauseException();
                if (var1_1 != null) {
                    INISAFECore.CoreLogger(1, "verifycert, >> \uc6d0\uc778 \uc815\ubcf4 : " + var1_1.toString());
                }
                v24 = var0;
                v24.put("RETURN_CODE", "940");
                return v24;
            }
            INISAFECore.CoreLogger(1, "verifycert, 9. \uc778\uc99d\uc11c \uc0c1\ud0dc \uac80\uc99d\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. [" + (String)var9_11 + "] \ub294 \uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc778\uc99d\uc11c \uc0c1\ud0dc \uac80\uc99d \uc81c\uacf5\uc790 \uc785\ub2c8\ub2e4.");
            v25 = new INICoreException();
            v25.setErrorCode("940");
            throw v25;
        }
        return var0;
    }

    public static boolean isHSMCert(X509Certificate object) throws INICoreException {
        ExtKeyUsage extKeyUsage;
        if (object == null) {
            return false;
        }
        byte[] byArray = object.getExtensionValue("2.5.29.37");
        object = byArray;
        if (byArray == null) {
            INISAFECore.CoreLogger(3, "Extended key usage(2.5.29.37)\uac12\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            return false;
        }
        Object var1_2 = null;
        ExtKeyUsage extKeyUsage2 = extKeyUsage;
        try {
            extKeyUsage = new ExtKeyUsage((byte[])object);
        }
        catch (Exception exception) {
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            extKeyUsage2 = var1_2;
        }
        return extKeyUsage2.isProperUsage("1.2.410.200004.10.1.2");
    }

    public static String getCertOID(X509Certificate object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = object.getExtensionValue("2.5.29.32");
        object = byArray;
        if (byArray != null && ((Object)object).length != 0) {
            block6: {
                object = new CertificatePolicies((byte[])object).elements();
                if (!object.hasMoreElements()) break block6;
                try {
                    j = ((PolicyInfo)object.nextElement()).getPolicyID().getName().trim();
                    return j;
                }
                catch (Exception exception) {
                    INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c\uc5d0\uc11c OID\uac12\uc744 \uc77d\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                    LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                }
            }
            return null;
        }
        return null;
    }

    public static String[] getCertOIDs(X509Certificate object) {
        Vector<String> vector;
        Vector<String> vector2 = vector;
        vector = new Vector<String>();
        if (object == null) {
            return null;
        }
        byte[] byArray = object.getExtensionValue("2.5.29.32");
        object = byArray;
        if (byArray != null && ((Object)object).length != 0) {
            try {
                object = new CertificatePolicies((byte[])object).elements();
            }
            catch (Exception exception) {
                INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c\uc5d0\uc11c OID\uac12\uc744 \uc77d\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            }
            while (true) {
                if (!object.hasMoreElements()) break;
                vector2.addElement(((PolicyInfo)object.nextElement()).getPolicyID().getName().trim());
                continue;
                break;
            }
            return vector2.toArray(new String[0]);
        }
        return null;
    }

    public static void getX509ExtensionInfo(X509Certificate stringArray, HashMap hashMap) throws Exception {
        int n2;
        ExtKeyUsage extKeyUsage;
        byte[] byArray = stringArray.getExtensionValue("2.5.29.37");
        stringArray = (String[])byArray;
        if (byArray == null) {
            x509Extnull = null;
            return;
        }
        HashMap hashMap2 = hashMap;
        ExtKeyUsage extKeyUsage2 = extKeyUsage;
        try {
            extKeyUsage = new ExtKeyUsage((byte[])stringArray);
            sbufTxt = new StringBuffer();
            sbufOid = new StringBuffer();
            stringArray = hashMap2.keySet().toArray(new String[0]);
            n2 = 0;
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "\uc81c\ucd9c\ub41c \uc778\uc99d\uc11c\uc5d0\uc11c  \ud655\uc7a5 \ud0a4 \uc6a9\ub3c4(extKeyUsage)\uc744 \ucd94\ucd9c\ud558\ub294 \ub3c4\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception("an error occurred during extracting extKeyUsage from the user certificate." + exception.toString());
        }
        while (true) {
            block12: {
                block13: {
                    if (n2 >= stringArray.length) break;
                    if (!extKeyUsage2.isProperUsage(stringArray[n2])) break block12;
                    if (sbufTxt.length() <= 0) break block13;
                    sbufTxt.append(',');
                    sbufOid.append(',');
                }
                sbufTxt.append((String)hashMap.get(stringArray[n2]));
                sbufOid.append(stringArray[n2]);
            }
            ++n2;
        }
        return;
    }

    public static StringBuffer getKeyUsageText() {
        return sbufTxt;
    }

    public static StringBuffer getKeyUsageOID() {
        return sbufOid;
    }

    public static String getx509ExtensionObj() {
        return x509Extnull;
    }

    public static byte[] getSimplePublicKeyInfo(X509Certificate object) {
        object = ((Certificate)object).getPublicKey().getEncoded();
        byte[] byArray = null;
        try {
            byArray = new PublicKeyInfo((byte[])object).getPublicKeyAsByteArray();
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c\uc5d0\uc11c \uacf5\uac1c\ud0a4 \uc815\ubcf4\ub97c \uc77d\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.(\ucf54\uc2a4\ucf64 \ud3ec\ub9f7\uc758 \uacf5\uac1c\ud0a4 \uc815\ubcf4)");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
        }
        return byArray;
    }

    public static String getSubjectDN(X509Certificate object) {
        X509Certificate x509Certificate = object;
        object = null;
        try {
            object = ((Name)x509Certificate.getSubjectDN()).get("CN")[0];
        }
        catch (Exception exception) {}
        return object;
    }

    public static byte[] getAuthorityKeyIdentifierKeyID(X509Certificate x509Certificate) {
        try {
            return new AuthorityKeyIdentifier(x509Certificate.getExtensionValue("2.5.29.35")).getKID();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getSubjectKeyIdentifierKeyID(X509Certificate x509Certificate) {
        try {
            return new SubjectKeyIdentifier(x509Certificate.getExtensionValue("2.5.29.14")).getKID();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getCRLDistPoints(X509Certificate object) {
        Object object2;
        String string2;
        block10: {
            CRLDistPoints cRLDistPoints;
            string2 = "";
            object2 = cRLDistPoints;
            if (!new CRLDistPoints(object.getExtensionValue("2.5.29.31")).equals("")) break block10;
            return null;
        }
        try {
            object = object2.elements();
        }
        catch (Exception exception) {
            return null;
        }
        while (true) {
            if (!object.hasMoreElements()) break;
            object2 = ((DistPoint)object.nextElement()).getFullName();
            if (object2 == null) break;
            object2 = object2.elements();
            if (!object2.hasMoreElements()) continue;
            string2 = ((GeneralName)object2.nextElement()).toString();
            continue;
            break;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAuthorityInfoAccess(X509Certificate object) {
        X509CertImpl x509CertImpl;
        String string2 = null;
        String string3 = "1.3.6.1.5.5.7.1.1";
        String string4 = "1.3.6.1.5.5.7.48.1";
        X509CertImpl x509CertImpl2 = x509CertImpl;
        try {
            x509CertImpl2(((Certificate)object).getEncoded());
            if (x509CertImpl.getExtensionValue(string3) == null) return string2;
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            return null;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            certificateEncodingException.printStackTrace();
            return null;
        }
        try {
            object = new AuthorityInfoAccess(x509CertImpl2.getExtensionValue(string3)).elements();
        }
        catch (ASN1Exception aSN1Exception) {
            aSN1Exception.printStackTrace();
            return null;
        }
        do {
            if (!object.hasMoreElements()) return string2;
        } while (!(string3 = (AccessDescription)object.nextElement()).getMethod().equals((Object)string4));
        return string3.getName().toString();
    }

    static {
        sbufTxt = new StringBuffer();
        sbufOid = new StringBuffer();
    }

    public boolean checkOID(X509Certificate object, Properties properties) throws INICoreException, Exception {
        if (object != null) {
            byte[] byArray = object.getExtensionValue("2.5.29.32");
            object = byArray;
            if (byArray != null && ((Object)object).length > 0) {
                object = new CertificatePolicies((byte[])object).elements();
                while (object.hasMoreElements()) {
                    ASN1OID aSN1OID;
                    this.a = aSN1OID = ((PolicyInfo)object.nextElement()).getPolicyID();
                    j = aSN1OID.getName().trim();
                    if (properties.containsValue(j)) {
                        return true;
                    }
                    if (!properties.containsKey(j)) continue;
                    return true;
                }
                return false;
            }
            INISAFECore.CoreLogger(1, "Certificate Policies(2.5.29.32)\uac12\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            throw new INICoreException();
        }
        INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c \uac12\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        throw new INICoreException("certificate does not exist.");
    }

    public String getCertOID() {
        return j;
    }

    public boolean checkVID(X509Certificate x509Certificate, String string2, byte[] byArray) throws INICoreException, Exception {
        return this.checkVID(x509Certificate, string2.toCharArray(), byArray);
    }

    public boolean checkVID(X509Certificate x509Certificate, char[] object, byte[] object2) throws INICoreException, Exception {
        if (x509Certificate != null && !x509Certificate.equals("")) {
            if (object != null && ((char[])object).length != 0) {
                if (object2 != null && !object2.equals("")) {
                    boolean bl = false;
                    ((x509CertificateInfo)object5).e = object;
                    ((x509CertificateInfo)object5).f = Base64Util.decode(object2);
                    byte[] byArray = x509Certificate.getExtensionValue("2.5.29.17");
                    object = byArray;
                    if (byArray != null) {
                        object = new SubjectAltName((byte[])object).elements();
                        while (object.hasMoreElements()) {
                            VIDUserInfo vIDUserInfo;
                            GeneralName generalName = (GeneralName)object.nextElement();
                            object2 = generalName;
                            if (generalName.getType() != 0) continue;
                            AnotherName anotherName = (AnotherName)object2.getGeneralNameInterface();
                            object2 = anotherName;
                            if (!anotherName.getOID().equals((Object)"1.2.410.200004.10.1.1")) continue;
                            Object object3 = object2.getBytes();
                            IdentifyData identifyData = new IdentifyData();
                            try {
                                identifyData.decode((byte[])object3);
                                vIDUserInfo = identifyData.getUserInfo();
                            }
                            catch (ASN1Exception aSN1Exception) {
                                INISAFECore.CoreLogger(1, "ASN1 Decode exception occured");
                                LogUtil.writeStackTrace(INISAFECore.CoreLogger, (Exception)((Object)aSN1Exception));
                                throw new INICoreException("ASN1 Decode exception occured");
                            }
                            object3 = vIDUserInfo;
                            ((x509CertificateInfo)object5).b = object3;
                            if (vIDUserInfo != null) {
                                ((x509CertificateInfo)object5).c = object3 = ((VIDUserInfo)object3).getVID();
                                if (object3 != null) {
                                    ((x509CertificateInfo)object5).d = ((VID)object3).getHashAlgorithmID();
                                    if (((x509CertificateInfo)object5).d != null) {
                                        ((x509CertificateInfo)object5).h = ((x509CertificateInfo)object5).c.getHashedData();
                                        if (((x509CertificateInfo)object5).h != null) {
                                            bl = true;
                                            break;
                                        }
                                        throw new INICoreException("ASN1 Decode exception occured");
                                    }
                                    throw new INICoreException("ASN1 Decode exception occured");
                                }
                                throw new INICoreException("ASN1 Decode exception occured");
                            }
                            throw new INICoreException("ASN1 Decode exception occured");
                        }
                        if (((x509CertificateInfo)object5).b != null && ((x509CertificateInfo)object5).c != null) {
                            if (bl) {
                                VID vID;
                                DEREncoder dEREncoder;
                                x509CertificateInfo x509CertificateInfo2 = object5;
                                Object object4 = dEREncoder;
                                dEREncoder = new DEREncoder();
                                object = vID;
                                x509CertificateInfo x509CertificateInfo3 = object5;
                                ((VID)object)();
                                Object object5 = x509CertificateInfo3.e;
                                ((VID)object).setIDNAndRandom((char[])object5, x509CertificateInfo3.f);
                                try {
                                    vID.encode((ASN1Encoder)object4);
                                }
                                catch (Exception exception) {
                                    INISAFECore.CoreLogger(1, "ASN1 Encode exception occured");
                                    LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
                                    throw new INICoreException("ASN1 Encode exception occured");
                                }
                                object5 = dEREncoder.toByteArray();
                                MessageDigest messageDigest = MessageDigest.getInstance(x509CertificateInfo2.getVIDHashAlgorithm(), "Initech");
                                messageDigest.update((byte[])object5);
                                messageDigest.update(messageDigest.digest());
                                byte[] byArray2 = messageDigest.digest();
                                object5 = byArray2;
                                x509CertificateInfo2.g = byArray2;
                                object4 = x509CertificateInfo2.h;
                                return x509CertificateInfo2.h != null && ArrayComparator.equals((byte[])object4, (byte[])object5);
                            }
                            INISAFECore.CoreLogger(1, "This Certificate is existed SubjectAlternativeName extension but not existed extension for verification of  your identication");
                            throw new INICoreException("This Certificate is existed SubjectAlternativeName extension but not existed extension for verification of  your identication");
                        }
                        throw new INICoreException("an error occurred during the VID validation.");
                    }
                    INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c \ub0b4\uc5d0 SubjectAlternativeName(vid\ud655\uc778 \uc6a9)\uac12\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                    throw new INICoreException("SubjectAlternativeName for checking VID does not exist in the certificate.");
                }
                INISAFECore.CoreLogger(1, "\ubcf8\uc778\ud655\uc778\uc6a9 \ub79c\ub364\uac12\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                throw new INICoreException("a random value for checking id does not exist.");
            }
            INISAFECore.CoreLogger(1, "\uc8fc\ubbfc\ub4f1\ub85d \ubc88\ud638\uac12\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            throw new INICoreException("the identification value for checking id does not exist.");
        }
        INISAFECore.CoreLogger(1, "\uc778\uc99d\uc11c \uac12\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        throw new INICoreException("certificate does not exist.");
    }

    public String getVIDHashAlgorithm() {
        return this.d.getAlgName();
    }

    public String getIDNumber() {
        return new String(this.e);
    }

    public byte[] getVIDRandom() {
        return this.f;
    }

    public byte[] getTwiceHash() {
        return this.g;
    }

    public byte[] getVID() {
        return this.h;
    }
}

