/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cpv.crl.fetcher;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.GeneralName;
import com.initech.cpv.crl.fetcher.CRLDataTransporter;
import com.initech.cpv.crl.fetcher.TransportException;
import com.initech.cpv.crl.fetcher.TransporterFactory;
import com.initech.cpv.exception.CRLException;
import com.initech.cpv.util.Debug;
import com.initech.x509.extensions.CRLDistPoints;
import com.initech.x509.extensions.DistPoint;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class CRLFetcher {
    public static Map getCRLMap(X509Certificate serializable) throws TransportException, CRLException {
        HashMap hashMap;
        X509Certificate x509Certificate = serializable;
        serializable = hashMap;
        hashMap = new HashMap();
        Object object = x509Certificate.getExtensionValue("2.5.29.31");
        try {
            object = new CRLDistPoints((byte[])object).elements();
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.handleException((Exception)((Object)aSN1Exception));
            throw new CRLException((Exception)((Object)aSN1Exception));
        }
        block4: while (object.hasMoreElements()) {
            DistPoint distPoint = (DistPoint)object.nextElement();
            Enumeration enumeration = distPoint.getFullName().elements();
            while (object.hasMoreElements()) {
                try {
                    ((HashMap)serializable).put(distPoint, CRLFetcher.getCRL(((GeneralName)enumeration.nextElement()).toString(), false));
                }
                catch (Exception exception) {
                    Debug.handleException(exception);
                    continue;
                }
                continue block4;
            }
        }
        return serializable;
    }

    public static X509CRL[] getCRL(X509Certificate x509Certificate) throws TransportException, CRLException {
        return CRLFetcher.getCRLMap(x509Certificate).values().toArray(new X509CRL[0]);
    }

    public static X509CRL getCRLByDirectoryName(String string2, String string3, boolean bl) throws TransportException {
        CRLDataTransporter cRLDataTransporter = TransporterFactory.getInstance(string3 + "/" + string2);
        cRLDataTransporter.setForDeltaCrl(bl);
        return cRLDataTransporter.getCRL();
    }

    public static X509CRL getCRL(String string2, boolean bl) throws TransportException {
        CRLDataTransporter cRLDataTransporter = TransporterFactory.getInstance(string2);
        cRLDataTransporter.setForDeltaCrl(bl);
        return cRLDataTransporter.getCRL();
    }
}

