/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger;

import com.initech.inibase.logger.Appender;
import com.initech.inibase.logger.Layout;
import com.initech.inibase.logger.Priority;
import com.initech.inibase.logger.helpers.LogLog;
import com.initech.inibase.logger.helpers.OnlyOnceErrorHandler;
import com.initech.inibase.logger.spi.ErrorHandler;
import com.initech.inibase.logger.spi.Filter;
import com.initech.inibase.logger.spi.LoggingEvent;
import com.initech.inibase.logger.spi.OptionHandler;

public abstract class AppenderSkeleton
implements Appender,
OptionHandler {
    public Layout layout;
    public String name;
    public Priority threshold;
    public ErrorHandler errorHandler;
    public Filter headFilter;
    public Filter tailFilter;
    public boolean closed;

    public AppenderSkeleton() {
        OnlyOnceErrorHandler onlyOnceErrorHandler;
        OptionHandler optionHandler = onlyOnceErrorHandler;
        onlyOnceErrorHandler = new OnlyOnceErrorHandler();
        v1.errorHandler = optionHandler;
        v1.closed = false;
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public void addFilter(Filter filter) {
        if (this.headFilter == null) {
            AppenderSkeleton appenderSkeleton = this;
            appenderSkeleton.tailFilter = filter;
            appenderSkeleton.headFilter = filter;
            return;
        }
        this.tailFilter.next = filter;
        this.tailFilter = filter;
    }

    public abstract void append(LoggingEvent var1);

    @Override
    public void clearFilters() {
        AppenderSkeleton appenderSkeleton = this;
        appenderSkeleton.tailFilter = null;
        appenderSkeleton.headFilter = null;
    }

    public void finalize() {
        if (this.closed) {
            return;
        }
        LogLog.debug("Finalizing appender named [" + this.name + "].");
        this.close();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Filter getFilter() {
        return this.headFilter;
    }

    public final Filter getFirstFilter() {
        return this.headFilter;
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public Priority getThreshold() {
        return this.threshold;
    }

    public boolean isAsSevereAsThreshold(Priority priority) {
        Priority priority2 = ((AppenderSkeleton)((Object)priority2)).threshold;
        return priority2 == null || priority.isGreaterOrEqual(priority2);
        {
        }
    }

    @Override
    public synchronized void doAppend(LoggingEvent loggingEvent) {
        if (this.closed) {
            LogLog.error("Attempted to append to closed appender named [" + this.name + "].");
            return;
        }
        if (!this.isAsSevereAsThreshold(loggingEvent.getLevel())) {
            return;
        }
        Filter filter = this.headFilter;
        while (filter != null) {
            int n2 = filter.decide(loggingEvent);
            if (n2 != -1) {
                if (n2 != 0) {
                    if (n2 == 1) break;
                    continue;
                }
                filter = filter.next;
                continue;
            }
            return;
        }
        this.append(loggingEvent);
    }

    @Override
    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            LogLog.warn("You have tried to set a null error-handler.");
            return;
        }
        this.errorHandler = errorHandler;
    }

    @Override
    public void setLayout(Layout layout2) {
        this.layout = layout2;
    }

    @Override
    public void setName(String string2) {
        this.name = string2;
    }

    public void setThreshold(Priority priority) {
        this.threshold = priority;
    }
}

