/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger.helpers;

import com.initech.inibase.logger.spi.ErrorHandler;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class QuietWriter
extends FilterWriter {
    public ErrorHandler errorHandler;

    public QuietWriter(Writer writer, ErrorHandler errorHandler) {
        QuietWriter quietWriter = this;
        super(writer);
        quietWriter.setErrorHandler(errorHandler);
    }

    @Override
    public void write(String string2) {
        try {
            this.out.write(string2);
            return;
        }
        catch (IOException iOException) {
            this.errorHandler.error("Failed to write [" + string2 + "].", iOException, 1);
            return;
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
            return;
        }
        catch (IOException iOException) {
            this.errorHandler.error("Failed to flush writer,", iOException, 2);
            return;
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
            return;
        }
        throw new IllegalArgumentException("Attempted to set null ErrorHandler.");
    }
}

