/*
 * Decompiled with CFR 0.152.
 */
package com.initech.keystore;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.BEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.IssuerAndSerialNumber;
import com.initech.cryptox.SecretKey;
import com.initech.keystore.EnhancedKeyStoreException;
import com.initech.keystore.EnhancedKeyStoreSpi;
import com.initech.keystore.initechKeyStore.InitechKeyStore;
import com.initech.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import com.initech.provider.crypto.InitechProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Date;

public class EnhancedKeyStore {
    public static final int PUBLIC_KEY_ENTRY = 0;
    public static final int TRUSTED_CERT = 1;
    public static final int SECRET_KEY_ENTRY = 2;
    public EnhancedKeyStoreSpi a;

    public EnhancedKeyStore(EnhancedKeyStoreSpi enhancedKeyStoreSpi) {
        this.a = enhancedKeyStoreSpi;
    }

    public static EnhancedKeyStore getInstance(String object) throws NoSuchAlgorithmException {
        block4: {
            InitechKeyStore initechKeyStore;
            try {
                if (Security.getProviders().length <= 0) break block4;
            }
            catch (Exception exception) {}
            object = initechKeyStore;
            initechKeyStore = new InitechKeyStore();
            return new EnhancedKeyStore((EnhancedKeyStoreSpi)object);
        }
        throw new NoSuchAlgorithmException("No Such EnhancedKeyStore algorithm");
    }

    public static EnhancedKeyStore getInstance(String object, String object2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if ((object2 = Security.getProvider((String)object2)) != null) {
            try {
                object = (EnhancedKeyStoreSpi)InitechProvider.getImplementation((String)object, (String)"EnhancedKeyStore", (Provider)object2);
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("No Such EnhancedKeyStore algorithm");
            }
            return new EnhancedKeyStore((EnhancedKeyStoreSpi)object);
        }
        throw new NoSuchProviderException("No Such Provider");
    }

    public final String getType() {
        return this.a.getType();
    }

    public boolean containsAlias(String string2) {
        return this.a.containsAlias(string2);
    }

    public String getCertificateAlias(Certificate certificate) {
        return this.a.getCertificateAlias(certificate);
    }

    public int getSize() {
        return this.a.getSize();
    }

    public int getPrivateKeySize() {
        return this.a.getPrivateKeySize();
    }

    public int getCertificateSize() {
        return this.a.getCertificateSize();
    }

    public int getSecretKeySize() {
        return this.a.getSecretKeySize();
    }

    public Date getCreationDate(String string2) {
        return this.a.getCreationDate(string2);
    }

    public Date getPrivateKeyCreationDate(byte[] byArray) {
        return this.a.getPrivateKeyCreationDate(byArray);
    }

    public Date getPrivateKeyCreationDate(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.a.getPrivateKeyCreationDate(issuerAndSerialNumber);
    }

    public Date getCertificateCreationDate(byte[] byArray) {
        return this.a.getCertificateCreationDate(byArray);
    }

    public Date getCertificateCreationDate(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.a.getCertificateCreationDate(issuerAndSerialNumber);
    }

    public Date getSecretKeyCreationDate(byte[] byArray) {
        return this.a.getSecretKeyCreationDate(byArray);
    }

    public void setMacAlgorithm(AlgorithmID algorithmID) {
        this.a.setMacAlgorithm(algorithmID);
    }

    public AlgorithmID getMacAlgorithm() {
        return this.a.getMacAlgorithm();
    }

    public String[] getAliasList() {
        return this.a.getAliasList();
    }

    public String[] getAliasList(int n2) {
        return this.a.getAliasList(n2);
    }

    public int getAliasType(String string2) {
        return this.a.getAliasType(string2);
    }

    public PrivateKey getPrivateKey(String string2, char[] cArray) throws EnhancedKeyStoreException {
        return this.a.getPrivateKey(string2, cArray);
    }

    public PrivateKey getPrivateKey(IssuerAndSerialNumber issuerAndSerialNumber, char[] cArray) throws EnhancedKeyStoreException {
        return this.a.getPrivateKey(issuerAndSerialNumber, cArray);
    }

    public PrivateKey getPrivateKey(byte[] byArray, char[] cArray) throws EnhancedKeyStoreException {
        return this.a.getPrivateKey(byArray, cArray);
    }

    public Certificate[] getCertChain(String string2) {
        return this.a.getCertChain(string2);
    }

    public Certificate[] getCertChain(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.a.getCertChain(issuerAndSerialNumber);
    }

    public Certificate[] getCertChain(byte[] byArray) {
        return this.a.getCertChain(byArray);
    }

    public Certificate getCertificate(String string2) {
        return this.a.getCertificate(string2);
    }

    public Certificate getCertificate(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.a.getCertificate(issuerAndSerialNumber);
    }

    public Certificate getCertificate(byte[] byArray) {
        return this.a.getCertificate(byArray);
    }

    public SecretKey getSecretKey(String string2, char[] cArray) throws EnhancedKeyStoreException {
        return this.a.getSecretKey(string2, cArray);
    }

    public SecretKey getSecretKey(byte[] byArray, char[] cArray) throws EnhancedKeyStoreException {
        return this.a.getSecretKey(byArray, cArray);
    }

    public boolean remove(String string2) {
        return this.a.remove(string2);
    }

    public boolean removePrivateKey(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.a.removePrivateKey(issuerAndSerialNumber);
    }

    public boolean removePrivateKey(byte[] byArray) {
        return this.a.removePrivateKey(byArray);
    }

    public boolean removeCertificate(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.a.removeCertificate(issuerAndSerialNumber);
    }

    public boolean removeCertificate(byte[] byArray) {
        return this.a.removeCertificate(byArray);
    }

    public boolean removeSecretKey(byte[] byArray) {
        return this.a.removeSecretKey(byArray);
    }

    public boolean add(PrivateKey privateKey, Certificate[] certificateArray, AlgorithmID algorithmID, char[] cArray, String string2) throws EnhancedKeyStoreException {
        return this.a.add(privateKey, certificateArray, algorithmID, cArray, string2);
    }

    public boolean add(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateArray, String string2) {
        return this.a.add(encryptedPrivateKeyInfo, certificateArray, string2);
    }

    public boolean add(Certificate certificate, String string2) {
        return this.a.add(certificate, string2);
    }

    public boolean add(SecretKey secretKey, byte[] byArray, AlgorithmID algorithmID, char[] cArray, String string2) throws EnhancedKeyStoreException {
        return this.a.add(secretKey, byArray, algorithmID, cArray, string2);
    }

    public boolean add(byte[] byArray, byte[] byArray2, AlgorithmID algorithmID, String string2) {
        return this.a.add(byArray, byArray2, algorithmID, string2);
    }

    public Object getImplimentation() {
        return this.a.getImplimentation();
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        this.a.encode(aSN1Encoder);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        this.a.decode(aSN1Decoder);
    }

    public boolean load(InputStream inputStream, char[] cArray) throws IOException {
        try {
            EnhancedKeyStore enhancedKeyStore = this;
            enhancedKeyStore.decode((ASN1Decoder)new BERDecoder(inputStream));
            return enhancedKeyStore.a.verify(cArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public void store(OutputStream outputStream, char[] cArray) throws IOException {
        try {
            EnhancedKeyStore enhancedKeyStore = this;
            enhancedKeyStore.a.mac(cArray);
            enhancedKeyStore.encode((ASN1Encoder)new BEREncoder(outputStream));
            return;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }
}

