/*
 * Decompiled with CFR 0.152.
 */
package com.initech.license.crypto;

import com.initech.license.crypto.CryptoException;
import com.initech.license.crypto.Key;
import com.initech.license.crypto.PKCS8PrivateKeyInfo;
import com.initech.license.crypto.RSAPublicKey;
import com.initech.license.crypto.asn1.ASN1;
import com.initech.license.crypto.asn1.ASN1Exception;
import com.initech.license.crypto.asn1.ASN1Info;
import com.initech.license.crypto.asn1.AlgorithmID;
import com.initech.license.crypto.asn1.Attribute;
import com.initech.license.crypto.asn1.INTEGER;
import com.initech.license.crypto.asn1.SEQUENCE;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class RSAPrivateKey
extends PKCS8PrivateKeyInfo
implements Key {
    public static final BigInteger o = BigInteger.valueOf(0L);
    public static final BigInteger p = BigInteger.valueOf(1L);
    public transient ASN1Info e;
    public int f;
    public BigInteger g;
    public BigInteger h;
    public BigInteger i;
    public BigInteger j;
    public BigInteger k;
    public BigInteger l;
    public BigInteger m;
    public BigInteger n;

    public RSAPrivateKey() {
    }

    public RSAPrivateKey(byte[] byArray) throws CryptoException {
        super(byArray);
    }

    public RSAPrivateKey(InputStream inputStream) throws IOException, CryptoException {
        super(inputStream);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        RSAPrivateKey rSAPrivateKey = this;
        Object object = this = o;
        rSAPrivateKey(bigInteger, (BigInteger)this, bigInteger2, (BigInteger)object, (BigInteger)object, (BigInteger)object, (BigInteger)object, (BigInteger)object);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.g = bigInteger;
        this.l = bigInteger2;
        this.h = bigInteger3;
        this.i = bigInteger4;
        this.j = bigInteger5;
        if (bigInteger4.compareTo(bigInteger5) < 0) {
            RSAPrivateKey rSAPrivateKey = this;
            bigInteger = rSAPrivateKey.i;
            rSAPrivateKey.i = bigInteger2 = rSAPrivateKey.j;
            rSAPrivateKey.j = bigInteger;
            bigInteger = p;
            rSAPrivateKey.m = rSAPrivateKey.h.mod(bigInteger2.subtract(bigInteger));
            rSAPrivateKey.m = rSAPrivateKey.h.mod(this.j.subtract(bigInteger));
            rSAPrivateKey.k = rSAPrivateKey.i.modInverse(this.j);
        } else {
            RSAPrivateKey rSAPrivateKey = this;
            rSAPrivateKey.m = bigInteger6;
            rSAPrivateKey.n = bigInteger7;
            rSAPrivateKey.k = bigInteger8;
        }
        this.a();
    }

    public RSAPrivateKey(ASN1 aSN1) throws CryptoException {
        super(aSN1);
    }

    public static RSAPrivateKey parse(byte[] byArray) throws CryptoException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        rSAPrivateKey.decode(byArray);
        rSAPrivateKey.a();
        return rSAPrivateKey;
    }

    @Override
    private void a() {
        SEQUENCE sEQUENCE;
        RSAPrivateKey rSAPrivateKey;
        try {
            RSAPrivateKey rSAPrivateKey2 = this;
            rSAPrivateKey = rSAPrivateKey2;
            RSAPrivateKey rSAPrivateKey3 = rSAPrivateKey2;
            RSAPrivateKey rSAPrivateKey4 = rSAPrivateKey2;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new RuntimeException(aSN1Exception.toString());
        }
        SEQUENCE sEQUENCE2 = sEQUENCE;
        new SEQUENCE().addComponent(new INTEGER(this.f));
        sEQUENCE2.addComponent(new INTEGER(this.g));
        sEQUENCE2.addComponent(new INTEGER(this.l));
        sEQUENCE2.addComponent(new INTEGER(this.h));
        sEQUENCE2.addComponent(new INTEGER(this.i));
        sEQUENCE2.addComponent(new INTEGER(this.j));
        sEQUENCE2.addComponent(new INTEGER(this.m));
        sEQUENCE2.addComponent(new INTEGER(this.n));
        sEQUENCE2.addComponent(new INTEGER(this.k));
        rSAPrivateKey3.e = new ASN1Info(sEQUENCE2);
        rSAPrivateKey4.privateKeyAlgorithm = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
        rSAPrivateKey.createPrivateKeyInfo();
    }

    public BigInteger crypt(BigInteger bigInteger) {
        if (((RSAPrivateKey)((Object)bigInteger2)).i.bitCount() == 0) {
            RSAPrivateKey rSAPrivateKey = bigInteger2;
            BigInteger bigInteger2 = rSAPrivateKey.h;
            return bigInteger.modPow(bigInteger2, rSAPrivateKey.g);
        }
        BigInteger bigInteger3 = bigInteger2;
        BigInteger bigInteger4 = ((RSAPrivateKey)((Object)bigInteger3)).m;
        BigInteger bigInteger5 = bigInteger.mod(((RSAPrivateKey)((Object)bigInteger2)).i).modPow(bigInteger4, ((RSAPrivateKey)((Object)bigInteger3)).i);
        BigInteger bigInteger6 = bigInteger.mod(((RSAPrivateKey)((Object)bigInteger2)).j);
        Object object = bigInteger2;
        bigInteger = ((RSAPrivateKey)object).n;
        bigInteger4 = bigInteger5.subtract(bigInteger = bigInteger6.modPow(bigInteger, ((RSAPrivateKey)object).j));
        if (bigInteger4.signum() < 0) {
            bigInteger4 = bigInteger4.add(((RSAPrivateKey)((Object)bigInteger2)).i);
        }
        return bigInteger4.multiply(((RSAPrivateKey)((Object)bigInteger2)).k).mod(((RSAPrivateKey)((Object)bigInteger2)).i).multiply(((RSAPrivateKey)((Object)bigInteger2)).j).add(bigInteger);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void decode(byte[] object) throws CryptoException {
        RSAPrivateKey rSAPrivateKey;
        RSAPrivateKey rSAPrivateKey2;
        RSAPrivateKey rSAPrivateKey3;
        RSAPrivateKey rSAPrivateKey4;
        RSAPrivateKey rSAPrivateKey5;
        RSAPrivateKey rSAPrivateKey6;
        RSAPrivateKey rSAPrivateKey7;
        RSAPrivateKey rSAPrivateKey8;
        RSAPrivateKey rSAPrivateKey9;
        try {
            RSAPrivateKey rSAPrivateKey10 = this;
            RSAPrivateKey rSAPrivateKey11 = rSAPrivateKey10;
            rSAPrivateKey9 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey12 = rSAPrivateKey10;
            rSAPrivateKey8 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey13 = rSAPrivateKey10;
            rSAPrivateKey7 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey14 = rSAPrivateKey10;
            rSAPrivateKey6 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey15 = rSAPrivateKey10;
            rSAPrivateKey5 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey16 = rSAPrivateKey10;
            rSAPrivateKey4 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey17 = rSAPrivateKey10;
            rSAPrivateKey3 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey18 = rSAPrivateKey10;
            rSAPrivateKey2 = rSAPrivateKey10;
            RSAPrivateKey rSAPrivateKey19 = rSAPrivateKey10;
            rSAPrivateKey = rSAPrivateKey10;
        }
        catch (Exception exception) {
            throw new CryptoException("RSA \ube44\ubc00\ud0a4\uac00 \uc544\ub2d9\ub2c8\ub2e4: " + exception.toString());
        }
        this.e = new ASN1Info((byte[])object);
        rSAPrivateKey18.f = ((BigInteger)this.e.getComponentAt(0).getValue()).intValue();
        rSAPrivateKey19.g = (BigInteger)rSAPrivateKey2.e.getComponentAt(1).getValue();
        rSAPrivateKey17.l = (BigInteger)rSAPrivateKey.e.getComponentAt(2).getValue();
        rSAPrivateKey16.h = (BigInteger)rSAPrivateKey3.e.getComponentAt(3).getValue();
        rSAPrivateKey15.i = (BigInteger)rSAPrivateKey4.e.getComponentAt(4).getValue();
        rSAPrivateKey14.j = (BigInteger)rSAPrivateKey5.e.getComponentAt(5).getValue();
        rSAPrivateKey13.m = (BigInteger)rSAPrivateKey6.e.getComponentAt(6).getValue();
        rSAPrivateKey12.n = (BigInteger)rSAPrivateKey7.e.getComponentAt(7).getValue();
        rSAPrivateKey11.k = (BigInteger)rSAPrivateKey8.e.getComponentAt(8).getValue();
        if (rSAPrivateKey9.i.compareTo(this.j) >= 0) return;
        RSAPrivateKey rSAPrivateKey20 = this;
        RSAPrivateKey rSAPrivateKey21 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey22 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey23 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey24 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey25 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey26 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey27 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey28 = rSAPrivateKey20;
        RSAPrivateKey rSAPrivateKey29 = rSAPrivateKey20;
        BigInteger bigInteger = rSAPrivateKey20.i;
        BigInteger bigInteger2 = rSAPrivateKey27.j;
        rSAPrivateKey28.i = bigInteger2;
        rSAPrivateKey29.j = bigInteger;
        BigInteger bigInteger3 = rSAPrivateKey25.h;
        BigInteger bigInteger4 = bigInteger2;
        BigInteger bigInteger5 = p;
        rSAPrivateKey26.m = bigInteger3.mod(bigInteger4.subtract(bigInteger5));
        rSAPrivateKey24.m = rSAPrivateKey23.h.mod(this.j.subtract(bigInteger5));
        rSAPrivateKey22.k = rSAPrivateKey21.i.modInverse(this.j);
    }

    @Override
    public byte[] encode() {
        return this.e.toByteArray();
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getCrtCoefficient() {
        return this.k;
    }

    public BigInteger getModulus() {
        return this.g;
    }

    public BigInteger getPrimeExponentP() {
        return this.m;
    }

    public BigInteger getPrimeExponentQ() {
        return this.n;
    }

    public BigInteger getPrimeP() {
        return this.i;
    }

    public BigInteger getPrimeQ() {
        return this.j;
    }

    public BigInteger getPrivateExponent() {
        return this.h;
    }

    public BigInteger getPublicExponent() {
        return this.l;
    }

    public RSAPublicKey getPublicKey() {
        RSAPrivateKey rSAPrivateKey = bigInteger;
        BigInteger bigInteger = rSAPrivateKey.g;
        return new RSAPublicKey(bigInteger, rSAPrivateKey.l);
    }

    public int hashCode() {
        return this.g.hashCode() ^ this.l.hashCode() ^ this.h.hashCode() ^ this.i.hashCode() ^ this.j.hashCode() ^ this.m.hashCode() ^ this.m.hashCode() ^ this.k.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("\ubaa8\ub4c8\ub7ec\uc2a4(modulus) [N]: " + attributeArray.g.toString(16) + "\n");
        stringBuffer2.append("\uacf5\uac1c \uc9c0\uc218(public exponent) [E]: " + attributeArray.l.toString(16) + "\n");
        stringBuffer2.append("\ube44\ubc00 \uc9c0\uc218(private exponent) [D]: " + attributeArray.h.toString(16) + "\n");
        stringBuffer2.append("1\ucc28 \uc18c\uc218(primeP) [P]: " + attributeArray.i.toString(16) + "\n");
        stringBuffer2.append("2\ucc28 \uc18c\uc218(primeQ) [Q]: " + attributeArray.j.toString(16) + "\n");
        stringBuffer2.append("1\ucc28 \uc18c\uc218 \uc9c0\uc218(primeExponentP) [EP]: " + attributeArray.m.toString(16) + "\n");
        stringBuffer2.append("2\ucc28 \uc18c\uc218 \uc9c0\uc218(primeExponentQ) [EQ]: " + attributeArray.n.toString(16) + "\n");
        stringBuffer2.append("CRT \uacc4\uc218(crt coefficient) [U]: " + attributeArray.k.toString(16) + "\n");
        if (attributeArray.getAttributes() != null) {
            stringBuffer2.append("Attributes ===>\n");
            Attribute[] attributeArray = attributeArray.getAttributes();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2("\t");
                stringBuffer2.append(stringBuilder.append(attributeArray[i2]).append("\n").toString());
            }
        }
        return stringBuffer2.toString();
    }
}

