/*
 * Decompiled with CFR 0.152.
 */
package com.initech.license.crypto;

import com.initech.license.crypto.CryptoException;
import com.initech.license.crypto.Key;
import com.initech.license.crypto.X509PublicKeyInfo;
import com.initech.license.crypto.asn1.ASN1;
import com.initech.license.crypto.asn1.ASN1Exception;
import com.initech.license.crypto.asn1.ASN1Info;
import com.initech.license.crypto.asn1.AlgorithmID;
import com.initech.license.crypto.asn1.Constructed;
import com.initech.license.crypto.asn1.INTEGER;
import com.initech.license.crypto.asn1.SEQUENCE;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class RSAPublicKey
extends X509PublicKeyInfo
implements Key {
    public ASN1Info b;
    public BigInteger c;
    public BigInteger d;

    public RSAPublicKey(byte[] byArray) throws CryptoException {
        super(byArray);
    }

    public RSAPublicKey(InputStream inputStream) throws IOException, CryptoException {
        super(inputStream);
    }

    public RSAPublicKey(BigInteger object, BigInteger bigInteger) {
        SEQUENCE sEQUENCE;
        this.c = object;
        this.d = bigInteger;
        object = sEQUENCE;
        try {
            new SEQUENCE().addComponent(new INTEGER(this.c));
            ((Constructed)object).addComponent(new INTEGER(this.d));
            this.b = new ASN1Info((ASN1)object);
            this.publicKeyAlgorithm = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
            this.createPublicKeyInfo();
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new RuntimeException(aSN1Exception.toString());
        }
    }

    public RSAPublicKey(ASN1 aSN1) throws CryptoException {
        super(aSN1);
    }

    public BigInteger crypt(BigInteger bigInteger) {
        RSAPublicKey rSAPublicKey = bigInteger2;
        BigInteger bigInteger2 = rSAPublicKey.d;
        return bigInteger.modPow(bigInteger2, rSAPublicKey.c);
    }

    @Override
    public void decode(byte[] byArray) throws CryptoException {
        RSAPublicKey rSAPublicKey;
        try {
            RSAPublicKey rSAPublicKey2 = this;
            RSAPublicKey rSAPublicKey3 = rSAPublicKey2;
            RSAPublicKey rSAPublicKey4 = rSAPublicKey2;
            rSAPublicKey = rSAPublicKey2;
        }
        catch (Exception exception) {
            throw new CryptoException("RSA \uacf5\uac1c\ud0a4\uac00 \uc544\ub2d9\ub2c8\ub2e4: " + exception.toString());
        }
        this.b = new ASN1Info(byArray);
        rSAPublicKey4.c = (BigInteger)this.b.getComponentAt(0).getValue();
        rSAPublicKey3.d = (BigInteger)rSAPublicKey.b.getComponentAt(1).getValue();
    }

    @Override
    public byte[] encode() {
        return this.b.toByteArray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RSAPublicKey)) {
            return false;
        }
        object = (RSAPublicKey)object;
        return this.c.equals(((RSAPublicKey)object).c) && this.d.equals(((RSAPublicKey)object).d);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getFingerprint() {
        return this.b.getFingerprint();
    }

    public BigInteger getModulus() {
        return this.c;
    }

    public BigInteger getPublicExponent() {
        return this.d;
    }

    public int hashCode() {
        return this.d.hashCode() ^ this.c.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\uacf5\uac1c \uc9c0\uc218(public exponent) [E]: " + this.d.toString(16) + "\n");
        stringBuffer.append("\ubaa8\ub4c8\ub7ec\uc2a4(modulus) [N]: " + this.c.toString(16) + "\n");
        return stringBuffer.toString();
    }
}

