/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs11;

import com.initech.pkcs.pkcs11.Mechanism;
import com.initech.pkcs.pkcs11.MechanismInfo;
import com.initech.pkcs.pkcs11.PKCS11;
import com.initech.pkcs.pkcs11.PKCS11Exception;
import com.initech.pkcs.pkcs11.Session;
import com.initech.pkcs.pkcs11.TokenInfo;
import java.io.UnsupportedEncodingException;

public class Token {
    public PKCS11 module;
    public long slotID;
    public boolean alwaysSensitive;

    public Token(PKCS11 pKCS11, long l2) {
        this.module = pKCS11;
        this.slotID = l2;
    }

    public boolean equals(Object object) {
        if (object instanceof Token) {
            object = (Token)object;
            if (this.slotID != ((Token)object).slotID) {
                return false;
            }
            return this.module.equals(((Token)object).module);
        }
        return false;
    }

    public void initToken(byte[] byArray, String string2) throws PKCS11Exception {
        long l2;
        String string3;
        PKCS11 pKCS11;
        try {
            pKCS11 = ((Token)object).module;
            string3 = string2;
            l2 = ((Token)object).slotID;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        Object object = string3.getBytes("UTF8");
        pKCS11.C_InitToken(l2, byArray, (byte[])object);
    }

    public Mechanism[] getMechanismList() throws PKCS11Exception {
        long[] lArray = ((Token)object).module.C_GetMechanismList(((Token)object).slotID);
        Object object = lArray;
        Mechanism[] mechanismArray = new Mechanism[lArray.length];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Mechanism mechanism;
            Mechanism mechanism2 = mechanism;
            mechanism = new Mechanism((long)object[i2]);
            mechanismArray[i2] = mechanism2;
        }
        return mechanismArray;
    }

    public MechanismInfo getMechanismInfo(Mechanism mechanism) throws PKCS11Exception {
        long l2 = this.slotID;
        long l3 = mechanism.getMechanismCode();
        return new MechanismInfo(this.module.C_GetMechanismInfo(l2, l3));
    }

    public long getSlotID() {
        return this.slotID;
    }

    public TokenInfo getTokenInfo() throws PKCS11Exception {
        return new TokenInfo(this.module.C_GetTokenInfo(this.slotID));
    }

    public String toString() {
        return null;
    }

    public Session openSession(boolean bl, boolean bl2) throws PKCS11Exception {
        long l2 = 0L;
        if (bl) {
            l2 = 4L;
        }
        if (bl2) {
            l2 |= 2L;
        }
        long l3 = this.module.C_OpenSession(this.slotID, l2, null, null);
        return new Session(this.module, this, l3);
    }

    public void closeAllSessions() throws PKCS11Exception {
        this.module.C_CloseAllSessions(this.slotID);
    }

    public void setAlwaysSensitive(boolean bl) {
        this.alwaysSensitive = bl;
    }

    public boolean isAlwaysSensitive() {
        return this.alwaysSensitive;
    }

    public int hashCode() {
        long l2 = this.slotID;
        return (int)((l2 + 1L) * (l2 + 1L) * (long)this.module.hashCode());
    }

    public void finalize() throws Throwable {
        this.module = null;
    }
}

