/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkix.cmp.crmf;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.GeneralName;
import com.initech.pkix.cmp.client.USIMAdapter;
import com.initech.pkix.cmp.crmf.AuthInfo;
import com.initech.pkix.cmp.crmf.PKMACValue;
import com.initech.pkix.cmp.crmf.POPOPrivKey;
import com.initech.pkix.cmp.crmf.POPOSigningKey;
import com.initech.pkix.cmp.crmf.POPOSigningKeyInput;
import com.initech.provider.crypto.rsa.RSAAutoSignature;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class ProofOfPossession
implements ASN1Type {
    public static final int SUBSEQMSG_ENC_CERT = 0;
    public static final int SUBSEQMSG_CHALLENGE_RESP = 1;
    public static final int RA_VERIFIED = 0;
    public static final int SIGNATURE = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int KEY_AGREEMENT = 3;
    public static final int POP_KEY_ENCIPHERMENT = 2;
    public static final int POP_KEY_AGREEMENT = 3;
    public static int[] d = new int[]{128, 161, 162, 163};
    public int a = -1;
    public POPOSigningKey b;
    public POPOPrivKey c;

    public ProofOfPossession() {
        POPOPrivKey pOPOPrivKey;
        POPOSigningKey pOPOSigningKey;
        Object object = pOPOSigningKey;
        pOPOSigningKey = new POPOSigningKey();
        v1.b = object;
        object = pOPOPrivKey;
        pOPOPrivKey = new POPOPrivKey();
        v1.c = object;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        aSN1Encoder.encodeChoice(0, d);
        int n2 = ((ProofOfPossession)object).a;
        if (n2 == 0) {
            ASN1Encoder aSN1Encoder2 = aSN1Encoder;
            aSN1Encoder2.nextIsImplicit(ASN1Tag.makeContextTag((int)n2));
            aSN1Encoder2.encodeNull();
            return;
        }
        if (n2 == 1) {
            ASN1Encoder aSN1Encoder3 = aSN1Encoder;
            ProofOfPossession proofOfPossession = object;
            Object object = proofOfPossession.b.getEncoded();
            aSN1Encoder3.nextIsImplicit(ASN1Tag.makeContextTag((int)proofOfPossession.a));
            aSN1Encoder3.encodeAny((byte[])object);
            return;
        }
        if (n2 != 2 && n2 != 3) {
            throw new ASN1Exception("Unexpected Choice Alternative: " + ((ProofOfPossession)object).a);
        }
        ASN1Encoder aSN1Encoder4 = aSN1Encoder;
        int n3 = aSN1Encoder4.encodeExplicit(ASN1Tag.makeExplicitTag((int)n2));
        ((ProofOfPossession)object).c.encode(aSN1Encoder);
        aSN1Encoder4.endOf(n3);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        int n2 = aSN1Decoder.decodeChoice(d);
        if (n2 != 0) {
            int[] nArray = d;
            if (n2 == d[0]) {
                ASN1Decoder aSN1Decoder2 = aSN1Decoder;
                aSN1Decoder2.nextIsImplicit(n2);
                aSN1Decoder2.decodeNull();
                this.a = 0;
                return;
            }
            if (n2 == nArray[1]) {
                aSN1Decoder.nextIsImplicit(n2);
                this.b.decode(aSN1Decoder);
                this.a = 1;
                return;
            }
            if (n2 == nArray[2]) {
                ASN1Decoder aSN1Decoder3 = aSN1Decoder;
                int n3 = aSN1Decoder3.decodeExplicit(n2);
                this.c.decode(aSN1Decoder);
                aSN1Decoder3.endOf(n3);
                this.a = 2;
                return;
            }
            ASN1Decoder aSN1Decoder4 = aSN1Decoder;
            int n4 = aSN1Decoder4.decodeExplicit(n2);
            this.c.decode(aSN1Decoder);
            aSN1Decoder4.endOf(n4);
            this.a = 3;
            return;
        }
        throw new ASN1Exception("Unexpected tag");
    }

    public int getPOPType() {
        return this.a;
    }

    public PublicKey getPublicKey() {
        POPOSigningKeyInput pOPOSigningKeyInput;
        if (this.a == 1 && (pOPOSigningKeyInput = this.b.ski) != null) {
            return pOPOSigningKeyInput.pubki.getPublicKey();
        }
        return null;
    }

    public AuthInfo getAuthInfo() {
        POPOSigningKeyInput pOPOSigningKeyInput;
        if (this.a == 1 && (pOPOSigningKeyInput = this.b.ski) != null) {
            return pOPOSigningKeyInput.authInfo;
        }
        return null;
    }

    public int getPOPofPrivKeyType() {
        int n2 = this.a;
        if (n2 != 2 && n2 != 3) {
            return -1;
        }
        return this.c.selected;
    }

    public byte[] getEncryptedKey() {
        int n2 = object.a;
        if (n2 != 2 && n2 != 3) {
            return null;
        }
        Object object = object.c;
        if (((POPOPrivKey)object).selected != 0) {
            return null;
        }
        return ((POPOPrivKey)object).bitStr.getAsByteArray();
    }

    public int getSubSequentMsgType() {
        int n2 = object.a;
        if (n2 != 2 && n2 != 3) {
            return -1;
        }
        Object object = object.c;
        if (((POPOPrivKey)object).selected != 1) {
            return -1;
        }
        return ((POPOPrivKey)object).subSeqMsg;
    }

    public byte[] getDHMAC() {
        int n2 = object.a;
        if (n2 != 2 && n2 != 3) {
            return null;
        }
        Object object = object.c;
        if (((POPOPrivKey)object).selected != 2) {
            return null;
        }
        return ((POPOPrivKey)object).bitStr.getAsByteArray();
    }

    public void setRAVerified() {
        this.a = 0;
    }

    public void setSignature(GeneralName generalName, PublicKey publicKey) throws InvalidKeyException {
        ProofOfPossession proofOfPossession = this;
        proofOfPossession.b.itsModified();
        POPOSigningKeyInput pOPOSigningKeyInput = proofOfPossession.b.ski;
        AuthInfo authInfo = pOPOSigningKeyInput.authInfo;
        authInfo.sender = generalName;
        authInfo.selected = 0;
        pOPOSigningKeyInput.pubki.setPublicKey(publicKey);
        proofOfPossession.a = 1;
    }

    public void setSignature(PKMACValue pKMACValue, PublicKey publicKey) throws InvalidKeyException {
        ProofOfPossession proofOfPossession = this;
        proofOfPossession.b.itsModified();
        POPOSigningKeyInput pOPOSigningKeyInput = proofOfPossession.b.ski;
        AuthInfo authInfo = pOPOSigningKeyInput.authInfo;
        authInfo.pMac = pKMACValue;
        authInfo.selected = 1;
        pOPOSigningKeyInput.pubki.setPublicKey(publicKey);
        proofOfPossession.a = 1;
    }

    public void signSignature(PrivateKey privateKey, AlgorithmID algorithmID) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this.signSignature(privateKey, algorithmID, "Initech");
    }

    public void signSignature(PrivateKey privateKey, AlgorithmID algorithmID, String string2) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        try {
            this.signSignature(privateKey, algorithmID, string2, this.b.ski.getEncoded());
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SignatureException(aSN1Exception.toString());
        }
    }

    public void signSignature(PrivateKey privateKey, AlgorithmID algorithmID, String string2, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        try {
            Signature signature = Signature.getInstance(algorithmID.getAlgName(), string2);
            signature.initSign(privateKey);
            signature.update(byArray);
            this.signSignature(signature.sign(), algorithmID);
            return;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.toString());
        }
    }

    public void signSignature(byte[] byArray, AlgorithmID algorithmID) {
        this.b.algId = (AlgorithmID)algorithmID.clone();
        this.b.signature.setByteArray(byArray);
        this.a = 1;
    }

    public void signSignature(USIMAdapter uSIMAdapter, AlgorithmID algorithmID, boolean bl) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        ProofOfPossession proofOfPossession = object;
        ProofOfPossession proofOfPossession2 = proofOfPossession;
        ProofOfPossession proofOfPossession3 = proofOfPossession;
        ((ProofOfPossession)object).b.algId = (AlgorithmID)algorithmID.clone();
        Object object = uSIMAdapter.sign(algorithmID, ((ProofOfPossession)object).b.ski.getEncoded(), bl);
        try {
            proofOfPossession2.b.signature.setByteArray((byte[])object);
            proofOfPossession3.a = 1;
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SignatureException(aSN1Exception.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SignatureException(noSuchProviderException.toString());
        }
    }

    public boolean verifySignature(PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        try {
            return this.verifySignature(publicKey, this.b.ski.getEncoded());
        }
        catch (ASN1Exception aSN1Exception) {
            aSN1Exception.printStackTrace();
            throw new SignatureException(aSN1Exception.toString());
        }
    }

    public boolean verifySignature(PublicKey publicKey, String string2) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        try {
            return this.verifySignature(publicKey, string2, this.b.ski.getEncoded());
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SignatureException(aSN1Exception.toString());
        }
    }

    public boolean verifySignature(PublicKey publicKey, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        String string2 = this.b.algId.getAlgName();
        int n2 = string2.indexOf("with");
        if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        return new RSAAutoSignature(publicKey, byArray, this.b.signature.getAsByteArray(), string2).verify();
    }

    public boolean verifySignature(PublicKey publicKey, String string2, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        block5: {
            try {
                string2 = this.b.algId.getAlgName();
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException(exception.toString());
            }
            int n2 = string2.indexOf("with");
            if (n2 == -1) break block5;
            string2 = string2.substring(0, n2);
        }
        return new RSAAutoSignature(publicKey, byArray, this.b.signature.getAsByteArray(), string2).verify();
    }

    public void setPOPThisMsg(int n2, byte[] byArray) {
        this.c.bitStr.setByteArray(byArray);
        this.c.selected = 0;
        this.a = n2;
    }

    public void setPOPSubSeqMsg(int n2, int n3) {
        POPOPrivKey pOPOPrivKey = this.c;
        pOPOPrivKey.subSeqMsg = n3;
        pOPOPrivKey.selected = 1;
        this.a = n2;
    }

    public void setPOPDHMac(int n2, byte[] byArray) {
        this.c.bitStr.setByteArray(byArray);
        this.c.selected = 2;
        this.a = n2;
    }

    public byte[] getSigningKeyInputData() throws SignatureException {
        try {
            return this.b.ski.getEncoded();
        }
        catch (ASN1Exception aSN1Exception) {
            throw new SignatureException(aSN1Exception.toString());
        }
    }
}

