/*
 * Decompiled with CFR 0.152.
 */
package com.initech.inibase.logger;

import com.initech.inibase.logger.FileAppender;
import com.initech.inibase.logger.Layout;
import com.initech.inibase.logger.helpers.CountingQuietWriter;
import com.initech.inibase.logger.helpers.LogLog;
import com.initech.inibase.logger.helpers.OptionConverter;
import com.initech.inibase.logger.spi.LoggingEvent;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class RollingFileAppender
extends FileAppender {
    public long maxFileSize = 0xA00000L;
    public int maxBackupIndex = 1;

    public RollingFileAppender() {
    }

    public RollingFileAppender(Layout layout, String string, boolean bl) throws IOException {
        super(layout, string, bl);
    }

    public RollingFileAppender(Layout layout, String string) throws IOException {
        super(layout, string);
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void rollOver() {
        boolean bl;
        RollingFileAppender rollingFileAppender;
        RollingFileAppender rollingFileAppender2;
        RollingFileAppender rollingFileAppender3;
        Object object;
        LogLog.debug("rolling over count=" + ((CountingQuietWriter)this.qw).getCount());
        LogLog.debug("maxBackupIndex=" + this.maxBackupIndex);
        if (this.maxBackupIndex > 0) {
            File file;
            File file2;
            File file3;
            File file4;
            File file5 = file4;
            if (new File(this.fileName + '.' + this.maxBackupIndex).exists()) {
                file5.delete();
            }
            for (int i2 = this.maxBackupIndex - 1; i2 > 0; --i2) {
                File file6;
                File file7;
                file3 = file7;
                if (!new File(this.fileName + "." + i2).exists()) continue;
                File file8 = file6;
                file6 = new File(this.fileName + '.' + (i2 + 1));
                LogLog.debug("Renaming file " + file3 + " to " + file8);
                file3.renameTo(file6);
            }
            object = file2;
            file2 = new File(this.fileName + ".1");
            this.closeFile();
            file3 = file;
            file3(this.fileName);
            LogLog.debug("Renaming file " + file3 + " to " + object);
            file.renameTo((File)object);
        }
        try {
            RollingFileAppender rollingFileAppender4 = this;
            rollingFileAppender3 = rollingFileAppender4;
            rollingFileAppender2 = rollingFileAppender4;
            rollingFileAppender = rollingFileAppender4;
            object = rollingFileAppender4.fileName;
            bl = false;
        }
        catch (IOException iOException) {
            LogLog.error("setFile(" + this.fileName + ", false) call failed.", iOException);
            return;
        }
        boolean bl2 = rollingFileAppender3.bufferedIO;
        int n2 = rollingFileAppender2.bufferSize;
        rollingFileAppender.setFile((String)object, bl, bl2, n2);
    }

    @Override
    public synchronized void setFile(String string, boolean bl, boolean bl2, int n2) throws IOException {
        RollingFileAppender rollingFileAppender = file2;
        bl2 = rollingFileAppender.bufferedIO;
        n2 = rollingFileAppender.bufferSize;
        super.setFile(string, bl, bl2, n2);
        if (bl) {
            File file;
            RollingFileAppender rollingFileAppender2 = file2;
            File file2 = file;
            file = new File(string);
            ((CountingQuietWriter)rollingFileAppender2.qw).setCount(file2.length());
        }
    }

    public void setMaxBackupIndex(int n2) {
        this.maxBackupIndex = n2;
    }

    public void setMaximumFileSize(long l2) {
        this.maxFileSize = l2;
    }

    public void setMaxFileSize(String string) {
        this.maxFileSize = OptionConverter.toFileSize(string, this.maxFileSize + 1L);
    }

    @Override
    public void setQWForFiles(Writer writer) {
        CountingQuietWriter countingQuietWriter;
        CountingQuietWriter countingQuietWriter2 = countingQuietWriter;
        countingQuietWriter = new CountingQuietWriter(writer, this.errorHandler);
        this.qw = countingQuietWriter2;
    }

    @Override
    public void subAppend(LoggingEvent loggingEvent) {
        RollingFileAppender rollingFileAppender = this;
        super.subAppend(loggingEvent);
        if (rollingFileAppender.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.rollOver();
        }
    }
}

