/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkix.cmp;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.pkix.cmp.PKIStatusInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class CertStatus
implements ASN1Type {
    public byte[] a;
    public int b;
    public PKIStatusInfo c;

    public CertStatus() {
    }

    public CertStatus(X509Certificate x509Certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        CertStatus certStatus = this;
        certStatus.setCertHash(x509Certificate);
    }

    public byte[] getCertHash() {
        return this.a;
    }

    public void setCertHash(byte[] byArray) {
        this.a = (byte[])byArray.clone();
    }

    public void setCertHash(X509Certificate x509Certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        String string = x509Certificate.getSigAlgName();
        String string2 = null;
        if (string.indexOf("SHA1") >= 0) {
            string2 = "SHA1";
        } else if (string.indexOf("SHA-256") < 0 && string.indexOf("SHA256") < 0) {
            if (string.indexOf("SHA-384") < 0 && string.indexOf("SHA384") < 0) {
                if (string.indexOf("SHA-512") < 0 && string.indexOf("SHA512") < 0) {
                    if (string.indexOf("MD5") >= 0) {
                        string2 = "MD5";
                    }
                } else {
                    string2 = "SHA-512";
                }
            } else {
                string2 = "SHA-384";
            }
        } else {
            string2 = "SHA-256";
        }
        this.a = MessageDigest.getInstance(string2).digest(x509Certificate.getEncoded());
    }

    public void setCertReqId(int n2) {
        this.b = n2;
    }

    public int getCertReqId() {
        return this.b;
    }

    public void setPKIStatusInfo(PKIStatusInfo pKIStatusInfo) {
        this.c = pKIStatusInfo;
    }

    public PKIStatusInfo getPKIStatusInfo() {
        return this.c;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        int n2 = aSN1Encoder.encodeSequence();
        aSN1Encoder.encodeOctetString(this.a);
        aSN1Encoder.encodeInteger(this.b);
        PKIStatusInfo pKIStatusInfo = this.c;
        if (pKIStatusInfo != null) {
            pKIStatusInfo.encode(aSN1Encoder);
        }
        aSN1Encoder.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        ASN1Decoder aSN1Decoder2 = aSN1Decoder;
        int n2 = aSN1Decoder2.decodeSequence();
        this.a = aSN1Decoder2.decodeOctetString();
        this.b = aSN1Decoder.decodeIntegerAsInt();
        if (!aSN1Decoder.endOf(n2)) {
            if (this.c == null) {
                PKIStatusInfo pKIStatusInfo;
                PKIStatusInfo pKIStatusInfo2 = pKIStatusInfo;
                pKIStatusInfo = new PKIStatusInfo();
                this.c = pKIStatusInfo2;
            }
            this.c.decode(aSN1Decoder);
            aSN1Decoder.endOf(n2);
        }
    }
}

