/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkix.cmp.info;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.pkix.cmp.info.InfoTypeAndValueContent;

public final class SigningKeyPairTypes
implements InfoTypeAndValueContent {
    public static final String OID = "1.3.6.1.5.5.7.4.2";
    public boolean a;
    public boolean b;
    public boolean c;
    public boolean d;
    public byte[] e;

    public SigningKeyPairTypes() {
    }

    public SigningKeyPairTypes(byte[] byArray) throws ASN1Exception {
        SigningKeyPairTypes signingKeyPairTypes = this;
        signingKeyPairTypes.decode((ASN1Decoder)new DERDecoder(byArray));
        this.e = (byte[])byArray.clone();
    }

    @Override
    public final String getOID() {
        return OID;
    }

    public final void setRSA(boolean bl) {
        this.a = bl;
    }

    public final void setDSA(boolean bl) {
        this.b = bl;
    }

    public final void setEC(boolean bl) {
        this.c = bl;
    }

    public final void setKCDSA(boolean bl) {
        this.d = bl;
    }

    public final void clear() {
        SigningKeyPairTypes signingKeyPairTypes = this;
        signingKeyPairTypes.a = false;
        signingKeyPairTypes.b = false;
        signingKeyPairTypes.c = false;
        signingKeyPairTypes.d = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final byte[] getEncoded() {
        DEREncoder dEREncoder;
        try {
            if (this.e != null) return this.e;
        }
        catch (Exception exception) {
            return null;
        }
        SigningKeyPairTypes signingKeyPairTypes = this;
        SigningKeyPairTypes signingKeyPairTypes2 = signingKeyPairTypes;
        SigningKeyPairTypes signingKeyPairTypes3 = signingKeyPairTypes;
        DEREncoder dEREncoder2 = dEREncoder;
        signingKeyPairTypes2.encode((ASN1Encoder)new DEREncoder());
        signingKeyPairTypes3.e = dEREncoder2.toByteArray();
        return this.e;
    }

    public final void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        int n2 = aSN1Decoder.decodeSequence();
        while (aSN1Decoder.endOf(n2)) {
            AlgorithmID algorithmID = new AlgorithmID();
            algorithmID.decode(aSN1Decoder);
            String string = algorithmID.getAlgName().toLowerCase();
            if (string.indexOf("rsa") >= 0) {
                this.a = true;
                continue;
            }
            if (string.indexOf("kcdsa") >= 0) {
                this.d = true;
                continue;
            }
            if (string.indexOf("dsa") >= 0) {
                this.b = true;
                continue;
            }
            if (string.indexOf("ec") < 0) continue;
            this.c = true;
        }
    }

    public final void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        int n2 = aSN1Encoder.encodeSequence();
        if (this.a) {
            AlgorithmID.rsaEncryption.encode(aSN1Encoder);
        }
        if (this.b) {
            AlgorithmID.dsa.encode(aSN1Encoder);
        }
        if (this.c) {
            AlgorithmID.ecPublicKey.encode(aSN1Encoder);
        }
        if (this.d) {
            AlgorithmID.kcdsa1.encode(aSN1Encoder);
        }
        aSN1Encoder.endOf(n2);
    }

    public final boolean RSA() {
        return this.a;
    }

    public final boolean DSA() {
        return this.b;
    }

    public final boolean EC() {
        return this.c;
    }

    public final boolean KCDSA() {
        return this.d;
    }
}

