package com.eugenefn.openapi.sample;

import com.eugenefn.openapi.sample.view.SampleBaseView;
import com.eugenefn.openapi.sample.view.dialog.LoginDialog;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.FrameLayout;

public class SampleFrameView
extends FrameLayout implements DialogInterface.OnDismissListener {
	private ProgressDialog		m_dlgProgress;
	private LoginDialog			m_dlgLogin = null;

	private SampleBaseView m_viewCurrent = null;

	private Activity m_activity;

	public SampleFrameView(Context context, Activity activity)
	{
		super(context);

		m_activity = activity;
	}

	public void setView(SampleBaseView view)
	{
		removeAllViews();
		
		addView(view, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
		m_viewCurrent = view;

		view.setParentFrame(this);
	}
	
	public void releaseView()
	{
		removeAllViews();
		m_viewCurrent = null;

		hideProgress();
	}
	
	public void showProgress(String strText)
	{
		if(m_dlgProgress == null)
		{
			m_dlgProgress = new ProgressDialog(getContext());
			m_dlgProgress.setProgressStyle(ProgressDialog.STYLE_SPINNER);
			m_dlgProgress.setIndeterminate(true);
			m_dlgProgress.setOnDismissListener(new DialogInterface.OnDismissListener()
			{
				@Override
				public void onDismiss(DialogInterface arg0)
				{
					m_dlgProgress = null;
				}
			});
		}

		m_dlgProgress.setMessage(strText);

		if(!m_dlgProgress.isShowing())
			m_dlgProgress.show();
	}
	
	public void hideProgress()
	{
		if(m_dlgProgress != null)
		{
			if(m_dlgProgress.isShowing())
				m_dlgProgress.dismiss();
			
			m_dlgProgress = null;
		}
	}

	public boolean onBackPressed()
	{
		if(m_viewCurrent != null)
		{
			if(m_viewCurrent.onBackPressed()) return true;
		}

		return false;
	}

	public void showLoginDialog()
	{
		if(m_dlgLogin != null)
		{
			if(m_dlgLogin.isShowing())
				m_dlgLogin.dismiss();
			m_dlgLogin = null;
		}

		m_dlgLogin = new LoginDialog(getContext(), m_activity);
		m_dlgLogin.setOnDismissListener(this);
		m_dlgLogin.show();
	}

	public void hideLoginDialog()
	{
		if(m_dlgLogin != null)
		{
			if(m_dlgLogin.isShowing())
				m_dlgLogin.dismiss();
			m_dlgLogin = null;
		}
	}

	public void onRefreshView()
	{
		if(m_viewCurrent != null)
			m_viewCurrent.onRefreshView();
	}

	@Override
	public void onDismiss(DialogInterface dialog) {
		m_dlgLogin = null;
	}
}
