package com.eugenefn.openapi.sample.view;

import com.eugenefn.openapi.sample.R;
import com.eugenefn.openapi.sample.view.control.UpdateProgress;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import android.content.Context;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

// 초기화면 뷰
public class SampleIntroView
extends SampleBaseView
{
	private TextView	m_textInfo;

	private UpdateProgress	m_viewProgress;

	public SampleIntroView(Context context)
	{
		super(context);

	}

	//초기화
	public void initView()
	{	
		
		//타이틀
		TextView viewTitle = LayoutUtil.makeTextView(getContext(), "SmartChamp\nOpen API sample", false);
		viewTitle.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 40);
		
		addView(viewTitle, new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT, Gravity.CENTER));

		ImageView viewComp = new ImageView(getContext());
		viewComp.setImageResource(R.drawable.eugene_logo_1);

		LayoutParams paramComp = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT, Gravity.RIGHT | Gravity.TOP);
		paramComp.rightMargin = paramComp.topMargin = (int)SampleUtil.dipToPixels(getContext(), 20);
		addView(viewComp, paramComp);

		ImageView viewLogo = new ImageView(getContext());
		viewLogo.setImageResource(R.drawable.smart_logo_01);
		
		LayoutParams paramLogo = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT, Gravity.CENTER_HORIZONTAL | Gravity.TOP);
		paramLogo.topMargin = (int)SampleUtil.dipToPixels(getContext(), 140);
		addView(viewLogo, paramLogo);
		
		TextView viewCopy = LayoutUtil.makeTextView(getContext(), "COPYRIGHT EUGENE INVESTMENT & SECURITIES CO.LTD.All RIGHTS RESERVED.");
		viewCopy.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 10);

		LayoutParams paramCopy = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT, Gravity.CENTER_HORIZONTAL | Gravity.BOTTOM);
		paramCopy.bottomMargin = (int)SampleUtil.dipToPixels(getContext(), 30);
		addView(viewCopy, paramCopy);

		m_textInfo = LayoutUtil.makeTextView(getContext(), "", 16, getColor(R.color.colorIntroInfo));
		LayoutParams paramInfo = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT, Gravity.CENTER_HORIZONTAL | Gravity.BOTTOM);
		paramInfo.bottomMargin = (int)SampleUtil.dipToPixels(getContext(), 160);
		addView(m_textInfo, paramInfo);

		m_viewProgress = new UpdateProgress(getContext());
		m_viewProgress.setVisibility(ViewGroup.INVISIBLE);

		LayoutParams paramProg = new LayoutParams(LayoutParams.MATCH_PARENT, (int)SampleUtil.dipToPixels(getContext(), 6), Gravity.BOTTOM);
		paramProg.leftMargin = paramProg.rightMargin = (int)SampleUtil.dipToPixels(getContext(), 30);
		paramProg.bottomMargin = (int)SampleUtil.dipToPixels(getContext(), 140);
		addView(m_viewProgress, paramProg);
	}
	
	
	public void releaseView()
	{
		removeAllViews();

		m_textInfo = null;
	}
	
	public void setInfoText(String strText)
	{
		if(m_textInfo != null)
			m_textInfo.setText(strText);
	}

	public void updateProgress(int nState, int nIndex, int nCount, String strMessage)
	{
		if(nState == 0)
		{
			if(m_viewProgress.getVisibility() != ViewGroup.VISIBLE)
				m_viewProgress.setVisibility(ViewGroup.VISIBLE);

			m_viewProgress.setProgress(nIndex, nCount);
		} else if(nState == 1)
		{
			m_textInfo.setText(strMessage);
		} else if(nState == 2)
		{
			if(m_viewProgress.getVisibility() == ViewGroup.VISIBLE)
				m_viewProgress.setVisibility(ViewGroup.INVISIBLE);

			m_textInfo.setText("");
		}
	}
}
