package com.eugenefn.openapi.sample.view.control;

import java.util.ArrayList;

import com.eugenefn.openapi.sample.view.util.SampleUtil;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;

@SuppressLint("AppCompatCustomView")
public class AccountSelectSpinner
extends Spinner
implements AdapterView.OnItemSelectedListener
{
	private ArrayList<AccInfo>	m_arrayAccounts;		// 계좌리스트
	
	private AccountListAdapter		m_adapter;
	private int						m_nCurrIndex = -1;
	
	private OnAccountSelectedListener		m_listener;
	
	public AccountSelectSpinner(Context context)
	{
		super(context);
		
		m_adapter = new AccountListAdapter();
		setOnItemSelectedListener(this);

		setPrompt("계좌 선택");

		m_arrayAccounts = new ArrayList<AccInfo>();
		setAdapter(m_adapter);
		
	}
	
	public void clearInstance()
	{
		setAdapter(null);
		
		if(m_arrayAccounts != null)
		{
			m_arrayAccounts.clear();
			m_arrayAccounts = null;
		}
	}
	
	public void setOnAccountSelectedListener(OnAccountSelectedListener listener)
	{
		m_listener = listener;
	}
	
	public String getAccountNo()
	{
		if(m_arrayAccounts == null) return "";
		if(m_nCurrIndex < 0 || m_nCurrIndex >= m_arrayAccounts.size()) return "";
		
		return m_arrayAccounts.get(m_nCurrIndex).m_strAccNo;
	}
	
	public void setAccountNo(String strNo)
	{
		if(m_arrayAccounts == null) return;
		
		for(int i = 0; i < m_arrayAccounts.size(); i++)
		{
			if(m_arrayAccounts.get(i).m_strAccNo.equals(strNo))
			{
				m_nCurrIndex = i;
				setSelection(i);
				return;
			}
		}
	}
	
	public void resetAccountList()
	{
		m_arrayAccounts.clear();
		m_adapter.notifyDataSetChanged();
	}
	
	public void addAccountList(String strAccNo, String strAccName)
	{
		AccInfo infoAcc = new AccInfo();
		
		infoAcc.m_strAccNo = strAccNo;
		infoAcc.m_strAccName = strAccName;
		
		m_arrayAccounts.add(infoAcc);
		
		m_adapter.notifyDataSetChanged();
	}
	
	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int pos, long id)
	{
		if(m_arrayAccounts != null)
		{
			if(pos >= 0 && pos < m_arrayAccounts.size())
			{
				m_nCurrIndex = pos;
				
				if(m_listener != null)
					m_listener.onAccountSelected(m_arrayAccounts.get(pos).m_strAccNo);
			}
		}		
	}

	@Override
	public void onNothingSelected(AdapterView<?> parent)
	{
	}
	
	public interface OnAccountSelectedListener
	{
		public abstract void onAccountSelected(String strNo);
	}
	
	public class AccInfo
	extends Object
	{
		public String m_strAccNo;
		public String m_strAccName;
		
		public String getAccNoText()
		{
			if(m_strAccNo.length() <= 0) return "";
			
			if (m_strAccNo.length() == 12) // 신계좌
				return m_strAccNo.substring(0, 4) + "-" + m_strAccNo.substring(4, 8) + "-" + m_strAccNo.substring(8) + "(" + m_strAccName + ")";
			else // 구계좌
				return m_strAccNo.substring(0, 3) + "-" + m_strAccNo.substring(3, 5) + "-" + m_strAccNo.substring(5) + "(" + m_strAccName + ")";
		}
	}
	
	private class AccountListAdapter
	extends BaseAdapter
	implements SpinnerAdapter
	{
		@Override
		public Object getItem(int arg0)
		{
			if(m_arrayAccounts == null) return null;
			if(arg0 < 0 || arg0 >= m_arrayAccounts.size()) return null;
			
			return m_arrayAccounts.get(arg0);
		}

		@Override
		public long getItemId(int arg0)
		{
			return (long)arg0;
		}

		@Override
		public View getView(int pos, View convertView, ViewGroup parent)
		{
			TextView viewItem = (TextView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new TextView(parent.getContext());
				viewItem.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);
				viewItem.setTextColor(Color.DKGRAY);
				viewItem.setSingleLine();
				viewItem.setPadding(20, 0, 0, 20);
				viewItem.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
			}
			
			Object obj = getItem(pos);
			if(obj != null && obj instanceof AccInfo)
			{
				viewItem.setText(((AccInfo)obj).getAccNoText());
			} else {
				viewItem.setText("");
			}
			
			return viewItem;
		}

		@Override
		public boolean isEmpty()
		{
			return (m_arrayAccounts == null || m_arrayAccounts.size() < 0) ? true : false;
		}

		@Override
		public View getDropDownView(int pos, View convertView, ViewGroup viewParent)
		{
			TextView viewItem = (TextView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new TextView(viewParent.getContext());
				viewItem.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);
				viewItem.setTextColor(Color.DKGRAY);
				viewItem.setSingleLine();
				viewItem.setPadding(20, 20, 20, 20);
				viewItem.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
				
				viewItem.setLayoutParams(new LayoutParams(LayoutParams.WRAP_CONTENT, (int)SampleUtil.dipToPixels(viewParent.getContext(), 40)));
			}
			
			Object obj = getItem(pos);
			if(obj != null && obj instanceof AccInfo)
			{
				viewItem.setText(((AccInfo)obj).getAccNoText());
			} else {
				viewItem.setText("");
			}
			
			return viewItem;
		}

		@Override
		public int getCount()
		{
			if(m_arrayAccounts == null) return 0;
			
			return m_arrayAccounts.size();
		}
	}
}
