package com.eugenefn.openapi.sample.view.control;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;

import java.util.ArrayList;

@SuppressLint("AppCompatCustomView")
public class CertSelectSpinner
extends Spinner
implements AdapterView.OnItemSelectedListener
{
	private ArrayList<String> m_arrayCert;	// 인증서리스트
	
	private CertListAdapter m_adapter;
	
	private int				m_nCurrIndex = -1;
	
	private OnCertSelectedListener		m_listener;
	
	public CertSelectSpinner(Context context)
	{
		super(context);

		m_adapter = new CertListAdapter();
		setOnItemSelectedListener(this);
		
		setPrompt("인증서 선택");
	}

	public void setOnCertSelectedListener(OnCertSelectedListener listener)
	{
		m_listener = listener;
	}
	
	public String getCertDN()
	{
		if(m_arrayCert == null) return "";
		if(m_nCurrIndex < 0 || m_nCurrIndex >= m_arrayCert.size()) return "";
		
		return m_arrayCert.get(m_nCurrIndex);
	}
	
	public void setCertDN(String strDN)
	{
		if(m_arrayCert == null) return;
		
		for(int i = 0; i < m_arrayCert.size(); i++)
		{
			if(m_arrayCert.get(i).equals(strDN))
			{
				m_nCurrIndex = i;
				setSelection(i);
				return;
			}
		}
	}
	
	public void setCertList(ArrayList<String> array)
	{
		m_arrayCert = array;
		
		setAdapter(m_adapter);
		m_adapter.notifyDataSetChanged();
	}
	
	public void clearInstance()
	{
		setAdapter(null);
		
		if(m_arrayCert != null)
		{
			m_arrayCert.clear();
			m_arrayCert = null;
		}
	}

	public void setEnabled(boolean isEnabled)
	{
		super.setEnabled(isEnabled);
		
		if(m_adapter != null)
		{
			m_adapter.notifyDataSetChanged();
		}
	}
	
	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int pos, long id)
	{
		if(m_arrayCert != null)
		{
			if(pos >= 0 && pos < m_arrayCert.size())
			{
				m_nCurrIndex = pos;
				
				if(m_listener != null)
					m_listener.onCertSelected(m_arrayCert.get(pos));
			}
		}		
	}

	@Override
	public void onNothingSelected(AdapterView<?> parent)
	{
	}
	
	public interface OnCertSelectedListener
	{
		public abstract void onCertSelected(String strDN);
	}
	
	private class CertListAdapter
	extends BaseAdapter
	implements SpinnerAdapter
	{
		@Override
		public Object getItem(int arg0)
		{
			if(m_arrayCert == null) return null;
			if(arg0 < 0 || arg0 >= m_arrayCert.size()) return null;
			
			return m_arrayCert.get(arg0);
		}

		@Override
		public long getItemId(int arg0)
		{
			return (long)arg0;
		}

		@Override
		public View getView(int pos, View convertView, ViewGroup parent)
		{
			TextView viewItem = (TextView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new TextView(parent.getContext());
				viewItem.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
				viewItem.setTextColor(CertSelectSpinner.this.isEnabled() ? Color.BLACK : Color.LTGRAY);
				viewItem.setSingleLine();
			}
			
			Object obj = getItem(pos);
			if(obj != null && obj instanceof String)
			{
				viewItem.setText((String)obj);
			} else {
				viewItem.setText("");
			}
			
			return viewItem;
		}

		@Override
		public boolean isEmpty()
		{
			return (m_arrayCert == null || m_arrayCert.size() < 0) ? true : false;
		}

		@Override
		public View getDropDownView(int pos, View convertView, ViewGroup viewParent)
		{
			TextView viewItem = (TextView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new TextView(viewParent.getContext());
				viewItem.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
				viewItem.setPadding(20, 20, 20, 20);
				viewItem.setTextColor(CertSelectSpinner.this.isEnabled() ? Color.BLACK : Color.LTGRAY);
			}
			
			Object obj = getItem(pos);
			if(obj != null && obj instanceof String)
			{
				viewItem.setText((String)obj);
			} else {
				viewItem.setText("");
			}
			
			return viewItem;
		}

		@Override
		public int getCount()
		{
			if(m_arrayCert == null) return 0;
			return m_arrayCert.size();
		}
	}
}
