package com.eugenefn.openapi.sample.view.control;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.TypedValue;
import android.view.Gravity;
import android.widget.Button;

import com.eugenefn.openapi.sample.view.data.FIDInfo;
import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import java.util.ArrayList;
import java.util.Arrays;

@SuppressLint("AppCompatCustomView")
public class FIDSelectButton extends Button
    implements DialogInterface.OnMultiChoiceClickListener
{
    private ArrayList<FIDInfo> m_arrItems;
    private boolean [] m_arrTemp;
    private ArrayList<String> m_arrSelected;

    private OnFIDSelectionChangedListener m_listener;

    public interface OnFIDSelectionChangedListener
    {
        public abstract void onFIDSelectionChanged(ArrayList<String> arrList);
    }

    public FIDSelectButton(Context context, OnFIDSelectionChangedListener listener)
    {
        super(context);

        m_listener = listener;

        setTextColor(ColorUtil.NOR_TEXT_COLOR);
        setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        setGravity(Gravity.CENTER);
        setSingleLine();

        int nPaddingH = (int) SampleUtil.dipToPixels(context, 2);;
        setPadding(nPaddingH, 0, nPaddingH, 0);

        m_arrItems = FIDInfo.arrFIDInfo;
        m_arrSelected = new ArrayList<>();

        m_arrTemp = new boolean[m_arrItems.size()];
        Arrays.fill(m_arrTemp, (boolean) false);
    }

    private void updateButtonText()
    {
        int nCount = m_arrSelected == null ? 0 : m_arrSelected.size();

        setText(String.format("%d개 필드", nCount));
    }

    private void rebuildSelectedList()
    {
        m_arrSelected.clear();

        for(int i = 0; i < m_arrTemp.length; i++)
        {
            if(m_arrTemp[i])
                m_arrSelected.add(m_arrItems.get(i).m_strId);
        }
    }

    private void resetSelectedTemp()
    {
        Arrays.fill(m_arrTemp, (boolean)false);

        for(String strId : m_arrSelected)
        {
            for(int i = 0; i < m_arrItems.size(); i++)
            {
                if(m_arrItems.get(i).m_strId.equals(strId))
                {
                    m_arrTemp[i] = true;
                    break;
                }
            }
        }
    }

    public void setDefaultList()
    {
        ArrayList<String> arrDef = new ArrayList<>();
        arrDef.add("9001");
        arrDef.add("9002");
        arrDef.add("9003");
        setSelection(arrDef);
    }

    public void setSelection(ArrayList<String> arrSelection)
    {
        m_arrSelected.clear();
        m_arrSelected.addAll(arrSelection);

        resetSelectedTemp();
        updateButtonText();
    }

    public ArrayList<String> getSelectedItems()
    {
        rebuildSelectedList();

        return new ArrayList<>(m_arrSelected);
    }

    public String getFIDCount()
    {
        return String.format("%02d", m_arrSelected.size());
    }

    public String getFIDList()
    {
        StringBuilder builder = new StringBuilder();
        for(String strFid : m_arrSelected)
            builder.append(strFid);
        return builder.toString();
    }

    @Override
    public boolean performClick()
    {
        super.performClick();

        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());

        String[] itemNames = new String[m_arrItems.size()];

        for (int i = 0; i < m_arrItems.size(); i++) {
            itemNames[i] = m_arrItems.get(i).getSelectName();
        }

        resetSelectedTemp();

        builder.setMultiChoiceItems(itemNames, m_arrTemp, this);

        builder.setPositiveButton("확인", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface arg0, int arg1)
            {
                rebuildSelectedList();
                updateButtonText();

                if(m_listener != null)
                    m_listener.onFIDSelectionChanged(getSelectedItems());
            }
        });

        builder.show();

        return true;
    }

    @Override
    public void onClick(DialogInterface dialog, int which, boolean isChecked) {
        if(m_arrTemp == null) return;
        if(which < 0 || which >= m_arrTemp.length) return;

        m_arrTemp[which] = isChecked;
    }
}
