package com.eugenefn.openapi.sample.view.control;

import java.util.ArrayList;
import java.util.HashMap;

import com.eugenefn.openapi.proc.SmartChampAPI;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.AdapterView;

@SuppressLint("AppCompatCustomView")
public class ItemCodeSpinner
extends Spinner
implements AdapterView.OnItemSelectedListener
{
	private ArrayList<String> m_arrayItems;	// 종목 리스트
	
	private ItemListAdapter	m_adapter;
	private String		m_itemCurr;
	private HashMap<String, Integer> m_mapCodes;

	private int ITEM_HEIGHT;
	private int PADDING_H;
	private int ITEM_CODE_WIDTH;

	private OnItemCodeSelectedListener m_listener;
	
	public ItemCodeSpinner(Context context)
	{
		super(context);

		DisplayMetrics metrics = context.getResources().getDisplayMetrics();
		ITEM_HEIGHT = (int)TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 40, metrics);
		PADDING_H = (int)TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 20, metrics);
		ITEM_CODE_WIDTH = (int)TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 80, metrics);
		
		m_adapter = new ItemListAdapter();
		m_mapCodes = new HashMap<String, Integer>();

		setPrompt("종목 선택");
		setOnItemSelectedListener(this);
	}
	
	public void setOnItemCodeSelectedListener(OnItemCodeSelectedListener listener)
	{
		m_listener = listener;
	}
	
	public String getItemCode()
	{
		if(m_itemCurr == null) return "";
		
		return m_itemCurr;
	}

	public String getItemType()
	{
		if(m_itemCurr == null) return "";
		
		//return m_itemCurr.getMarketTypeCode();
		return "";
	}
	
	public String setItemCode(String strItemCode)
	{
		strItemCode = strItemCode.trim();

		if(m_mapCodes.containsKey(strItemCode))
		{
			int nIndex = m_mapCodes.get(strItemCode);
			setSelection(nIndex, false);
			
			m_itemCurr = m_arrayItems.get(nIndex);
			
			return strItemCode;
		} else if(m_arrayItems != null && m_arrayItems.size() > 0)
		{
			setSelection(0, false);

			m_itemCurr = m_arrayItems.get(0);

			return strItemCode;
		}
		
		return "";
	}
	
	public void setItemList(ArrayList<String> array)
	{
		m_arrayItems = new ArrayList<>(array);
		m_itemCurr = null;
		
		for(int nIndex = 0; nIndex < array.size(); nIndex++)
		{
			m_mapCodes.put(array.get(nIndex), nIndex);
		}
		
		setAdapter(m_adapter);
		//m_adapter.notifyDataSetChanged();
	}
	
	public void clearInstance()
	{
		setAdapter(null);
		
		if(m_arrayItems != null)
		{
			m_arrayItems = null;
		}
	}

	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int position, long id)
	{
		Object obj = getItemAtPosition(position);
		if(obj == null) return;
		
		m_itemCurr = (String)obj;
		
		if(m_listener != null)
		{
			m_listener.onItemSelected(m_itemCurr,
					SmartChampAPI.getInstance().getItemCodeInfo(m_itemCurr, "name"),
					SmartChampAPI.getInstance().getItemCodeInfo(m_itemCurr, "type")
					);
		}
	}

	@Override
	public void onNothingSelected(AdapterView<?> parent)
	{
	}

	private class ItemListAdapter
	extends BaseAdapter
	implements SpinnerAdapter
	{

		@Override
		public int getCount()
		{
			if(m_arrayItems == null) return 0;
			
			return m_arrayItems.size();
		}

		@Override
		public Object getItem(int nPos)
		{
			if(m_arrayItems == null) return null;
			if(nPos < 0 || nPos >= m_arrayItems.size()) return null;
			
			return m_arrayItems.get(nPos);
		}

		@Override
		public long getItemId(int nPos)
		{
			return nPos;
		}

		@Override
		public View getView(int nPos, View convertView, ViewGroup parent)
		{
			TextView viewItem = (TextView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new TextView(parent.getContext());
				viewItem.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
				viewItem.setTextColor(Color.BLACK);
				viewItem.setSingleLine();
				viewItem.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
			}
			
			Object obj = getItem(nPos);
			if(obj != null && obj instanceof String)
			{
				viewItem.setText(SmartChampAPI.getInstance().getItemCodeInfo((String)obj, "name"));
			} else {
				viewItem.setText("");
			}
			
			return viewItem;
		}
		
		@Override
		public View getDropDownView(int nPos, View convertView, ViewGroup parent)
		{
			DropDownItemView viewItem = (DropDownItemView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new DropDownItemView(parent.getContext());
				viewItem.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, ITEM_HEIGHT));
			}
			
			Object obj = getItem(nPos);
			if(obj != null && obj instanceof String)
			{
				viewItem.setItemInfo((String)obj);
			} else {
				viewItem.clearInfo();
			}
			
			return viewItem;
		}
	}

	public interface OnItemCodeSelectedListener
	{
		abstract void onItemSelected(String strCode, String strName, String strMarket);
	}
	
	private class DropDownItemView
	extends LinearLayout
	{
		private TextView	m_viewItemCode;
		private TextView	m_viewItemName;
		
		private DropDownItemView(Context context)
		{
			super(context);

			setOrientation(LinearLayout.HORIZONTAL);
			setPadding(PADDING_H, 0, PADDING_H, 0);
			
			m_viewItemCode = new TextView(context);
			m_viewItemCode.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
			m_viewItemCode.setTextColor(Color.BLUE);
			m_viewItemCode.setSingleLine();
			m_viewItemCode.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
			
			m_viewItemName = new TextView(context);
			m_viewItemName.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);
			m_viewItemName.setTextColor(Color.DKGRAY);
			m_viewItemName.setSingleLine();
			m_viewItemName.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
			m_viewItemName.setEllipsize(TextUtils.TruncateAt.END);
			
			addView(m_viewItemCode, new LayoutParams(ITEM_CODE_WIDTH, LayoutParams.MATCH_PARENT));
			addView(m_viewItemName, new LayoutParams(0, LayoutParams.MATCH_PARENT, 1));
		}
	
		private void setItemInfo(String code)
		{
			m_viewItemCode.setText(code);
			m_viewItemName.setText(SmartChampAPI.getInstance().getItemCodeInfo(code, "name"));
		}
		
		private void clearInfo()
		{
			m_viewItemCode.setText("");
			m_viewItemName.setText("");
		}
	}
}
