package com.eugenefn.openapi.sample.view.control;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.util.Pair;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;

import java.util.ArrayList;

@SuppressLint("AppCompatCustomView")
public class ItemSelectSpinner
extends Spinner
implements AdapterView.OnItemSelectedListener
{
	private ArrayList<Pair<String,String>> m_arrayItems;	// 리스트

	private ItemListAdapter m_adapter;

	private int				m_nCurrIndex = -1;
	private int m_nListMode = 0;	// 0 : 값, 1 : 키 + 값

	private OnItemSelectedListener m_listener;

	public ItemSelectSpinner(Context context, String strPrompt)
	{
		super(context);

		m_adapter = new ItemListAdapter();
		setOnItemSelectedListener(this);
		
		setPrompt(strPrompt);
	}

	public void setListMode(int nMode)
	{
		m_nListMode = nMode;
	}

	public void setOnItemSelectedListener(OnItemSelectedListener listener)
	{
		m_listener = listener;
	}
	
	public String getSelectedKey()
	{
		if(m_arrayItems == null) return "";
		if(m_nCurrIndex < 0 || m_nCurrIndex >= m_arrayItems.size()) return "";
		
		return m_arrayItems.get(m_nCurrIndex).first;
	}
	
	public void selectItemByKey(String strKey)
	{
		if(m_arrayItems == null) return;
		
		for(int i = 0; i < m_arrayItems.size(); i++)
		{
			if(m_arrayItems.get(i).first.equals(strKey))
			{
				m_nCurrIndex = i;
				setSelection(i);
				return;
			}
		}

		if(m_arrayItems.size() > 0)
		{
			m_nCurrIndex = 0;
			setSelection(0);
		}
	}
	
	public void setItemList(ArrayList<Pair<String, String>> array)
	{
		m_arrayItems = array;
		
		setAdapter(m_adapter);
		m_adapter.notifyDataSetChanged();
	}
	
	public void clearInstance()
	{
		setAdapter(null);
		
		if(m_arrayItems != null)
		{
			m_arrayItems.clear();
			m_arrayItems = null;
		}
	}

	public void setEnabled(boolean isEnabled)
	{
		super.setEnabled(isEnabled);
		
		if(m_adapter != null)
		{
			m_adapter.notifyDataSetChanged();
		}
	}
	
	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int pos, long id)
	{
		if(m_arrayItems != null)
		{
			if(pos >= 0 && pos < m_arrayItems.size())
			{
				m_nCurrIndex = pos;
				
				if(m_listener != null)
					m_listener.onItemSelected(m_arrayItems.get(pos).first, m_arrayItems.get(pos).second);
			}
		}		
	}

	@Override
	public void onNothingSelected(AdapterView<?> parent)
	{
	}
	
	public interface OnItemSelectedListener
	{
		public abstract void onItemSelected(String strKey, String srValue);
	}
	
	private class ItemListAdapter
	extends BaseAdapter
	implements SpinnerAdapter
	{
		@Override
		public Object getItem(int arg0)
		{
			if(m_arrayItems == null) return null;
			if(arg0 < 0 || arg0 >= m_arrayItems.size()) return null;
			
			return m_arrayItems.get(arg0);
		}

		@Override
		public long getItemId(int arg0)
		{
			return (long)arg0;
		}

		@Override
		public View getView(int pos, View convertView, ViewGroup parent)
		{
			TextView viewItem = (TextView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new TextView(parent.getContext());
				viewItem.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
				viewItem.setTextColor(ItemSelectSpinner.this.isEnabled() ? Color.BLACK : Color.LTGRAY);
				viewItem.setSingleLine();
			}
			
			Object obj = getItem(pos);
			if(obj != null && obj instanceof Pair<?,?>)
			{
				viewItem.setText(((Pair<String,String>)obj).second);
			} else {
				viewItem.setText("");
			}
			
			return viewItem;
		}

		@Override
		public boolean isEmpty()
		{
			return (m_arrayItems == null || m_arrayItems.size() < 0) ? true : false;
		}

		@Override
		public View getDropDownView(int pos, View convertView, ViewGroup viewParent)
		{
			TextView viewItem = (TextView)convertView;
			
			if(viewItem == null)
			{
				viewItem = new TextView(viewParent.getContext());
				viewItem.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
				viewItem.setPadding(20, 20, 20, 20);
				viewItem.setTextColor(ItemSelectSpinner.this.isEnabled() ? Color.BLACK : Color.LTGRAY);
			}
			
			Object obj = getItem(pos);
			if(obj != null && obj instanceof Pair<?,?>)
			{
				if(m_nListMode == 1)
				{
					viewItem.setText(((Pair<String, String>) obj).first + "\t" + ((Pair<String, String>) obj).second);
				} else {
					viewItem.setText(((Pair<String, String>) obj).second);
				}
			} else {
				viewItem.setText("");
			}
			
			return viewItem;
		}

		@Override
		public int getCount()
		{
			if(m_arrayItems == null) return 0;
			return m_arrayItems.size();
		}
	}
}
