package com.eugenefn.openapi.sample.view.control;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;

import androidx.annotation.NonNull;

import com.eugenefn.openapi.sample.R;
import com.eugenefn.openapi.sample.view.util.ColorUtil;

public class UpdateProgress
    extends View
{
    private int m_nCount = 0;
    private int m_nIndex = 0;

    private int m_nProgColor = 0;

    public UpdateProgress(@NonNull Context context)
    {
        super(context);

        setBackgroundColor(ColorUtil.getColor(context, R.color.introProgressBar));
        m_nProgColor = ColorUtil.getColor(context, R.color.introProgressInd);
    }

    public void setProgress(int nIndex, int nCount)
    {
        m_nCount = nCount;
        m_nIndex = nIndex;

        invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);

        if(m_nCount > 0)
        {
            Paint paint = new Paint();
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(m_nProgColor);

            int nWidth = getWidth();

            int nPos = m_nIndex;
            if(nPos < 0) nPos = 0;
            else if(nPos > m_nCount) nPos = m_nCount;

            canvas.drawRect(0, 0, ((float)nPos / m_nCount * nWidth), getHeight(), paint);
        }
    }


}
